
<?php $__env->startSection('title', 'Kurumlar'); ?>

<?php $__env->startSection('page-actions'); ?>
<div class="col-auto ms-auto d-print-none">
    <a href="<?php echo e(route('superadmin.kurumlar.create')); ?>" class="btn btn-primary">
        <i class="ti ti-plus me-1"></i>
        Yeni Kurum Ekle
    </a>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row row-cards">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Kurum Listesi</h3>
            </div>
            <div class="table-responsive">
                <table class="table table-vcenter card-table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Kurum Adı</th>
                            <th>Slug</th>
                            <th>Ana Domain</th>
                            <th>Özel Domain</th>
                            <th>Durum</th>
                            <th class="w-1">İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $kurumlar; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kurum): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td class="text-muted"><?php echo e($kurum->id); ?></td>
                            <td>
                                <div class="d-flex py-1 align-items-center">
                                    <span class="avatar me-2" style="background-image: url(https://ui-avatars.com/api/?name=<?php echo e(urlencode($kurum->ad)); ?>&background=206bc4&color=fff)"></span>
                                    <div class="flex-fill">
                                        <div class="font-weight-medium"><?php echo e($kurum->ad); ?></div>
                                        <div class="text-muted"><a href="#" class="text-reset"><?php echo e($kurum->slug); ?></a></div>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="badge badge-outline text-muted"><?php echo e($kurum->slug); ?></span>
                            </td>
                            <td class="text-muted"><?php echo e($kurum->ana_domain ?? '-'); ?></td>
                            <td class="text-muted"><?php echo e($kurum->ozel_domain ?? '-'); ?></td>
                            <td>
                                <?php if($kurum->aktif_mi): ?>
                                    <span class="badge bg-success">Aktif</span>
                                <?php else: ?>
                                    <span class="badge bg-danger">Pasif</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="btn-list flex-nowrap">
                                    <a href="<?php echo e(route('superadmin.kurumlar.show', $kurum->id)); ?>" class="btn btn-sm btn-icon btn-ghost-info" title="Detay">
                                        <i class="ti ti-eye"></i>
                                    </a>
                                    <a href="<?php echo e(route('superadmin.kurumlar.edit', $kurum->id)); ?>" class="btn btn-sm btn-icon btn-ghost-primary" title="Düzenle">
                                        <i class="ti ti-edit"></i>
                                    </a>
                                    <form action="<?php echo e(route('superadmin.kurumlar.destroy', $kurum->id)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Bu kurumu silmek istediğinizden emin misiniz?')">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-icon btn-ghost-danger" title="Sil">
                                            <i class="ti ti-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="text-center text-muted py-4">
                                <i class="ti ti-folder-off icon mb-2" style="font-size: 2rem;"></i>
                                <div>Henüz kurum eklenmemiş</div>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php if($kurumlar->hasPages()): ?>
            <div class="card-footer d-flex align-items-center">
                <p class="m-0 text-muted">
                    Toplam <span class="badge bg-secondary"><?php echo e($kurumlar->total()); ?></span> kurum gösteriliyor
                </p>
                <ul class="pagination m-0 ms-auto">
                    <?php echo e($kurumlar->links()); ?>

                </ul>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.superadmin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\kan_bankasi\proje\resources\views/superadmin/kurumlar/index.blade.php ENDPATH**/ ?>