<!doctype html>
<html lang="tr">
  <head>
    <meta charset="utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover"/>
    <meta http-equiv="X-UA-Compatible" content="ie=edge"/>
    <title><?php echo $__env->yieldContent('title'); ?> - Yönetim Paneli</title>
    <!-- CSS files -->
    <link href="https://cdn.jsdelivr.net/npm/@tabler/core@1.0.0-beta20/dist/css/tabler.min.css" rel="stylesheet"/>
    <link href="https://cdn.jsdelivr.net/npm/@tabler/icons-webfont@latest/tabler-icons.min.css" rel="stylesheet"/>
    <style>
      @import url('https://rsms.me/inter/inter.css');
      :root {
        --tblr-font-sans-serif: 'Inter Var', -apple-system, BlinkMacSystemFont, San Francisco, Segoe UI, Roboto, Helvetica Neue, sans-serif;
      }
      body {
        font-feature-settings: "cv03", "cv04", "cv11";
      }
    </style>
    <?php echo $__env->yieldPushContent('styles'); ?>
  </head>
  <body>
    <script src="https://cdn.jsdelivr.net/npm/@tabler/core@1.0.0-beta20/dist/js/tabler.min.js"></script>
    <div class="page">
      <!-- Sidebar -->
      <aside class="navbar navbar-vertical navbar-expand-lg" data-bs-theme="dark">
        <div class="container-fluid">
          <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#sidebar-menu" aria-controls="sidebar-menu" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
          </button>
          <h1 class="navbar-brand navbar-brand-autodark">
            <a href="<?php echo e(route('admin.dashboard')); ?>">
              <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-droplet-filled text-red" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10.708 2.372a2.382 2.382 0 0 0 -.71 .686l-4.892 7.26c-1.981 3.314 -1.22 7.466 1.767 9.882c2.969 2.402 7.286 2.402 10.254 0c2.987 -2.416 3.748 -6.569 1.795 -9.836l-4.919 -7.306c-.722 -1.075 -2.192 -1.376 -3.295 -.686z" stroke-width="0" fill="currentColor" /></svg>
              <span class="ms-2">Yönetim</span>
            </a>
          </h1>
          <div class="collapse navbar-collapse" id="sidebar-menu">
            <ul class="navbar-nav pt-lg-3">
              <li class="nav-item <?php echo e(request()->routeIs('admin.dashboard') ? 'active' : ''); ?>">
                <a class="nav-link" href="<?php echo e(route('admin.dashboard')); ?>">
                  <span class="nav-link-icon d-md-none d-lg-inline-block">
                    <i class="ti ti-home"></i>
                  </span>
                  <span class="nav-link-title">Anasayfa</span>
                </a>
              </li>
              
              <li class="nav-item <?php echo e(request()->routeIs('admin.kullanicilar.*') ? 'active' : ''); ?>">
                <a class="nav-link" href="<?php echo e(route('admin.kullanicilar.index')); ?>">
                  <span class="nav-link-icon d-md-none d-lg-inline-block">
                    <i class="ti ti-users"></i>
                  </span>
                  <span class="nav-link-title">Kullanıcılar</span>
                </a>
              </li>

              <li class="nav-item <?php echo e(request()->routeIs('admin.kanilanlari.*') || request()->routeIs('admin.kan-ilanlari.*') ? 'active' : ''); ?>">
                <a class="nav-link" href="<?php echo e(route('admin.kanilanlari.index')); ?>">
                  <span class="nav-link-icon d-md-none d-lg-inline-block">
                    <i class="ti ti-droplet"></i>
                  </span>
                  <span class="nav-link-title">Kan İlanları</span>
                </a>
              </li>

              <li class="nav-item dropdown <?php echo e(request()->routeIs('admin.sms.*') ? 'active' : ''); ?>">
                <a class="nav-link dropdown-toggle" href="#navbar-sms" data-bs-toggle="dropdown" data-bs-auto-close="false" role="button" aria-expanded="false">
                  <span class="nav-link-icon d-md-none d-lg-inline-block">
                    <i class="ti ti-message"></i>
                  </span>
                  <span class="nav-link-title">SMS Yönetimi</span>
                </a>
                <div class="dropdown-menu">
                  <a class="dropdown-item <?php echo e(request()->routeIs('admin.sms.ayarlar') ? 'active' : ''); ?>" href="<?php echo e(route('admin.sms.ayarlar')); ?>">
                    SMS Ayarları
                  </a>
                  <a class="dropdown-item <?php echo e(request()->routeIs('admin.sms.sablonlar') ? 'active' : ''); ?>" href="<?php echo e(route('admin.sms.sablonlar')); ?>">
                    Şablonlar
                  </a>
                  <a class="dropdown-item <?php echo e(request()->routeIs('admin.sms.raporlar') ? 'active' : ''); ?>" href="<?php echo e(route('admin.sms.raporlar')); ?>">
                    Raporlar
                  </a>
                </div>
              </li>

              <li class="nav-item <?php echo e(request()->routeIs('admin.bolge-tanimlamalari.*') ? 'active' : ''); ?>">
                <a class="nav-link" href="<?php echo e(route('admin.bolge-tanimlamalari.index')); ?>">
                  <span class="nav-link-icon d-md-none d-lg-inline-block">
                    <i class="ti ti-map-pin"></i>
                  </span>
                  <span class="nav-link-title">Bölge Tanımlamaları</span>
                </a>
              </li>

              <li class="nav-item <?php echo e(request()->routeIs('admin.raporlar.*') ? 'active' : ''); ?>">
                <a class="nav-link" href="<?php echo e(route('admin.raporlar.index')); ?>">
                  <span class="nav-link-icon d-md-none d-lg-inline-block">
                    <i class="ti ti-chart-bar"></i>
                  </span>
                  <span class="nav-link-title">Raporlar</span>
                </a>
              </li>

              <li class="nav-item dropdown">
                <a class="nav-link dropdown-toggle" href="#navbar-ayarlar" data-bs-toggle="dropdown" data-bs-auto-close="false" role="button" aria-expanded="false">
                  <span class="nav-link-icon d-md-none d-lg-inline-block">
                    <i class="ti ti-settings"></i>
                  </span>
                  <span class="nav-link-title">Ayarlar</span>
                </a>
                <div class="dropdown-menu">
                  <div class="dropdown-menu-columns">
                    <div class="dropdown-menu-column">
                      <a class="dropdown-item <?php echo e(request()->routeIs('admin.profil.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.profil.index')); ?>">
                        <i class="ti ti-user me-2"></i>
                        Profil Ayarları
                      </a>
                    </div>
                  </div>
                </div>
              </li>
            </ul>
          </div>
        </div>
      </aside>
      
      <!-- Navbar -->
      <header class="navbar navbar-expand-md d-print-none">
        <div class="container-xl">
          <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbar-menu" aria-controls="navbar-menu" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
          </button>
          <h1 class="navbar-brand d-none-navbar-horizontal pe-0 pe-md-3">
            <a href="<?php echo e(route('admin.dashboard')); ?>">
              <?php
                $kurumId = request()->attributes->get('kurum_id');
                $kurumAdi = 'Kurum Adı';
                if ($kurumId) {
                    $kurum = DB::table('kurumlar')->where('id', $kurumId)->first();
                    $kurumAdi = $kurum->ad ?? 'Kurum Adı';
                }
              ?>
              <?php echo e($kurumAdi); ?>

            </a>
          </h1>
          <div class="navbar-nav flex-row order-md-last ms-auto">
            <div class="nav-item dropdown">
              <a href="#" class="nav-link d-flex lh-1 text-reset p-0" data-bs-toggle="dropdown" aria-label="Open user menu">
                <span class="avatar avatar-sm" style="background-image: url(https://ui-avatars.com/api/?name=<?php echo e(urlencode(Auth::guard('admin')->user()->name ?? Auth::guard('admin')->user()->ad . ' ' . Auth::guard('admin')->user()->soyad)); ?>&background=206bc4&color=fff)"></span>
                <div class="d-none d-xl-block ps-2">
                  <div><?php echo e(Auth::guard('admin')->user()->name ?? Auth::guard('admin')->user()->ad . ' ' . Auth::guard('admin')->user()->soyad); ?></div>
                  <div class="mt-1 small text-muted">Yönetici</div>
                </div>
              </a>
              <div class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
                <a href="<?php echo e(route('admin.profil.index')); ?>" class="dropdown-item">
                  <i class="ti ti-user me-2"></i>
                  Profil Ayarları
                </a>
                <div class="dropdown-divider"></div>
                <form method="POST" action="<?php echo e(route('admin.cikis')); ?>">
                  <?php echo csrf_field(); ?>
                  <button type="submit" class="dropdown-item">
                    <i class="ti ti-logout me-2"></i>
                    Çıkış Yap
                  </button>
                </form>
              </div>
            </div>
          </div>
        </div>
      </header>
      
      <div class="page-wrapper">
        <!-- Page header -->
        <div class="page-header d-print-none">
          <div class="container-xl">
            <div class="row g-2 align-items-center">
              <div class="col">
                <div class="page-pretitle">
                  Yönetim Paneli
                </div>
                <h2 class="page-title">
                  <?php echo $__env->yieldContent('title'); ?>
                </h2>
              </div>
              <?php echo $__env->yieldContent('page-actions'); ?>
            </div>
          </div>
        </div>
        
        <!-- Page body -->
        <div class="page-body">
          <div class="container-xl">
            <?php if(session('success')): ?>
              <div class="alert alert-success alert-dismissible" role="alert">
                <div class="d-flex">
                  <div>
                    <i class="ti ti-check icon alert-icon"></i>
                  </div>
                  <div>
                    <h4 class="alert-title">Başarılı!</h4>
                    <div class="text-muted"><?php echo e(session('success')); ?></div>
                  </div>
                </div>
                <a class="btn-close" data-bs-dismiss="alert" aria-label="close"></a>
              </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
              <div class="alert alert-danger alert-dismissible" role="alert">
                <div class="d-flex">
                  <div>
                    <i class="ti ti-alert-circle icon alert-icon"></i>
                  </div>
                  <div>
                    <h4 class="alert-title">Hata!</h4>
                    <div class="text-muted"><?php echo e(session('error')); ?></div>
                  </div>
                </div>
                <a class="btn-close" data-bs-dismiss="alert" aria-label="close"></a>
              </div>
            <?php endif; ?>

            <?php if($errors->any()): ?>
              <div class="alert alert-danger alert-dismissible" role="alert">
                <div class="d-flex">
                  <div>
                    <i class="ti ti-alert-circle icon alert-icon"></i>
                  </div>
                  <div>
                    <h4 class="alert-title">Hatalar!</h4>
                    <ul class="mb-0">
                      <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                  </div>
                </div>
                <a class="btn-close" data-bs-dismiss="alert" aria-label="close"></a>
              </div>
            <?php endif; ?>
            
            <?php echo $__env->yieldContent('content'); ?>
          </div>
        </div>
        
        <footer class="footer footer-transparent d-print-none">
          <div class="container-xl">
            <div class="row text-center align-items-center flex-row-reverse">
              <div class="col-12 col-lg-auto mt-3 mt-lg-0">
                <ul class="list-inline list-inline-dots mb-0">
                  <li class="list-inline-item">
                    Copyright &copy; <?php echo e(date('Y')); ?>

                    <a href="https://sinorsel.com.tr" target="_blank" class="link-secondary">Sinorsel Yazılım San. Tic. Ltd. Şti.</a>
                    Tüm hakları saklıdır.
                  </li>
                </ul>
              </div>
            </div>
          </div>
        </footer>
      </div>
    </div>
    <?php echo $__env->yieldPushContent('scripts'); ?>
  </body>
</html>
<?php /**PATH C:\xampp\htdocs\kan_bankasi\proje\resources\views/layouts/admin.blade.php ENDPATH**/ ?>