

<?php $__env->startSection('title', 'Tahsilat Detayı'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <div class="page-pretitle">
                    Mali İşlemler
                </div>
                <h2 class="page-title">
                    Tahsilat Detayı
                </h2>
            </div>
            <div class="col-auto ms-auto d-print-none">
                <div class="btn-list">
                    <a href="<?php echo e(route('superadmin.tahsilat.edit', $ts->id)); ?>" class="btn btn-primary">
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M7 7h-1a2 2 0 0 0 -2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2 -2v-1" /><path d="M20.385 6.585a2.1 2.1 0 0 0 -2.97 -2.97l-8.415 8.385v3h3l8.385 -8.415z" /><path d="M16 5l3 3" /></svg>
                        Düzenle
                    </a>
                    <a href="<?php echo e(route('superadmin.tahsilat.index')); ?>" class="btn btn-secondary">
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M5 12l14 0" /><path d="M5 12l6 6" /><path d="M5 12l6 -6" /></svg>
                        Geri Dön
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="page-body">
    <div class="container-xl">
        <div class="row row-cards">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Tahsilat Bilgileri</h3>
                    </div>
                    <div class="card-body">
                        <div class="datagrid">
                            <div class="datagrid-item">
                                <div class="datagrid-title">Kurum</div>
                                <div class="datagrid-content"><?php echo e($kurum->ad ?? '-'); ?></div>
                            </div>
                            <div class="datagrid-item">
                                <div class="datagrid-title">İlgili Tahakkuk</div>
                                <div class="datagrid-content">
                                    <?php if($tahakkuk): ?>
                                        <a href="<?php echo e(route('superadmin.tahakkuk.show', $tahakkuk->id)); ?>"><?php echo e($tahakkuk->baslik); ?></a>
                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="datagrid-item">
                                <div class="datagrid-title">Tutar</div>
                                <div class="datagrid-content">
                                    <span class="h3 mb-0 text-success"><?php echo e(number_format($ts->tutar, 2, ',', '.')); ?> ₺</span>
                                </div>
                            </div>
                            <div class="datagrid-item">
                                <div class="datagrid-title">Tahsilat Tarihi</div>
                                <div class="datagrid-content"><?php echo e(\Carbon\Carbon::parse($ts->tahsilat_tarihi)->format('d.m.Y')); ?></div>
                            </div>
                            <div class="datagrid-item">
                                <div class="datagrid-title">Ödeme Yöntemi</div>
                                <div class="datagrid-content"><?php echo e($ts->yontem ?? '-'); ?></div>
                            </div>
                            <div class="datagrid-item">
                                <div class="datagrid-title">Kayıt Tarihi</div>
                                <div class="datagrid-content"><?php echo e(\Carbon\Carbon::parse($ts->created_at)->format('d.m.Y H:i')); ?></div>
                            </div>
                        </div>
                        <?php if($ts->aciklama): ?>
                        <div class="mt-3">
                            <label class="form-label">Açıklama</label>
                            <div class="card">
                                <div class="card-body">
                                    <?php echo e($ts->aciklama); ?>

                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <?php if($tahakkuk): ?>
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Tahakkuk Özeti</h3>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <div class="text-secondary mb-1">Tahakkuk Başlığı</div>
                            <div class="h4 mb-0"><?php echo e($tahakkuk->baslik); ?></div>
                        </div>
                        <div class="mb-3">
                            <div class="text-secondary mb-1">Toplam Tutar</div>
                            <div class="h3 mb-0 text-primary"><?php echo e(number_format($tahakkuk->tutar, 2, ',', '.')); ?> ₺</div>
                        </div>
                        <div class="mb-3">
                            <div class="text-secondary mb-1">Bu Ödeme</div>
                            <div class="h3 mb-0 text-success"><?php echo e(number_format($ts->tutar, 2, ',', '.')); ?> ₺</div>
                        </div>
                        <a href="<?php echo e(route('superadmin.tahakkuk.show', $tahakkuk->id)); ?>" class="btn btn-outline-primary w-100">
                            Tahakkuku Görüntüle
                        </a>
                    </div>
                </div>
                <?php endif; ?>

                <div class="card mt-3">
                    <div class="card-header">
                        <h3 class="card-title">Tehlikeli İşlemler</h3>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-danger mb-3">
                            <div class="d-flex">
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon alert-icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 9v4" /><path d="M10.363 3.591l-8.106 13.534a1.914 1.914 0 0 0 1.636 2.871h16.214a1.914 1.914 0 0 0 1.636 -2.87l-8.106 -13.536a1.914 1.914 0 0 0 -3.274 0z" /><path d="M12 16h.01" /></svg>
                                </div>
                                <div>
                                    <h4 class="alert-title">Dikkat!</h4>
                                    <div class="text-secondary">Bu işlem geri alınamaz.</div>
                                </div>
                            </div>
                        </div>
                        <form action="<?php echo e(route('superadmin.tahsilat.destroy', $ts->id)); ?>" method="POST" onsubmit="return confirm('Bu tahsilatı silmek istediğinizden emin misiniz?');">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-danger">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M4 7l16 0" /><path d="M10 11l0 6" /><path d="M14 11l0 6" /><path d="M5 7l1 12a2 2 0 0 0 2 2h8a2 2 0 0 0 2 -2l1 -12" /><path d="M9 7v-3a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v3" /></svg>
                                Tahsilatı Sil
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.superadmin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\kan_bankasi\proje\resources\views/superadmin/tahsilat/show.blade.php ENDPATH**/ ?>