<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\BolgeTanimlamaController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\IlanDetayController;
use App\Http\Controllers\IlanLinkController;
use App\Http\Controllers\Superadmin\KurumlarController;
use App\Http\Controllers\Superadmin\TahakkukController;
use App\Http\Controllers\Superadmin\TahsilatController;
use App\Http\Controllers\Auth\KullaniciAuthController;
use App\Http\Controllers\Admin\Auth\OturumController as AdminOturumController;
use App\Http\Controllers\Superadmin\Auth\OturumController as SuperadminOturumController;
use App\Http\Controllers\Superadmin\BolgeTanimlamaController as SuperadminBolgeTanimlamaController;
use App\Http\Controllers\Admin\KullaniciYonetimiController;
use App\Http\Controllers\Admin\KanIlaniYonetimiController;
use App\Http\Controllers\Admin\RaporController;
use App\Http\Controllers\Admin\SmsYonetimiController;
use Illuminate\Http\Request;
use App\Http\Controllers\KullaniciPanelController;
use App\Http\Controllers\PublicController;
use App\Http\Controllers\Superadmin\YoneticiHesaplariController;
use App\Http\Controllers\Superadmin\SistemBakimController;
use App\Http\Controllers\Superadmin\ProfilController;

Route::get('/', function () {
    return redirect()->route('giris');
});

// SMS linki ile ilan görüntüleme (48 saat geçerli)
Route::get('/i/{token}', [IlanLinkController::class, 'show'])->name('ilan.link');

Route::get('/ilan/{ilanId}', [PublicController::class, 'showIlan'])->name('public.ilan.show');

// API - İlçeleri getir (kayıt formu için)
Route::get('/api/ilceler/{ilId}', function($ilId) {
    // Önce ilceler tablosuna bak, boşsa kurum_ilceler'den çek
    $ilceler = DB::table('ilceler')
        ->where('il_id', $ilId)
        ->orderBy('ad')
        ->select('id', 'ad')
        ->get();
    
    if ($ilceler->isEmpty()) {
        $ilceler = DB::table('kurum_ilceler')
            ->where('kurum_il_id', $ilId)
            ->orderBy('ad')
            ->select('id', 'ad')
            ->get();
    }
    
    return response()->json($ilceler);
});

// Kullanıcı Kimlik Doğrulama
Route::get('kayit', [KullaniciAuthController::class, 'showRegistrationForm'])->name('kayit');
Route::post('kayit', [KullaniciAuthController::class, 'register']);
Route::get('giris', [KullaniciAuthController::class, 'showLoginForm'])->name('giris');
Route::get('login', [KullaniciAuthController::class, 'showLoginForm'])->name('login');
Route::post('send-otp', [KullaniciAuthController::class, 'sendOtp'])->name('send.otp');
Route::post('giris', [KullaniciAuthController::class, 'login']);
Route::post('login', [KullaniciAuthController::class, 'login']);
Route::post('cikis', [KullaniciAuthController::class, 'logout'])->name('cikis');

// SüperAdmin
Route::prefix('superadmin')->name('superadmin.')->group(function () {
    Route::get('/', function(){ return redirect()->route('superadmin.giris'); });
    Route::get('giris', [SuperadminOturumController::class, 'showLoginForm'])->name('giris');
    Route::post('giris', [SuperadminOturumController::class, 'login']);
    Route::post('cikis', [SuperadminOturumController::class, 'logout'])->name('cikis');

    Route::middleware(['auth:superadmin'])->group(function() {
        Route::get('dashboard', function(){ return redirect()->route('superadmin.kurumlar.index'); })->name('anasayfa');

        Route::resource('kurumlar', KurumlarController::class);

        // Bölge Tanımlamaları
        Route::get('bolge-tanimlamalari', [SuperadminBolgeTanimlamaController::class, 'index'])->name('bolge-tanimlamalari.index');
        Route::post('bolge-tanimlamalari/store', [SuperadminBolgeTanimlamaController::class, 'store'])->name('bolge-tanimlamalari.store');
        Route::put('bolge-tanimlamalari/update/{id}', [SuperadminBolgeTanimlamaController::class, 'update'])->name('bolge-tanimlamalari.update');
        Route::delete('bolge-tanimlamalari/destroy/{id}', [SuperadminBolgeTanimlamaController::class, 'destroy'])->name('bolge-tanimlamalari.destroy');

        // Yönetici Hesapları
        Route::resource('yoneticiler', YoneticiHesaplariController::class);

        // Tahakkuklar
        Route::get('tahakkuklar', [TahakkukController::class, 'index'])->name('tahakkuk.index');
        Route::get('tahakkuklar/olustur', [TahakkukController::class, 'create'])->name('tahakkuk.create');
        Route::post('tahakkuklar', [TahakkukController::class, 'store'])->name('tahakkuk.store');
        Route::get('tahakkuklar/{id}', [TahakkukController::class, 'show'])->name('tahakkuk.show');
        Route::get('tahakkuklar/{id}/duzenle', [TahakkukController::class, 'edit'])->name('tahakkuk.edit');
        Route::put('tahakkuklar/{id}', [TahakkukController::class, 'update'])->name('tahakkuk.update');
        Route::delete('tahakkuklar/{id}', [TahakkukController::class, 'destroy'])->name('tahakkuk.destroy');

        // Tahsilatlar
        Route::get('tahsilatlar', [TahsilatController::class, 'index'])->name('tahsilat.index');
        Route::get('tahsilatlar/olustur', [TahsilatController::class, 'create'])->name('tahsilat.create');
        Route::post('tahsilatlar', [TahsilatController::class, 'store'])->name('tahsilat.store');
        Route::get('tahsilatlar/{id}', [TahsilatController::class, 'show'])->name('tahsilat.show');
        Route::get('tahsilatlar/{id}/duzenle', [TahsilatController::class, 'edit'])->name('tahsilat.edit');
        Route::put('tahsilatlar/{id}', [TahsilatController::class, 'update'])->name('tahsilat.update');
        Route::delete('tahsilatlar/{id}', [TahsilatController::class, 'destroy'])->name('tahsilat.destroy');

        // Sistem Bakım
        Route::get('sistem-bakim', [SistemBakimController::class, 'index'])->name('sistem-bakim.index');
        Route::post('sistem-bakim/clear-cache', [SistemBakimController::class, 'clearCache'])->name('sistem-bakim.clear-cache');
        Route::post('sistem-bakim/clear-logs', [SistemBakimController::class, 'clearLogs'])->name('sistem-bakim.clear-logs');
        Route::get('sistem-bakim/view-logs', [SistemBakimController::class, 'viewLogs'])->name('sistem-bakim.view-logs');
        Route::post('sistem-bakim/optimize', [SistemBakimController::class, 'optimizeSystem'])->name('sistem-bakim.optimize');

        // Profil Ayarları
        Route::get('profil', [ProfilController::class, 'index'])->name('profil.index');
        Route::put('profil', [ProfilController::class, 'update'])->name('profil.update');
    });
});

// Kurum Yönetim Paneli
Route::prefix('yonetim')->middleware(['web'])->group(function () {
    Route::get('/', function(){ return redirect()->route('admin.giris'); });
    Route::get('giris', [AdminOturumController::class, 'showLoginForm'])->name('admin.giris');
    Route::post('giris', [AdminOturumController::class, 'login']);
    Route::post('cikis', [AdminOturumController::class, 'logout'])->name('admin.cikis');

    Route::middleware(['auth:admin'])->group(function() {
        Route::get('dashboard', [DashboardController::class, 'index'])->name('admin.dashboard');

        // Kullanıcı Yönetimi
        Route::get('/kullanicilar/{id}/ilanlar', [KullaniciYonetimiController::class, 'ilanlar'])->name('admin.kullanicilar.ilanlar');
        Route::resource('kullanicilar', KullaniciYonetimiController::class, ['as' => 'admin']);
        Route::get('/kullanicilar/ilceler/{ilId}', [KullaniciYonetimiController::class, 'getIlceler'])->name('admin.kullanicilar.ilceler');

        // Bölge Tanımlamaları
        Route::get('bolge-tanimlamalari', [BolgeTanimlamaController::class, 'index'])->name('admin.bolge-tanimlamalari.index');
        Route::get('bolge-tanimlamalari/create', [BolgeTanimlamaController::class, 'create'])->name('admin.bolge-tanimlamalari.create');
        Route::post('bolge-tanimlamalari', [BolgeTanimlamaController::class, 'store'])->name('admin.bolge-tanimlamalari.store');
        Route::get('bolge-tanimlamalari/{id}/edit', [BolgeTanimlamaController::class, 'edit'])->name('admin.bolge-tanimlamalari.edit');
        Route::put('bolge-tanimlamalari/{id}', [BolgeTanimlamaController::class, 'update'])->name('admin.bolge-tanimlamalari.update');
        Route::delete('bolge-tanimlamalari/{id}', [BolgeTanimlamaController::class, 'destroy'])->name('admin.bolge-tanimlamalari.destroy');

        // Profil
        Route::get('profil', [\App\Http\Controllers\Admin\ProfilController::class, 'index'])->name('admin.profil.index');
        Route::put('profil', [\App\Http\Controllers\Admin\ProfilController::class, 'update'])->name('admin.profil.update');

        // Kan İlanı Yönetimi
        Route::get('/kan-ilanlari', [KanIlaniYonetimiController::class, 'index'])->name('admin.kanilanlari.index');
        Route::get('/kan-ilanlari/create', [KanIlaniYonetimiController::class, 'create'])->name('admin.kan-ilanlari.create');
        Route::post('/kan-ilanlari/preview', [KanIlaniYonetimiController::class, 'preview'])->name('admin.kan-ilanlari.preview');
        Route::post('/kan-ilanlari', [KanIlaniYonetimiController::class, 'store'])->name('admin.kan-ilanlari.store');
        Route::get('/kan-ilanlari/{id}', [KanIlaniYonetimiController::class, 'show'])->name('admin.kan-ilanlari.show');
        Route::put('/kan-ilanlari/{id}/durum', [KanIlaniYonetimiController::class, 'updateStatus'])->name('admin.kan-ilanlari.update-status');

        // SMS Yönetimi
        Route::get('/sms-yonetimi/ayarlar', [SmsYonetimiController::class, 'ayarlar'])->name('admin.sms.ayarlar');
        Route::get('/sms-yonetimi/sablonlar', [SmsYonetimiController::class, 'sablonlar'])->name('admin.sms.sablonlar');
        Route::get('/sms-yonetimi/raporlar', [SmsYonetimiController::class, 'raporlar'])->name('admin.sms.raporlar');
        Route::post('/sms-yonetimi/api', [SmsYonetimiController::class, 'saveApiSettings'])->name('admin.sms.api.save');
        Route::post('/sms-yonetimi/test', [SmsYonetimiController::class, 'testSms'])->name('admin.sms.test');
        Route::post('/sms-yonetimi/template', [SmsYonetimiController::class, 'saveTemplate'])->name('admin.sms.template.save');
        Route::delete('/sms-yonetimi/template/{id}', [SmsYonetimiController::class, 'deleteTemplate'])->name('admin.sms.template.delete');

        // Raporlar
        Route::get('/raporlar', [RaporController::class, 'index'])->name('admin.raporlar.index');
        Route::get('/raporlar/kullanici-bazli-ilanlar', [RaporController::class, 'kullaniciBazliIlanlar'])->name('admin.raporlar.kullanici-bazli-ilanlar');
        Route::get('/raporlar/kan-grubu-kullanicilar', [RaporController::class, 'kanGrubuKullanicilar'])->name('admin.raporlar.kan-grubu-kullanicilar');
        Route::get('/raporlar/kan-grubu-ilanlari', [RaporController::class, 'kanGrubuIlanlari'])->name('admin.raporlar.kan-grubu-ilanlari');
        Route::get('/raporlar/kan-grubu-detay', [RaporController::class, 'kanGrubuDetay'])->name('admin.raporlar.kan-grubu-detay');
    });
});

// Kullanıcı Paneli
Route::middleware(['auth:kullanici'])->group(function () {
    Route::get('/dashboard', [KullaniciPanelController::class, 'dashboard'])->name('kullanici.dashboard');

    Route::get('/profil', [KullaniciPanelController::class, 'profil'])->name('kullanici.profil');
    Route::post('/profil', [KullaniciPanelController::class, 'updateProfil'])->name('kullanici.profil.update');
    Route::post('/profil/send-kan-grubu-otp', [KullaniciPanelController::class, 'sendKanGrubuOtp'])->name('kullanici.profil.send-otp');

    Route::get('/ilan-ver', [KullaniciPanelController::class, 'showIlanForm'])->name('kullanici.ilan.ver');
    Route::post('/ilan-ver/send-otp', [KullaniciPanelController::class, 'sendIlanOtp'])->name('kullanici.ilan.send-otp');
    Route::post('/ilan-ver', [KullaniciPanelController::class, 'storeIlan'])->name('kullanici.ilan.store');
    Route::get('/ilanlarim', [KullaniciPanelController::class, 'ilanlarim'])->name('kullanici.ilanlarim');
    Route::get('/ilanlarim/{id}', [KullaniciPanelController::class, 'showIlan'])->name('kullanici.ilan.show');
    Route::get('/ilanlarim/{id}/duzenle', [KullaniciPanelController::class, 'editIlan'])->name('kullanici.ilan.edit');
    Route::put('/ilanlarim/{id}', [KullaniciPanelController::class, 'updateIlan'])->name('kullanici.ilan.update');
    Route::post('/ilanlarim/{id}/durum', [KullaniciPanelController::class, 'updateIlanStatus'])->name('kullanici.ilan.update-status');
});

// İlan detay sayfası (public - herkes erişebilir)
Route::get('/i/{slug}', [KullaniciPanelController::class, 'ilanDetay'])->name('ilan.detay');


Route::prefix('yonetim')->name('admin.')->group(function () {
    // ...existing admin routes...
});
