@extends('layouts.superadmin')

@section('title', 'Yönetici Detayı')

@section('content')
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <div class="page-pretitle">
                    Yönetim
                </div>
                <h2 class="page-title">
                    Yönetici Detayı
                </h2>
            </div>
            <div class="col-auto ms-auto d-print-none">
                <div class="btn-list">
                    <a href="{{ route('superadmin.yoneticiler.edit', $yonetici->id) }}" class="btn btn-primary">
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M7 7h-1a2 2 0 0 0 -2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2 -2v-1" /><path d="M20.385 6.585a2.1 2.1 0 0 0 -2.97 -2.97l-8.415 8.385v3h3l8.385 -8.415z" /><path d="M16 5l3 3" /></svg>
                        Düzenle
                    </a>
                    <a href="{{ route('superadmin.yoneticiler.index') }}" class="btn btn-secondary">
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M5 12l14 0" /><path d="M5 12l6 6" /><path d="M5 12l6 -6" /></svg>
                        Geri Dön
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="page-body">
    <div class="container-xl">
        <div class="row row-cards">
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-body text-center">
                        <div class="mb-3">
                            <span class="avatar avatar-xl rounded" style="background-image: url(https://ui-avatars.com/api/?name={{ urlencode($yonetici->name) }}&size=200&background=206bc4&color=fff)"></span>
                        </div>
                        <div class="card-title mb-1">{{ $yonetici->name }}</div>
                        <div class="text-secondary">{{ $yonetici->email }}</div>
                    </div>
                    <div class="card-footer">
                        <div class="row align-items-center">
                            <div class="col-auto">
                                <span class="badge bg-blue-lt">Kurum Yöneticisi</span>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-header">
                        <h3 class="card-title">Bağlı Kurum</h3>
                    </div>
                    <div class="list-group list-group-flush">
                        <div class="list-group-item">
                            <div class="row align-items-center">
                                <div class="col-auto">
                                    <span class="avatar rounded" style="background-image: url(https://ui-avatars.com/api/?name={{ urlencode($yonetici->kurum->ad) }}&size=100&background=00c1a1&color=fff)"></span>
                                </div>
                                <div class="col">
                                    <div class="text-truncate">
                                        <strong>{{ $yonetici->kurum->ad }}</strong>
                                    </div>
                                    <div class="text-secondary">
                                        <small>{{ $yonetici->kurum->slug }}</small>
                                    </div>
                                </div>
                                <div class="col-auto">
                                    @if($yonetici->kurum->aktif_mi)
                                        <span class="badge bg-success">Aktif</span>
                                    @else
                                        <span class="badge bg-danger">Pasif</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Genel Bilgiler</h3>
                    </div>
                    <div class="card-body">
                        <div class="datagrid">
                            <div class="datagrid-item">
                                <div class="datagrid-title">Ad Soyad</div>
                                <div class="datagrid-content">{{ $yonetici->name }}</div>
                            </div>
                            <div class="datagrid-item">
                                <div class="datagrid-title">Kullanıcı Adı</div>
                                <div class="datagrid-content"><code>{{ $yonetici->kullanici_adi }}</code></div>
                            </div>
                            <div class="datagrid-item">
                                <div class="datagrid-title">E-posta</div>
                                <div class="datagrid-content">
                                    <a href="mailto:{{ $yonetici->email }}">{{ $yonetici->email }}</a>
                                </div>
                            </div>
                            <div class="datagrid-item">
                                <div class="datagrid-title">Bağlı Kurum</div>
                                <div class="datagrid-content">{{ $yonetici->kurum->ad }}</div>
                            </div>
                            <div class="datagrid-item">
                                <div class="datagrid-title">Kayıt Tarihi</div>
                                <div class="datagrid-content">{{ \Carbon\Carbon::parse($yonetici->created_at)->format('d.m.Y H:i') }}</div>
                            </div>
                            <div class="datagrid-item">
                                <div class="datagrid-title">Son Güncelleme</div>
                                <div class="datagrid-content">{{ \Carbon\Carbon::parse($yonetici->updated_at)->format('d.m.Y H:i') }}</div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-header">
                        <h3 class="card-title">İstatistikler</h3>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <div class="text-secondary mb-1">Toplam Kullanıcı</div>
                                    <div class="h2 mb-0">{{ $yonetici->kurum->kullanicilar_count ?? 0 }}</div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <div class="text-secondary mb-1">Toplam Kan İlanı</div>
                                    <div class="h2 mb-0">{{ $yonetici->kurum->kan_ilanlari_count ?? 0 }}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-header">
                        <h3 class="card-title">Tehlikeli İşlemler</h3>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-warning mb-3">
                            <div class="d-flex">
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon alert-icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 9v4" /><path d="M10.363 3.591l-8.106 13.534a1.914 1.914 0 0 0 1.636 2.871h16.214a1.914 1.914 0 0 0 1.636 -2.87l-8.106 -13.536a1.914 1.914 0 0 0 -3.274 0z" /><path d="M12 16h.01" /></svg>
                                </div>
                                <div>
                                    <h4 class="alert-title">Dikkat!</h4>
                                    <div class="text-secondary">Bu işlem geri alınamaz. Yöneticiyi silmek istediğinizden emin misiniz?</div>
                                </div>
                            </div>
                        </div>
                        <form action="{{ route('superadmin.yoneticiler.destroy', $yonetici->id) }}" method="POST" onsubmit="return confirm('Bu yöneticiyi silmek istediğinizden emin misiniz?');">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M4 7l16 0" /><path d="M10 11l0 6" /><path d="M14 11l0 6" /><path d="M5 7l1 12a2 2 0 0 0 2 2h8a2 2 0 0 0 2 -2l1 -12" /><path d="M9 7v-3a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v3" /></svg>
                                Yöneticiyi Sil
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
