@extends('layouts.superadmin')

@section('title', 'Yönetici Hesapları')

@section('content')
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <div class="page-pretitle">
                    Yönetim
                </div>
                <h2 class="page-title">
                    Kurum Yöneticileri
                </h2>
            </div>
            <div class="col-auto ms-auto d-print-none">
                <a href="{{ route('superadmin.yoneticiler.create') }}" class="btn btn-primary">
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 5l0 14" /><path d="M5 12l14 0" /></svg>
                    Yeni Yönetici Ekle
                </a>
            </div>
        </div>
    </div>
</div>

<div class="page-body">
    <div class="container-xl">
        <div class="row row-cards">
            <div class="col-12">
                <div class="card">
                    <div class="table-responsive">
                        <table class="table table-vcenter card-table">
                            <thead>
                                <tr>
                                    <th>Yönetici</th>
                                    <th>Kurum</th>
                                    <th>Kayıt Tarihi</th>
                                    <th class="w-1">İşlemler</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($yoneticiler as $yonetici)
                                <tr>
                                    <td>
                                        <div class="d-flex py-1 align-items-center">
                                            <span class="avatar me-2" style="background-image: url(https://ui-avatars.com/api/?name={{ urlencode($yonetici->name) }}&size=100&background=206bc4&color=fff)"></span>
                                            <div class="flex-fill">
                                                <div class="font-weight-medium">{{ $yonetici->name }}</div>
                                                <div class="text-secondary"><span class="badge badge-sm bg-blue-lt">{{ $yonetici->kullanici_adi }}</span> • {{ $yonetici->email }}</div>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div>{{ $yonetici->kurum->ad ?? '-' }}</div>
                                        <div class="text-secondary">{{ $yonetici->kurum->slug ?? '-' }}</div>
                                    </td>
                                    <td>
                                        {{ \Carbon\Carbon::parse($yonetici->created_at)->format('d.m.Y') }}
                                    </td>
                                    <td>
                                        <div class="btn-list flex-nowrap">
                                            <a href="{{ route('superadmin.yoneticiler.show', $yonetici->id) }}" class="btn btn-sm btn-icon btn-ghost-primary">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0" /><path d="M21 12c-2.4 4 -5.4 6 -9 6c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6" /></svg>
                                            </a>
                                            <a href="{{ route('superadmin.yoneticiler.edit', $yonetici->id) }}" class="btn btn-sm btn-icon btn-ghost-info">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M7 7h-1a2 2 0 0 0 -2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2 -2v-1" /><path d="M20.385 6.585a2.1 2.1 0 0 0 -2.97 -2.97l-8.415 8.385v3h3l8.385 -8.415z" /><path d="M16 5l3 3" /></svg>
                                            </a>
                                            <form action="{{ route('superadmin.yoneticiler.destroy', $yonetici->id) }}" method="POST" class="d-inline" onsubmit="return confirm('Bu yöneticiyi silmek istediğinizden emin misiniz?');">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-icon btn-ghost-danger">
                                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M4 7l16 0" /><path d="M10 11l0 6" /><path d="M14 11l0 6" /><path d="M5 7l1 12a2 2 0 0 0 2 2h8a2 2 0 0 0 2 -2l1 -12" /><path d="M9 7v-3a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v3" /></svg>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="4" class="text-center py-5">
                                        <div class="empty">
                                            <div class="empty-icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M8 7a4 4 0 1 0 8 0a4 4 0 0 0 -8 0" /><path d="M6 21v-2a4 4 0 0 1 4 -4h4a4 4 0 0 1 4 4v2" /></svg>
                                            </div>
                                            <p class="empty-title">Henüz yönetici eklenmemiş</p>
                                            <p class="empty-subtitle text-secondary">
                                                Yeni bir yönetici eklemek için yukarıdaki butonu kullanabilirsiniz.
                                            </p>
                                        </div>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    @if($yoneticiler->hasPages())
                    <div class="card-footer d-flex align-items-center">
                        <p class="m-0 text-secondary">Toplam <span>{{ $yoneticiler->total() }}</span> kayıttan <span>{{ $yoneticiler->firstItem() }}</span> - <span>{{ $yoneticiler->lastItem() }}</span> arası gösteriliyor</p>
                        <ul class="pagination m-0 ms-auto">
                            {{ $yoneticiler->links() }}
                        </ul>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
