@extends('layouts.superadmin')
@section('title', 'Tahsilatlar')
@section('content')
<div class="container py-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h5>Tahsilatlar</h5>
        <a class="btn btn-primary" href="{{ route('superadmin.tahsilat.create') }}">Yeni Tahsilat</a>
    </div>
    <div class="card"><div class="card-body">
        <table class="table">
            <thead><tr><th>Kurum</th><th>Tahakkuk</th><th>Tutar</th><th>Tarih</th><th>Yöntem</th><th></th></tr></thead>
            <tbody>
            @foreach($tahsilatlar as $ts)
                <tr>
                    <td>{{ DB::table('kurumlar')->where('id',$ts->kurum_id)->value('ad') }}</td>
                    <td>{{ DB::table('kurum_tahakkuklar')->where('id',$ts->tahakkuk_id)->value('baslik') }}</td>
                    <td>{{ number_format($ts->tutar,2,',','.') }}</td>
                    <td>{{ $ts->tahsilat_tarihi }}</td>
                    <td>{{ $ts->yontem }}</td>
                    <td class="text-end">
                        <a href="{{ route('superadmin.tahsilat.show',$ts->id) }}" class="btn btn-sm btn-info">Detay</a>
                        <a href="{{ route('superadmin.tahsilat.edit',$ts->id) }}" class="btn btn-sm btn-secondary">Düzenle</a>
                        <form method="post" action="{{ route('superadmin.tahsilat.destroy',$ts->id) }}" class="d-inline" onsubmit="return confirm('Silinsin mi?')">
                            @csrf @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-outline-danger">Sil</button>
                        </form>
                    </td>
                </tr>
            @endforeach
            </tbody>
        </table>
        {{ $tahsilatlar->links() }}
    </div></div>
</div>
@endsection
