@extends('layouts.superadmin')
@section('title', 'Tahsilat Düzenle')
@section('content')
<div class="container py-4">
    <h5 class="mb-3">Tahsilat Düzenle</h5>
    <div class="card"><div class="card-body">
        <form method="post" action="{{ route('superadmin.tahsilat.update', $ts->id) }}">
            @csrf
            @method('PUT')
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">Kurum</label>
                    <select name="kurum_id" class="form-select" required>
                        @foreach($kurumlar as $k)
                            <option value="{{ $k->id }}" {{ (int)$k->id === (int)$ts->kurum_id ? 'selected' : '' }}>{{ $k->ad }}</option>
                        @endforeach
                    </select>
                    @error('kurum_id')<div class="text-danger small">{{ $message }}</div>@enderror
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Tahakkuk</label>
                    <select name="tahakkuk_id" class="form-select" required>
                        @foreach($tahakkuklar as $t)
                            <option value="{{ $t->id }}" {{ (int)$t->id === (int)$ts->tahakkuk_id ? 'selected' : '' }}>{{ $t->baslik }} ({{ number_format($t->tutar,2,',','.') }})</option>
                        @endforeach
                    </select>
                    @error('tahakkuk_id')<div class="text-danger small">{{ $message }}</div>@enderror
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label">Tutar</label>
                    <input type="number" step="0.01" name="tutar" value="{{ old('tutar',$ts->tutar) }}" class="form-control" required>
                    @error('tutar')<div class="text-danger small">{{ $message }}</div>@enderror
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label">Tahsilat Tarihi</label>
                    <input type="datetime-local" name="tahsilat_tarihi" value="{{ old('tahsilat_tarihi', str_replace(' ','T',$ts->tahsilat_tarihi)) }}" class="form-control" required>
                    @error('tahsilat_tarihi')<div class="text-danger small">{{ $message }}</div>@enderror
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label">Yöntem</label>
                    <input type="text" name="yontem" value="{{ old('yontem',$ts->yontem) }}" class="form-control" placeholder="NAKİT/KART/TRANSFER">
                    @error('yontem')<div class="text-danger small">{{ $message }}</div>@enderror
                </div>
                <div class="col-12 mb-3">
                    <label class="form-label">Açıklama</label>
                    <input type="text" name="aciklama" value="{{ old('aciklama',$ts->aciklama) }}" class="form-control">
                </div>
            </div>
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-success">Güncelle</button>
                <a href="{{ route('superadmin.tahsilat.index') }}" class="btn btn-secondary">İptal</a>
            </div>
        </form>
        <hr>
        <form method="post" action="{{ route('superadmin.tahsilat.destroy', $ts->id) }}" onsubmit="return confirm('Silmek istediğinize emin misiniz?')">
            @csrf
            @method('DELETE')
            <button type="submit" class="btn btn-outline-danger">Tahsilat Sil</button>
        </form>
    </div></div>
</div>
@endsection
