@extends('layouts.superadmin')
@section('title', 'Tahsilat Oluştur')
@section('content')
<div class="container py-4">
    <h5 class="mb-3">Yeni Tahsilat</h5>
    <div class="card"><div class="card-body">
        <form method="post" action="{{ route('superadmin.tahsilat.store') }}">
            @csrf
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">Kurum</label>
                    <select name="kurum_id" class="form-select" required>
                        <option value="">Seçiniz</option>
                        @foreach($kurumlar as $k)
                            <option value="{{ $k->id }}">{{ $k->ad }}</option>
                        @endforeach
                    </select>
                    @error('kurum_id')<div class="text-danger small">{{ $message }}</div>@enderror
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Tahakkuk</label>
                    <select name="tahakkuk_id" class="form-select" required>
                        <option value="">Seçiniz</option>
                        @foreach($tahakkuklar as $t)
                            <option value="{{ $t->id }}">{{ $t->baslik }} ({{ number_format($t->tutar,2,',','.') }})</option>
                        @endforeach
                    </select>
                    @error('tahakkuk_id')<div class="text-danger small">{{ $message }}</div>@enderror
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label">Tutar</label>
                    <input type="number" step="0.01" name="tutar" value="{{ old('tutar') }}" class="form-control" required>
                    @error('tutar')<div class="text-danger small">{{ $message }}</div>@enderror
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label">Tahsilat Tarihi</label>
                    <input type="datetime-local" name="tahsilat_tarihi" value="{{ old('tahsilat_tarihi') }}" class="form-control" required>
                    @error('tahsilat_tarihi')<div class="text-danger small">{{ $message }}</div>@enderror
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label">Yöntem</label>
                    <input type="text" name="yontem" value="{{ old('yontem') }}" class="form-control" placeholder="NAKİT/KART/TRANSFER">
                    @error('yontem')<div class="text-danger small">{{ $message }}</div>@enderror
                </div>
                <div class="col-12 mb-3">
                    <label class="form-label">Açıklama</label>
                    <input type="text" name="aciklama" value="{{ old('aciklama') }}" class="form-control">
                </div>
            </div>
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-success">Kaydet</button>
                <a href="{{ route('superadmin.tahsilat.index') }}" class="btn btn-secondary">İptal</a>
            </div>
        </form>
    </div></div>
</div>
@endsection
