@extends('layouts.superadmin')

@section('title', 'Tahakkuk Detayı')

@section('content')
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <div class="page-pretitle">
                    Mali İşlemler
                </div>
                <h2 class="page-title">
                    Tahakkuk Detayı
                </h2>
            </div>
            <div class="col-auto ms-auto d-print-none">
                <div class="btn-list">
                    <a href="{{ route('superadmin.tahakkuk.edit', $t->id) }}" class="btn btn-primary">
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M7 7h-1a2 2 0 0 0 -2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2 -2v-1" /><path d="M20.385 6.585a2.1 2.1 0 0 0 -2.97 -2.97l-8.415 8.385v3h3l8.385 -8.415z" /><path d="M16 5l3 3" /></svg>
                        Düzenle
                    </a>
                    <a href="{{ route('superadmin.tahakkuk.index') }}" class="btn btn-secondary">
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M5 12l14 0" /><path d="M5 12l6 6" /><path d="M5 12l6 -6" /></svg>
                        Geri Dön
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="page-body">
    <div class="container-xl">
        <div class="row row-cards">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Tahakkuk Bilgileri</h3>
                    </div>
                    <div class="card-body">
                        <div class="datagrid">
                            <div class="datagrid-item">
                                <div class="datagrid-title">Başlık</div>
                                <div class="datagrid-content">{{ $t->baslik }}</div>
                            </div>
                            <div class="datagrid-item">
                                <div class="datagrid-title">Kurum</div>
                                <div class="datagrid-content">{{ $kurum->ad ?? '-' }}</div>
                            </div>
                            <div class="datagrid-item">
                                <div class="datagrid-title">Tutar</div>
                                <div class="datagrid-content">
                                    <span class="h3 mb-0">{{ number_format($t->tutar, 2, ',', '.') }} ₺</span>
                                </div>
                            </div>
                            <div class="datagrid-item">
                                <div class="datagrid-title">Vade Tarihi</div>
                                <div class="datagrid-content">{{ $t->vade_tarihi ? \Carbon\Carbon::parse($t->vade_tarihi)->format('d.m.Y') : '-' }}</div>
                            </div>
                            <div class="datagrid-item">
                                <div class="datagrid-title">Durum</div>
                                <div class="datagrid-content">
                                    @if($t->aktif_mi)
                                        <span class="badge bg-success">Aktif</span>
                                    @else
                                        <span class="badge bg-danger">Pasif</span>
                                    @endif
                                </div>
                            </div>
                            <div class="datagrid-item">
                                <div class="datagrid-title">Oluşturulma</div>
                                <div class="datagrid-content">{{ \Carbon\Carbon::parse($t->created_at)->format('d.m.Y H:i') }}</div>
                            </div>
                        </div>
                        @if($t->aciklama)
                        <div class="mt-3">
                            <label class="form-label">Açıklama</label>
                            <div class="card">
                                <div class="card-body">
                                    {{ $t->aciklama }}
                                </div>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-header">
                        <h3 class="card-title">Yapılan Tahsilatlar</h3>
                    </div>
                    @if($tahsilatlar->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-vcenter card-table">
                            <thead>
                                <tr>
                                    <th>Tarih</th>
                                    <th>Tutar</th>
                                    <th>Yöntem</th>
                                    <th>Açıklama</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($tahsilatlar as $tahsilat)
                                <tr>
                                    <td>{{ \Carbon\Carbon::parse($tahsilat->tahsilat_tarihi)->format('d.m.Y') }}</td>
                                    <td><strong>{{ number_format($tahsilat->tutar, 2, ',', '.') }} ₺</strong></td>
                                    <td>{{ $tahsilat->yontem ?? '-' }}</td>
                                    <td>{{ $tahsilat->aciklama ?? '-' }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @else
                    <div class="card-body">
                        <div class="empty">
                            <div class="empty-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M17 8v-3a1 1 0 0 0 -1 -1h-10a2 2 0 0 0 0 4h12a1 1 0 0 1 1 1v3m0 4v3a1 1 0 0 1 -1 1h-12a2 2 0 0 1 -2 -2v-12" /><path d="M20 12v4h-4a2 2 0 0 1 0 -4h4" /></svg>
                            </div>
                            <p class="empty-title">Henüz tahsilat yapılmamış</p>
                        </div>
                    </div>
                    @endif
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Ödeme Durumu</h3>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <div class="text-secondary mb-1">Toplam Tahakkuk</div>
                            <div class="h2 mb-0 text-primary">{{ number_format($t->tutar, 2, ',', '.') }} ₺</div>
                        </div>
                        <div class="mb-3">
                            <div class="text-secondary mb-1">Toplam Ödenen</div>
                            <div class="h2 mb-0 text-success">{{ number_format($toplamOdeme, 2, ',', '.') }} ₺</div>
                        </div>
                        <div class="mb-3">
                            <div class="text-secondary mb-1">Kalan Borç</div>
                            <div class="h2 mb-0 {{ $kalanBorc > 0 ? 'text-danger' : 'text-success' }}">
                                {{ number_format($kalanBorc, 2, ',', '.') }} ₺
                            </div>
                        </div>
                        <div class="progress progress-sm">
                            <div class="progress-bar bg-success" style="width: {{ $t->tutar > 0 ? ($toplamOdeme / $t->tutar * 100) : 0 }}%"></div>
                        </div>
                        <div class="text-secondary mt-2">
                            {{ $t->tutar > 0 ? number_format(($toplamOdeme / $t->tutar * 100), 1) : 0 }}% ödendi
                        </div>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-header">
                        <h3 class="card-title">Tehlikeli İşlemler</h3>
                    </div>
                    <div class="card-body">
                        @if($tahsilatlar->count() > 0)
                        <div class="alert alert-warning">
                            <div class="d-flex">
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon alert-icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 9v4" /><path d="M10.363 3.591l-8.106 13.534a1.914 1.914 0 0 0 1.636 2.871h16.214a1.914 1.914 0 0 0 1.636 -2.87l-8.106 -13.536a1.914 1.914 0 0 0 -3.274 0z" /><path d="M12 16h.01" /></svg>
                                </div>
                                <div>
                                    <h4 class="alert-title">Uyarı</h4>
                                    <div class="text-secondary">Bu tahakkuka ait tahsilatlar bulunmaktadır. Silme işlemi yapılamaz.</div>
                                </div>
                            </div>
                        </div>
                        @else
                        <div class="alert alert-danger mb-3">
                            <div class="d-flex">
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon alert-icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 9v4" /><path d="M10.363 3.591l-8.106 13.534a1.914 1.914 0 0 0 1.636 2.871h16.214a1.914 1.914 0 0 0 1.636 -2.87l-8.106 -13.536a1.914 1.914 0 0 0 -3.274 0z" /><path d="M12 16h.01" /></svg>
                                </div>
                                <div>
                                    <h4 class="alert-title">Dikkat!</h4>
                                    <div class="text-secondary">Bu işlem geri alınamaz.</div>
                                </div>
                            </div>
                        </div>
                        <form action="{{ route('superadmin.tahakkuk.destroy', $t->id) }}" method="POST" onsubmit="return confirm('Bu tahakkuku silmek istediğinizden emin misiniz?');">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M4 7l16 0" /><path d="M10 11l0 6" /><path d="M14 11l0 6" /><path d="M5 7l1 12a2 2 0 0 0 2 2h8a2 2 0 0 0 2 -2l1 -12" /><path d="M9 7v-3a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v3" /></svg>
                                Tahakkuku Sil
                            </button>
                        </form>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
