@extends('layouts.superadmin')
@section('title', 'Tahakkuklar')
@section('content')
<div class="container py-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h5>Tahakkuklar</h5>
        <a class="btn btn-primary" href="{{ route('superadmin.tahakkuk.create') }}">Yeni Tahakkuk</a>
    </div>
    <div class="card"><div class="card-body">
        <table class="table">
            <thead><tr><th>Kurum</th><th>Başlık</th><th>Tutar</th><th>Vade</th><th>Aktif</th><th></th></tr></thead>
            <tbody>
            @foreach($tahakkuklar as $t)
                <tr>
                    <td>{{ DB::table('kurumlar')->where('id',$t->kurum_id)->value('ad') }}</td>
                    <td>{{ $t->baslik }}</td>
                    <td>{{ number_format($t->tutar,2,',','.') }}</td>
                    <td>{{ $t->vade_tarihi }}</td>
                    <td>{{ $t->aktif_mi ? 'Evet' : 'Hayır' }}</td>
                    <td class="text-end">
                        <a href="{{ route('superadmin.tahakkuk.show',$t->id) }}" class="btn btn-sm btn-info">Detay</a>
                        <a href="{{ route('superadmin.tahakkuk.edit',$t->id) }}" class="btn btn-sm btn-secondary">Düzenle</a>
                        <form method="post" action="{{ route('superadmin.tahakkuk.destroy',$t->id) }}" class="d-inline" onsubmit="return confirm('Silinsin mi?')">
                            @csrf @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-outline-danger">Sil</button>
                        </form>
                    </td>
                </tr>
            @endforeach
            </tbody>
        </table>
        {{ $tahakkuklar->links() }}
    </div></div>
</div>
@endsection
