@extends('layouts.superadmin')
@section('title', 'Tahakkuk Oluştur')
@section('content')
<div class="container py-4">
    <h5 class="mb-3">Yeni Tahakkuk</h5>
    <div class="card"><div class="card-body">
        <form method="post" action="{{ route('superadmin.tahakkuk.store') }}">
            @csrf
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">Kurum</label>
                    <select name="kurum_id" class="form-select" required>
                        <option value="">Seçiniz</option>
                        @foreach($kurumlar as $k)
                            <option value="{{ $k->id }}">{{ $k->ad }}</option>
                        @endforeach
                    </select>
                    @error('kurum_id')<div class="text-danger small">{{ $message }}</div>@enderror
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Başlık</label>
                    <input type="text" name="baslik" value="{{ old('baslik') }}" class="form-control" required>
                    @error('baslik')<div class="text-danger small">{{ $message }}</div>@enderror
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label">Tutar</label>
                    <input type="number" step="0.01" name="tutar" value="{{ old('tutar') }}" class="form-control" required>
                    @error('tutar')<div class="text-danger small">{{ $message }}</div>@enderror
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label">Vade Tarihi</label>
                    <input type="date" name="vade_tarihi" value="{{ old('vade_tarihi') }}" class="form-control">
                    @error('vade_tarihi')<div class="text-danger small">{{ $message }}</div>@enderror
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label">Aktif mi?</label>
                    <select name="aktif_mi" class="form-select">
                        <option value="1" {{ old('aktif_mi','1')=='1'?'selected':'' }}>Evet</option>
                        <option value="0" {{ old('aktif_mi')=='0'?'selected':'' }}>Hayır</option>
                    </select>
                </div>
                <div class="col-12 mb-3">
                    <label class="form-label">Açıklama</label>
                    <textarea name="aciklama" class="form-control" rows="3">{{ old('aciklama') }}</textarea>
                </div>
            </div>
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-success">Kaydet</button>
                <a href="{{ route('superadmin.tahakkuk.index') }}" class="btn btn-secondary">İptal</a>
            </div>
        </form>
    </div></div>
</div>
@endsection
