@extends('layouts.superadmin')

@section('title', 'Log Dosyası')

@section('content')
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <div class="page-pretitle">
                    Sistem Bakım
                </div>
                <h2 class="page-title">
                    Log Dosyası İçeriği
                </h2>
            </div>
            <div class="col-auto ms-auto d-print-none">
                <a href="{{ route('superadmin.sistem-bakim.index') }}" class="btn btn-secondary">
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M5 12l14 0" /><path d="M5 12l6 6" /><path d="M5 12l6 -6" /></svg>
                    Geri Dön
                </a>
            </div>
        </div>
    </div>
</div>

<div class="page-body">
    <div class="container-xl">
        <div class="row row-cards">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        @if(empty($logs))
                            <div class="empty">
                                <div class="empty-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M14 3v4a1 1 0 0 0 1 1h4" /><path d="M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z" /></svg>
                                </div>
                                <p class="empty-title">Log dosyası boş</p>
                                <p class="empty-subtitle text-secondary">
                                    Log dosyası boş veya bulunamadı.
                                </p>
                            </div>
                        @else
                            <div class="alert alert-warning">
                                <div class="d-flex">
                                    <div>
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon alert-icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 9v4" /><path d="M10.363 3.591l-8.106 13.534a1.914 1.914 0 0 0 1.636 2.871h16.214a1.914 1.914 0 0 0 1.636 -2.87l-8.106 -13.536a1.914 1.914 0 0 0 -3.274 0z" /><path d="M12 16h.01" /></svg>
                                    </div>
                                    <div>
                                        <h4 class="alert-title">Not</h4>
                                        <div class="text-secondary">Performans nedeniyle yalnızca son 50.000 karakter gösterilmektedir.</div>
                                    </div>
                                </div>
                            </div>
                            <div class="card" style="max-height: 600px; overflow-y: auto; background-color: #f8f9fa;">
                                <div class="card-body">
                                    <pre class="mb-0" style="white-space: pre-wrap; word-wrap: break-word; font-size: 11px; font-family: monospace;">{{ $logs }}</pre>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
