@extends('layouts.superadmin')
@section('title', 'Kurumlar')

@section('page-actions')
<div class="col-auto ms-auto d-print-none">
    <a href="{{ route('superadmin.kurumlar.create') }}" class="btn btn-primary">
        <i class="ti ti-plus me-1"></i>
        Yeni Kurum Ekle
    </a>
</div>
@endsection

@section('content')
<div class="row row-cards">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Kurum Listesi</h3>
            </div>
            <div class="table-responsive">
                <table class="table table-vcenter card-table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Kurum Adı</th>
                            <th>Slug</th>
                            <th>Ana Domain</th>
                            <th>Özel Domain</th>
                            <th>Durum</th>
                            <th class="w-1">İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($kurumlar as $kurum)
                        <tr>
                            <td class="text-muted">{{ $kurum->id }}</td>
                            <td>
                                <div class="d-flex py-1 align-items-center">
                                    <span class="avatar me-2" style="background-image: url(https://ui-avatars.com/api/?name={{ urlencode($kurum->ad) }}&background=206bc4&color=fff)"></span>
                                    <div class="flex-fill">
                                        <div class="font-weight-medium">{{ $kurum->ad }}</div>
                                        <div class="text-muted"><a href="#" class="text-reset">{{ $kurum->slug }}</a></div>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="badge badge-outline text-muted">{{ $kurum->slug }}</span>
                            </td>
                            <td class="text-muted">{{ $kurum->ana_domain ?? '-' }}</td>
                            <td class="text-muted">{{ $kurum->ozel_domain ?? '-' }}</td>
                            <td>
                                @if($kurum->aktif_mi)
                                    <span class="badge bg-success">Aktif</span>
                                @else
                                    <span class="badge bg-danger">Pasif</span>
                                @endif
                            </td>
                            <td>
                                <div class="btn-list flex-nowrap">
                                    <a href="{{ route('superadmin.kurumlar.show', $kurum->id) }}" class="btn btn-sm btn-icon btn-ghost-info" title="Detay">
                                        <i class="ti ti-eye"></i>
                                    </a>
                                    <a href="{{ route('superadmin.kurumlar.edit', $kurum->id) }}" class="btn btn-sm btn-icon btn-ghost-primary" title="Düzenle">
                                        <i class="ti ti-edit"></i>
                                    </a>
                                    <form action="{{ route('superadmin.kurumlar.destroy', $kurum->id) }}" method="POST" class="d-inline" onsubmit="return confirm('Bu kurumu silmek istediğinizden emin misiniz?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-icon btn-ghost-danger" title="Sil">
                                            <i class="ti ti-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="7" class="text-center text-muted py-4">
                                <i class="ti ti-folder-off icon mb-2" style="font-size: 2rem;"></i>
                                <div>Henüz kurum eklenmemiş</div>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            @if($kurumlar->hasPages())
            <div class="card-footer d-flex align-items-center">
                <p class="m-0 text-muted">
                    Toplam <span class="badge bg-secondary">{{ $kurumlar->total() }}</span> kurum gösteriliyor
                </p>
                <ul class="pagination m-0 ms-auto">
                    {{ $kurumlar->links() }}
                </ul>
            </div>
            @endif
        </div>
    </div>
</div>
@endsection
