@extends('layouts.superadmin')
@section('title', 'Kurumlar')
@section('content')
<div class="container py-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h5>Kurumlar</h5>
        <a class="btn btn-primary" href="{{ route('superadmin.kurumlar.create') }}">Yeni Kurum</a>
    </div>
    <div class="card"><div class="card-body">
        <table class="table">
            <thead>
            <tr><th>Ad</th><th>Slug</th><th>Ana Domain</th><th>Özel Domain</th><th>Aktif</th></tr>
            </thead>
            <tbody>
            @foreach($kurumlar as $k)
                <tr>
                    <td>{{ $k->ad }}</td>
                    <td>{{ $k->slug }}</td>
                    <td>{{ $k->ana_domain }}</td>
                    <td>{{ $k->ozel_domain }}</td>
                    <td>{{ $k->aktif_mi ? 'Evet' : 'Hayır' }}</td>
                </tr>
            @endforeach
            </tbody>
        </table>
        {{ $kurumlar->links() }}
    </div></div>
</div>
@endsection
