@extends('layouts.superadmin')
@section('title', 'Kurum Düzenle')
@section('content')
<div class="container py-4">
    <h5 class="mb-3">Kurum Düzenle</h5>
    <div class="card"><div class="card-body">
        <form method="post" action="{{ route('superadmin.kurumlar.update', $kurum->id) }}">
            @csrf
            @method('PUT')
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">Kurum Adı</label>
                    <input type="text" name="ad" value="{{ old('ad',$kurum->ad) }}" class="form-control" required>
                    @error('ad')<div class="text-danger small">{{ $message }}</div>@enderror
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Slug</label>
                    <input type="text" name="slug" value="{{ old('slug',$kurum->slug) }}" class="form-control" required>
                    @error('slug')<div class="text-danger small">{{ $message }}</div>@enderror
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Ana Domain</label>
                    <input type="text" name="ana_domain" value="{{ old('ana_domain',$kurum->ana_domain) }}" class="form-control">
                    @error('ana_domain')<div class="text-danger small">{{ $message }}</div>@enderror
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Özel Domain</label>
                    <input type="text" name="ozel_domain" value="{{ old('ozel_domain',$kurum->ozel_domain) }}" class="form-control">
                    @error('ozel_domain')<div class="text-danger small">{{ $message }}</div>@enderror
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Site Ana Domain</label>
                    <input type="text" name="site_ana_domain" value="{{ old('site_ana_domain',$kurum->site_ana_domain ?? '') }}" class="form-control" placeholder="siteadi.com">
                    @error('site_ana_domain')<div class="text-danger small">{{ $message }}</div>@enderror
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Subdomain Tipi</label>
                    <select name="subdomain_tipi" class="form-select">
                        <option value="slug" {{ old('subdomain_tipi', $kurum->subdomain_tipi ?? 'slug')=='slug'?'selected':'' }}>slug.siteadi.com</option>
                        <option value="kan" {{ old('subdomain_tipi', $kurum->subdomain_tipi ?? 'slug')=='kan'?'selected':'' }}>slug.kan.siteadi.com</option>
                    </select>
                    @error('subdomain_tipi')<div class="text-danger small">{{ $message }}</div>@enderror
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Aktif mi?</label>
                    <select name="aktif_mi" class="form-select">
                        <option value="1" {{ old('aktif_mi', (int)$kurum->aktif_mi)==1?'selected':'' }}>Evet</option>
                        <option value="0" {{ old('aktif_mi', (int)$kurum->aktif_mi)==0?'selected':'' }}>Hayır</option>
                    </select>
                </div>
            </div>
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-success">Güncelle</button>
                <a href="{{ route('superadmin.kurumlar.index') }}" class="btn btn-secondary">İptal</a>
            </div>
        </form>
        <hr>
        <form method="post" action="{{ route('superadmin.kurumlar.destroy', $kurum->id) }}" onsubmit="return confirm('Silmek istediğinize emin misiniz?')">
            @csrf
            @method('DELETE')
            <button type="submit" class="btn btn-outline-danger">Kurum Sil</button>
        </form>
    </div></div>
</div>
@endsection
