@extends('layouts.superadmin')
@section('title', 'Yeni Kurum')

@section('page-actions')
<div class="col-auto ms-auto d-print-none">
    <a href="{{ route('superadmin.kurumlar.index') }}" class="btn btn-secondary">
        <i class="ti ti-arrow-left me-1"></i>
        Geri Dön
    </a>
</div>
@endsection

@section('content')
<div class="row row-cards">
    <div class="col-12">
        <form method="post" action="{{ route('superadmin.kurumlar.store') }}" class="card">
            @csrf
            <div class="card-header">
                <h3 class="card-title">Kurum Bilgileri</h3>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label required">Kurum Adı</label>
                            <input type="text" name="ad" value="{{ old('ad') }}" class="form-control @error('ad') is-invalid @enderror" placeholder="Örn: Ankara Üniversitesi" required>
                            @error('ad')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label required">Slug</label>
                            <div class="input-group">
                                <input type="text" name="slug" value="{{ old('slug') }}" class="form-control @error('slug') is-invalid @enderror" placeholder="ankara-universitesi" required>
                                <span class="input-group-text">
                                    <i class="ti ti-link"></i>
                                </span>
                            </div>
                            @error('slug')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-hint">URL dostu benzersiz tanımlayıcı</small>
                        </div>
                    </div>
                </div>

                <div class="row g-3">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label">Ana Domain</label>
                            <div class="input-group">
                                <span class="input-group-text">
                                    <i class="ti ti-world"></i>
                                </span>
                                <input type="text" name="ana_domain" value="{{ old('ana_domain') }}" class="form-control @error('ana_domain') is-invalid @enderror" placeholder="ankara.edu.tr">
                            </div>
                            @error('ana_domain')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label">Özel Domain</label>
                            <div class="input-group">
                                <span class="input-group-text">
                                    <i class="ti ti-world-www"></i>
                                </span>
                                <input type="text" name="ozel_domain" value="{{ old('ozel_domain') }}" class="form-control @error('ozel_domain') is-invalid @enderror" placeholder="kan.ankara.edu.tr">
                            </div>
                            @error('ozel_domain')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="row g-3">
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label class="form-label">Site Ana Domain</label>
                            <input type="text" name="site_ana_domain" value="{{ old('site_ana_domain') }}" class="form-control @error('site_ana_domain') is-invalid @enderror" placeholder="kanbankasi.com">
                            @error('site_ana_domain')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-hint">Ana site domain adı</small>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label class="form-label">Subdomain Tipi</label>
                            <select name="subdomain_tipi" class="form-select @error('subdomain_tipi') is-invalid @enderror">
                                <option value="slug" {{ old('subdomain_tipi','slug')=='slug'?'selected':'' }}>slug.siteadi.com</option>
                                <option value="kan" {{ old('subdomain_tipi')=='kan'?'selected':'' }}>slug.kan.siteadi.com</option>
                            </select>
                            @error('subdomain_tipi')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label class="form-label">Durum</label>
                            <select name="aktif_mi" class="form-select">
                                <option value="1" {{ old('aktif_mi','1')=='1'?'selected':'' }}>Aktif</option>
                                <option value="0" {{ old('aktif_mi')=='0'?'selected':'' }}>Pasif</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-footer text-end">
                <div class="d-flex">
                    <a href="{{ route('superadmin.kurumlar.index') }}" class="btn btn-link">İptal</a>
                    <button type="submit" class="btn btn-primary ms-auto">
                        <i class="ti ti-device-floppy me-1"></i>
                        Kaydet
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection
