@extends('layouts.superadmin-tabler')
@section('title', 'Yeni Kurum')

@section('page-actions')
<div class="col-auto ms-auto d-print-none">
    <a href="{{ route('superadmin.kurumlar.index') }}" class="btn btn-secondary">
        <i class="ti ti-arrow-left me-1"></i>
        Geri Dön
    </a>
</div>
@endsection

@section('content')
<div class="container py-4">
    <h5 class="mb-3">Yeni Kurum Oluştur</h5>
    <div class="card"><div class="card-body">
        <form method="post" action="{{ route('superadmin.kurumlar.store') }}">
            @csrf
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">Kurum Adı</label>
                    <input type="text" name="ad" value="{{ old('ad') }}" class="form-control" required>
                    @error('ad')<div class="text-danger small">{{ $message }}</div>@enderror
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Slug</label>
                    <input type="text" name="slug" value="{{ old('slug') }}" class="form-control" required>
                    @error('slug')<div class="text-danger small">{{ $message }}</div>@enderror
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Ana Domain</label>
                    <input type="text" name="ana_domain" value="{{ old('ana_domain') }}" class="form-control">
                    @error('ana_domain')<div class="text-danger small">{{ $message }}</div>@enderror
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Özel Domain</label>
                    <input type="text" name="ozel_domain" value="{{ old('ozel_domain') }}" class="form-control">
                    @error('ozel_domain')<div class="text-danger small">{{ $message }}</div>@enderror
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Site Ana Domain</label>
                    <input type="text" name="site_ana_domain" value="{{ old('site_ana_domain') }}" class="form-control" placeholder="siteadi.com">
                    @error('site_ana_domain')<div class="text-danger small">{{ $message }}</div>@enderror
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Subdomain Tipi</label>
                    <select name="subdomain_tipi" class="form-select">
                        <option value="slug" {{ old('subdomain_tipi','slug')=='slug'?'selected':'' }}>slug.siteadi.com</option>
                        <option value="kan" {{ old('subdomain_tipi')=='kan'?'selected':'' }}>slug.kan.siteadi.com</option>
                    </select>
                    @error('subdomain_tipi')<div class="text-danger small">{{ $message }}</div>@enderror
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Aktif mi?</label>
                    <select name="aktif_mi" class="form-select">
                        <option value="1" {{ old('aktif_mi','1')=='1'?'selected':'' }}>Evet</option>
                        <option value="0" {{ old('aktif_mi')=='0'?'selected':'' }}>Hayır</option>
                    </select>
                </div>
            </div>
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-success">Kaydet</button>
                <a href="{{ route('superadmin.kurumlar.index') }}" class="btn btn-secondary">İptal</a>
            </div>
        </form>
    </div></div>
</div>
@endsection
