<li class="list-group-item d-flex justify-content-between align-items-center" id="item-{{ $tur }}-{{ $item->id }}">
    <div>
        <span class="item-label" onclick="toggleNested(this)" ondblclick="makeEditable(this)" data-id="{{ $item->id }}" data-tur="{{ $tur }}">{{ $item->ad }}</span>
    </div>
    <div class="actions">
        @if($cocuk_tur)
        <button class="btn btn-sm btn-primary" onclick="showAddForm('{{ $cocuk_tur }}', {{ $item->id }})">(+)</button>
        @endif
        <button class="btn btn-sm btn-danger" onclick="deleteItem({{ $item->id }}, '{{ $tur }}')">Sil</button>
    </div>
</li>
@if($cocuk_tur)
<div class="nested-list" style="display: none;">
    <div class="add-form" id="add-form-{{ $cocuk_tur }}-{{ $item->id }}">
        <div class="input-group my-2">
            <input type="text" class="form-control" placeholder="Yeni {{ ucfirst($cocuk_tur) }} Adı">
            <button class="btn btn-success" onclick="addItem('{{ $cocuk_tur }}', {{ $item->id }})">Ekle</button>
            <button class="btn btn-secondary" onclick="hideAddForm('{{ $cocuk_tur }}', {{ $item->id }})">İptal</button>
        </div>
    </div>
    <ul class="list-group">
        @if(isset($cocuklar) && $cocuklar->count() > 0)
            @foreach($cocuklar as $cocuk_item)
                @php
                    $next_cocuk_tur = null;
                    $next_cocuklar = collect();
                    if ($cocuk_tur === 'ilce') {
                        $next_cocuk_tur = 'belde';
                        $next_cocuklar = $tum_beldeler->get($cocuk_item->id) ?? collect();
                    } elseif ($cocuk_tur === 'belde') {
                        $next_cocuk_tur = 'mahalle';
                        $next_cocuklar = $tum_mahalleler->get($cocuk_item->id) ?? collect();
                    }
                @endphp
                @include('admin.bolge-tanimlamalari.partials.bolge_item', [
                    'item' => $cocuk_item,
                    'tur' => $cocuk_tur,
                    'cocuk_tur' => $next_cocuk_tur,
                    'cocuklar' => $next_cocuklar,
                    'tum_ilceler' => $tum_ilceler,
                    'tum_beldeler' => $tum_beldeler,
                    'tum_mahalleler' => $tum_mahalleler
                ])
            @endforeach
        @endif
    </ul>
</div>
@endif
