@extends('layouts.superadmin')
@section('title', 'Bölge Tanımlamaları')

@push('css')
<style>
    .list-group-item {
        border-radius: 0;
    }
    .list-group-item .actions {
        opacity: 0;
        transition: opacity 0.2s ease-in-out;
    }
    .list-group-item:hover .actions {
        opacity: 1;
    }
    .nested-list {
        padding-left: 25px;
        border-left: 1px solid #ddd;
    }
    .add-form {
        display: none;
        margin-top: 10px;
    }
    .item-label {
        cursor: pointer;
    }
     .item-label:hover {
        color: #007bff;
    }
</style>
@endpush

@section('content')
<div class="container py-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h5>Bölge Tanımlamaları</h5>
    </div>

    <div class="alert alert-info">
        <ul>
            <li>Yeni birim eklemek için ilgili listenin başındaki <strong>(+)</strong> ikonuna tıklayın.</li>
            <li>Birim adını düzenlemek için üzerine çift tıklayın.</li>
            <li>Alt birimleri görmek/gizlemek için birim adının üzerine tıklayın.</li>
        </ul>
    </div>

    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            İller
            <button class="btn btn-sm btn-primary" onclick="showAddForm('il', 0)">(+)</button>
        </div>
        <div class="card-body">
            <div class="add-form" id="add-form-il-0">
                <div class="input-group">
                    <input type="text" class="form-control" placeholder="Yeni İl Adı">
                    <button class="btn btn-success" onclick="addItem('il', 0)">Ekle</button>
                    <button class="btn btn-secondary" onclick="hideAddForm('il', 0)">İptal</button>
                </div>
            </div>
            <ul class="list-group" id="il-list">
                @foreach($iller as $il)
                    @include('superadmin.bolge-tanimlamalari.partials.bolge_item', [
                        'item' => $il,
                        'tur' => 'il',
                        'cocuk_tur' => 'ilce',
                        'cocuklar' => $ilceler->get($il->id) ?? [],
                        'tum_ilceler' => $ilceler,
                        'tum_beldeler' => $beldeler,
                        'tum_mahalleler' => $mahalleler
                    ])
                @endforeach
            </ul>
        </div>
    </div>
</div>

@endsection

@push('betikler')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    const storeUrl = "{{ route('superadmin.bolge-tanimlamalari.store') }}";
    const updateUrl = "{{ url('superadmin/bolge-tanimlamalari/update') }}";
    const destroyUrl = "{{ url('superadmin/bolge-tanimlamalari/destroy') }}";
    const csrfToken = "{{ csrf_token() }}";

    function toggleNested(element) {
        const nestedList = element.nextElementSibling;
        if (nestedList && nestedList.classList.contains('nested-list')) {
            nestedList.style.display = nestedList.style.display === 'none' ? 'block' : 'none';
        }
    }

    function showAddForm(tur, parentId) {
        const form = document.getElementById(`add-form-${tur}-${parentId}`);
        if(form) form.style.display = 'block';
    }

    function hideAddForm(tur, parentId) {
        const form = document.getElementById(`add-form-${tur}-${parentId}`);
        if(form) {
            form.style.display = 'none';
            form.querySelector('input').value = '';
        }
    }

    function addItem(tur, parentId) {
        const form = document.getElementById(`add-form-${tur}-${parentId}`);
        const input = form.querySelector('input');
        const ad = input.value.trim();

        if (!ad) {
            Swal.fire('Hata', 'Birim adı boş olamaz.', 'error');
            return;
        }

        fetch(storeUrl, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': csrfToken,
                'Accept': 'application/json'
            },
            body: JSON.stringify({ ad, tur, parent_id: parentId })
        })
        .then(response => response.json())
        .then(data => {
            if (data.error) {
                throw new Error(data.error);
            }
            location.reload(); // En basit yöntem, daha sonra dinamik ekleme yapılabilir.
        })
        .catch(error => {
            Swal.fire('Hata', error.message, 'error');
        });
    }

    function deleteItem(id, tur) {
        Swal.fire({
            title: 'Emin misiniz?',
            text: "Bu birimi silmek istediğinizden emin misiniz? Bu işlemin geri dönüşü yoktur!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Evet, sil!',
            cancelButtonText: 'İptal'
        }).then((result) => {
            if (result.isConfirmed) {
                fetch(destroyUrl, {
                    method: 'POST', // DELETE normalde ama form gibi POST kullandık
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': csrfToken,
                        'Accept': 'application/json'
                    },
                    body: JSON.stringify({ id, tur, _method: 'DELETE' })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.error) {
                        throw new Error(data.error);
                    }
                    document.getElementById(`item-${tur}-${id}`).remove();
                    Swal.fire('Silindi!', 'Birim başarıyla silindi.', 'success');
                })
                .catch(error => {
                    Swal.fire('Hata', error.message, 'error');
                });
            }
        });
    }

    function makeEditable(label) {
        label.setAttribute('contenteditable', true);
        label.focus();
        const originalText = label.innerText;
        label.addEventListener('blur', () => {
            label.setAttribute('contenteditable', false);
            const newText = label.innerText.trim();
            if (newText !== originalText && newText !== '') {
                const id = label.dataset.id;
                const tur = label.dataset.tur;
                updateItem(id, tur, newText, label, originalText);
            } else {
                label.innerText = originalText; // Revert if empty or unchanged
            }
        }, { once: true });
         label.addEventListener('keydown', (e) => {
            if (e.key === 'Enter') {
                e.preventDefault();
                label.blur();
            } else if (e.key === 'Escape') {
                label.innerText = originalText;
                label.blur();
            }
        });
    }

    function updateItem(id, tur, ad, label, originalText) {
         fetch(updateUrl, {
            method: 'POST', // PUT normalde ama form gibi POST kullandık
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': csrfToken,
                'Accept': 'application/json'
            },
            body: JSON.stringify({ id, tur, ad, _method: 'PUT' })
        })
        .then(response => response.json())
        .then(data => {
            if (data.error) {
                throw new Error(data.error);
            }
            label.innerText = data.ad;
            Swal.fire('Güncellendi', 'Birim adı güncellendi.', 'success');
        })
        .catch(error => {
            label.innerText = originalText; // Revert on error
            Swal.fire('Hata', error.message, 'error');
        });
    }

</script>
@endpush
