<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Link Süresi Doldu</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        /* Genel Sıfırlama ve Font */
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        body {
            font-family: 'Roboto', sans-serif;
            background: linear-gradient(180deg, #001f3f 0%, #0a4d6e 25%, #2c5f7f 50%, #6a4c7c 75%, #c9557d 100%);
            color: #333;
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
            position: relative;
            overflow-x: hidden;
        }

        /* Yıldızlar */
        body::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background:
                radial-gradient(2px 2px at 20px 30px, white, transparent),
                radial-gradient(2px 2px at 60px 70px, white, transparent),
                radial-gradient(1px 1px at 50px 50px, white, transparent),
                radial-gradient(1px 1px at 130px 80px, white, transparent),
                radial-gradient(2px 2px at 90px 10px, white, transparent),
                radial-gradient(1px 1px at 150px 120px, white, transparent),
                radial-gradient(2px 2px at 200px 40px, white, transparent),
                radial-gradient(1px 1px at 180px 90px, white, transparent);
            background-repeat: repeat;
            background-size: 250px 250px;
            animation: twinkle 3s ease-in-out infinite;
            pointer-events: none;
            z-index: 0;
        }

        @keyframes twinkle {
            0%, 100% { opacity: 0.8; }
            50% { opacity: 0.3; }
        }

        /* Ana Konteyner */
        .container {
            width: 100%;
            max-width: 600px;
            background-color: #fff;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            overflow: hidden;
            position: relative;
            z-index: 1;
        }

        /* İçerik */
        .content {
            padding: 40px 30px;
            text-align: center;
        }

        /* İkon */
        .icon-wrapper {
            margin-bottom: 25px;
        }

        .hourglass-icon {
            width: 80px;
            height: 80px;
            fill: #ffc107;
            opacity: 0.9;
        }

        /* Başlık */
        .title {
            font-size: 28px;
            font-weight: 700;
            color: #333;
            margin-bottom: 20px;
        }

        /* Uyarı Kutusu */
        .alert-box {
            background-color: #fff3cd;
            border: 1px solid #ffc107;
            border-radius: 6px;
            padding: 20px;
            margin-bottom: 25px;
            text-align: left;
        }

        .alert-title {
            font-size: 18px;
            font-weight: 600;
            color: #856404;
            margin-bottom: 10px;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .alert-icon {
            width: 24px;
            height: 24px;
            fill: #856404;
        }

        .alert-text {
            font-size: 15px;
            color: #856404;
            line-height: 1.6;
        }

        /* Bilgi Metni */
        .info-text {
            font-size: 14px;
            color: #6c757d;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }

        .info-icon {
            width: 20px;
            height: 20px;
            fill: #6c757d;
        }

        /* Responsive */
        @media (max-width: 600px) {
            body {
                padding: 10px;
            }

            .container {
                box-shadow: none;
                border-radius: 0;
            }

            .content {
                padding: 30px 20px;
            }

            .title {
                font-size: 24px;
            }

            .alert-title {
                font-size: 16px;
            }

            .alert-text {
                font-size: 14px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="content">
            <div class="icon-wrapper">
                <svg class="hourglass-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                    <path d="M6 20v-2a6 6 0 1 1 12 0v2a1 1 0 0 1 -1 1h-10a1 1 0 0 1 -1 -1z" />
                    <path d="M6 4v2a6 6 0 1 0 12 0v-2a1 1 0 0 0 -1 -1h-10a1 1 0 0 0 -1 1z" />
                </svg>
            </div>

            <h1 class="title">Link Süresi Doldu</h1>

            <div class="alert-box">
                <div class="alert-title">
                    <svg class="alert-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                        <path d="M12 9v4" />
                        <path d="M10.363 3.591l-8.106 13.534a1.914 1.914 0 0 0 1.636 2.871h16.214a1.914 1.914 0 0 0 1.636 -2.87l-8.106 -13.536a1.914 1.914 0 0 0 -3.274 0z" />
                        <path d="M12 16h.01" />
                    </svg>
                    Bu İlan Linkinin Süresi Dolmuştur
                </div>
                <div class="alert-text">
                    Güvenlik nedeniyle kan ilan linkleri 72 saat geçerlidir.<br>
                    Bu linkin geçerlilik süresi sona ermiştir.
                </div>
            </div>

            <div class="info-text">
                <svg class="info-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                    <path d="M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0" />
                    <path d="M12 9h.01" />
                    <path d="M11 12h1v4h1" />
                </svg>
                Güncel ilanlar için lütfen sisteme giriş yapın veya yeni bir SMS bildirimi bekleyin.
            </div>
        </div>
    </div>
</body>
</html>
