<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>İlan Detayı</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        /* Genel Sıfırlama ve Font */
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        body {
            font-family: 'Roboto', sans-serif;
            background: linear-gradient(180deg, #001f3f 0%, #0a4d6e 25%, #2c5f7f 50%, #6a4c7c 75%, #c9557d 100%);
            color: #333;
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
            position: relative;
            overflow-x: hidden;
        }

        /* Yıldızlar */
        body::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background:
                radial-gradient(2px 2px at 20px 30px, white, transparent),
                radial-gradient(2px 2px at 60px 70px, white, transparent),
                radial-gradient(1px 1px at 50px 50px, white, transparent),
                radial-gradient(1px 1px at 130px 80px, white, transparent),
                radial-gradient(2px 2px at 90px 10px, white, transparent),
                radial-gradient(1px 1px at 150px 120px, white, transparent),
                radial-gradient(2px 2px at 200px 40px, white, transparent),
                radial-gradient(1px 1px at 180px 90px, white, transparent);
            background-repeat: repeat;
            background-size: 250px 250px;
            animation: twinkle 3s ease-in-out infinite;
            pointer-events: none;
            z-index: 0;
        }

        @keyframes twinkle {
            0%, 100% { opacity: 0.8; }
            50% { opacity: 0.3; }
        }

        /* Ana Konteyner */
        .container {
            width: 100%;
            max-width: 800px;
            background-color: #fff;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            overflow: hidden;
            position: relative;
            z-index: 1;
        }

        /* Başlık Alanı */
        .header {
            background-color: #fff;
            padding: 15px 25px;
            border-bottom: 1px solid #eee;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .header h1 {
            font-size: 16px;
            font-weight: 500;
            color: #555;
            text-transform: uppercase;
        }

        .header h2 {
            font-size: 18px;
            font-weight: 700;
            color: #007bff;
        }
        
        /* İçerik Bölümleri (Kartlar) */
        .section-card {
            padding: 25px;
            border-bottom: 1px solid #eee;
        }

        .section-card:last-child {
            border-bottom: none;
        }

        .section-card h3 {
            font-size: 16px;
            font-weight: 500;
            color: #007bff;
            margin-bottom: 20px;
            padding-bottom: 5px;
            border-bottom: 2px solid #007bff;
            display: inline-block;
        }

        /* Bilgi Satırları */
        .info-row {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
        }

        .info-item {
            flex: 1 1 30%;
            min-width: 150px;
            padding-right: 15px;
        }

        /* İlan Durumu için özel düzen */
        #ilan-durumu .info-item {
            flex: 1 1 40%;
        }

        .label {
            font-size: 13px;
            color: #888;
            margin-bottom: 5px;
            text-transform: uppercase;
            font-weight: 500;
            display: block;
        }

        .value {
            font-size: 15px;
            font-weight: 400;
            color: #333;
            padding: 8px 0;
            border-bottom: 1px solid #eee;
        }

        /* Kırmızı Vurgu Etiketi */
        .badge-red {
            display: inline-block;
            background-color: #f8d7da;
            color: #721c24;
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 12px;
            font-weight: 500;
        }

        /* Durum Vurgusu (Pasif) */
        .status-pasif {
            color: #6c757d;
            font-weight: 500;
        }

        .status-aktif {
            color: #28a745;
            font-weight: 500;
        }

        /* Açıklama/Notlar Alanı */
        #aciklama-notlar .value {
            border-bottom: none;
            min-height: 50px;
        }

        /* --- BUTONLAR ALANI CSS'İ --- */

        .action-buttons {
            padding: 25px;
            display: flex;
            justify-content: space-between; /* Butonları uçlara yaslar */
            gap: 15px;
            background-color: #fff; /* Aynı kart arka planı */
            border-top: 1px solid #eee;
        }

        .btn {
            flex: 1; /* Butonların eşit genişlikte olmasını sağlar */
            padding: 12px 15px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 16px;
            font-weight: 500;
            text-align: center;
            transition: background-color 0.3s ease;
            text-decoration: none; /* Linkler için */
            display: block; /* Tam genişlik kaplaması için */
        }

        .btn-whatsapp {
            background-color: #25D366; /* WhatsApp yeşili */
            color: white;
        }

        .btn-whatsapp:hover {
            background-color: #128C7E;
        }

        .btn-share {
            background-color: #007bff; /* Mavi (Panelin ana rengi) */
            color: white;
        }

        .btn-share:hover {
            background-color: #0056b3;
        }
        
        /* Responsive Tasarım - Mobil Uyarlaması */
        @media (max-width: 600px) {
            body {
                padding: 10px;
            }

            .container {
                box-shadow: none;
                border-radius: 0;
            }

            .header {
                padding: 10px 15px;
            }

            .section-card {
                padding: 15px;
            }
            
            .info-row {
                flex-direction: column;
                gap: 10px;
            }

            .info-item, #ilan-durumu .info-item {
                flex: 1 1 100%;
                min-width: auto;
                padding-right: 0;
            }

            /* Mobil Butonlar */
            .action-buttons {
                flex-direction: column; /* Butonları alt alta sıralar */
                padding: 15px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        
        <div class="header">
            <h1>{{ $kurum && isset($kurum->ad) ? $kurum->ad : 'KURUM ADI' }} - ACİL KAN İLANI</h1>
            <h2>İlan Detayı</h2>
        </div>

        <div class="section-card">
            <h3>Hasta ve İletişim Bilgileri</h3>
            <div class="info-row">
                <div class="info-item">
                    <span class="label">AD SOYAD</span>
                    <div class="value">{{ $ilan && isset($ilan->hasta_ad_soyad) ? $ilan->hasta_ad_soyad : '-' }}</div>
                </div>
                <div class="info-item">
                    <span class="label">KAN GRUBU</span>
                    <div class="value"><span class="badge-red">{{ $kanGrubu && isset($kanGrubu->ad) ? $kanGrubu->ad : 'Belirtilmemiş' }}</span></div>
                </div>
                <div class="info-item">
                    <span class="label">ÜNİTE SAYISI</span>
                    <div class="value">{{ $ilan && isset($ilan->unite_sayisi) ? $ilan->unite_sayisi : '-' }} Ünite</div>
                </div>
                <div class="info-item">
                    <span class="label">BAĞIŞ TÜRÜ</span>
                    <div class="value">
                        @if($ilan && isset($ilan->bagis_turu))
                            {{ $ilan->bagis_turu == 'kan_unitesi' ? 'Kan Ünitesi' : 'Canlı Bağışçı' }}
                        @else
                            -
                        @endif
                    </div>
                </div>
                <div class="info-item">
                    <span class="label">İHTİYAÇ TARİHİ</span>
                    <div class="value">
                        @if($ilan && isset($ilan->tarih))
                            {{ \Carbon\Carbon::parse($ilan->tarih)->format('d.m.Y') }}
                            @if($ilan->saat)
                                {{ $ilan->saat }}
                            @endif
                        @else
                            -
                        @endif
                    </div>
                </div>
                <div class="info-item">
                    <span class="label">TELEFON</span>
                    <div class="value">{{ $ilan && isset($ilan->irtibat_telefonu) ? $ilan->irtibat_telefonu : '-' }}</div>
                </div>
                @if($ilan && isset($ilan->yakin_kisi_telefon) && $ilan->yakin_kisi_telefon)
                <div class="info-item">
                    <span class="label">YAKIN KİŞİ TELEFON</span>
                    <div class="value">{{ $ilan->yakin_kisi_telefon }}</div>
                </div>
                @endif
                <div class="info-item">
                    <span class="label">İL / İLÇE</span>
                    <div class="value">{{ $kullaniciIl && isset($kullaniciIl->ad) ? $kullaniciIl->ad : '-' }} / {{ $kullaniciIlce && isset($kullaniciIlce->ad) ? $kullaniciIlce->ad : '-' }}</div>
                </div>
            </div>
        </div>
        

        <div class="section-card">
            <h3>Hastane Bilgileri</h3>
            <div class="info-row">
                <div class="info-item">
                    <span class="label">HASTANE</span>
                    <div class="value">{{ $ilan && isset($ilan->hastane_adi) ? $ilan->hastane_adi : '-' }}</div>
                </div>
                <div class="info-item">
                    <span class="label">KONUM</span>
                    <div class="value">{{ $hastaneIlce && isset($hastaneIlce->ad) ? $hastaneIlce->ad : '-' }} / {{ $hastaneIl && isset($hastaneIl->ad) ? $hastaneIl->ad : '-' }}</div>
                </div>

            <div class="info-item">
                    <span class="label">HASTANE ADRESİ</span>
                    <div class="value">{{ $ilan && isset($ilan->hastane_adresi) ? $ilan->hastane_adresi : '-' }}</div>
                </div>
                <div class="info-item" style="opacity: 0;"></div>
            </div>
        </div>

        <div class="section-card" id="ilan-durumu">
            <h3>İlan Durumu</h3>
            <div class="info-row">
                <div class="info-item">
                    <span class="label">DURUM</span>
                    <div class="value">
                        @if($ilan && isset($ilan->durum) && $ilan->durum == 'aktif')
                            <span class="status-aktif">Aktif</span>
                        @else
                            <span class="status-pasif">Pasif</span>
                        @endif
                    </div>
                </div>
                <div class="info-item">
                    <span class="label">İLAN TARİHİ</span>
                    <div class="value">{{ $ilan && isset($ilan->created_at) ? \Carbon\Carbon::parse($ilan->created_at)->format('d.m.Y H:i') : '-' }}</div>
                </div>
                <div class="info-item">
                    <span class="label">SON GÜNCELLEME</span>
                    <div class="value">{{ $ilan && isset($ilan->updated_at) ? \Carbon\Carbon::parse($ilan->updated_at)->format('d.m.Y H:i') : '-' }}</div>
                </div>
            </div>
        </div>

        @if($ilan && isset($ilan->notlar) && $ilan->notlar)
        <div class="section-card" id="aciklama-notlar">
            <h3>Açıklama/Notlar</h3>
            <div class="info-row">
                <div class="info-item" style="flex: 1 1 100%;">
                    <div class="value">{{ $ilan->notlar }}</div>
                </div>
            </div>
        </div>
        @endif

        <div class="action-buttons">
            <a href="https://wa.me/?text=Acil%20Kan%20İlanı!%0A{{ $ilan && isset($ilan->hasta_ad_soyad) ? $ilan->hasta_ad_soyad : '' }}%20için%20{{ $kanGrubu && isset($kanGrubu->ad) ? $kanGrubu->ad : '' }}%20kan%20grubu%20aranıyor.%0A{{ $ilan && isset($ilan->unite_sayisi) ? $ilan->unite_sayisi : '' }}%20ünite%20gerekli.%0AHastane:%20{{ $ilan && isset($ilan->hastane_adi) ? $ilan->hastane_adi : '' }}%0AIletişim:%20{{ $ilan && isset($ilan->irtibat_telefonu) ? $ilan->irtibat_telefonu : '' }}%0A%0ADetaylı%20bilgi:%20{{ url()->current() }}" 
               target="_blank" 
               class="btn btn-whatsapp">
                WhatsApp'tan Gönder
            </a>

            <button class="btn btn-share" onclick="handleShare()">
                Paylaş
            </button>
        </div>
        
    </div>

    <script>
        function handleShare() {
            const shareData = {
                title: 'Acil Kan İlanı',
                text: '{{ $hastaneIl && isset($hastaneIl->ad) ? $hastaneIl->ad : "" }}/{{ $ilan && isset($ilan->hastane_adi) ? $ilan->hastane_adi : "" }} hastanesinde acil kan ihtiyacı var.',
                url: window.location.href
            };

            if (navigator.share) {
                navigator.share(shareData)
                    .then(() => console.log('Başarılı paylaşım'))
                    .catch((error) => console.error('Paylaşım hatası', error));
            } else {
                navigator.clipboard.writeText(shareData.url);
                alert(`İlan linki panoya kopyalandı:\n${shareData.url}`);
            }
        }
    </script>
</body>
</html>
