<!doctype html>
<html lang="tr">
  <head>
    <meta charset="utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover"/>
    <meta http-equiv="X-UA-Compatible" content="ie=edge"/>
    <title>@yield('title') - Süperadmin Paneli</title>
    <!-- CSS files -->
    <link href="https://cdn.jsdelivr.net/npm/@tabler/core@1.0.0-beta20/dist/css/tabler.min.css" rel="stylesheet"/>
    <link href="https://cdn.jsdelivr.net/npm/@tabler/icons-webfont@latest/tabler-icons.min.css" rel="stylesheet"/>
    <style>
      @import url('https://rsms.me/inter/inter.css');
      :root {
        --tblr-font-sans-serif: 'Inter Var', -apple-system, BlinkMacSystemFont, San Francisco, Segoe UI, Roboto, Helvetica Neue, sans-serif;
      }
      body {
        font-feature-settings: "cv03", "cv04", "cv11";
      }
    </style>
    @stack('styles')
  </head>
  <body>
    <script src="https://cdn.jsdelivr.net/npm/@tabler/core@1.0.0-beta20/dist/js/tabler.min.js"></script>
    <div class="page">
      <!-- Sidebar -->
      <aside class="navbar navbar-vertical navbar-expand-lg" data-bs-theme="dark">
        <div class="container-fluid">
          <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#sidebar-menu" aria-controls="sidebar-menu" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
          </button>
          <h1 class="navbar-brand navbar-brand-autodark">
            <a href="{{ route('superadmin.anasayfa') }}">
              <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-droplet-filled text-red" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10.708 2.372a2.382 2.382 0 0 0 -.71 .686l-4.892 7.26c-1.981 3.314 -1.22 7.466 1.767 9.882c2.969 2.402 7.286 2.402 10.254 0c2.987 -2.416 3.748 -6.569 1.795 -9.836l-4.919 -7.306c-.722 -1.075 -2.192 -1.376 -3.295 -.686z" stroke-width="0" fill="currentColor" /></svg>
              <span class="ms-2">Kan Bankası</span>
            </a>
          </h1>
          <div class="collapse navbar-collapse" id="sidebar-menu">
            <ul class="navbar-nav pt-lg-3">
              <li class="nav-item {{ request()->routeIs('superadmin.anasayfa') ? 'active' : '' }}">
                <a class="nav-link" href="{{ route('superadmin.anasayfa') }}">
                  <span class="nav-link-icon d-md-none d-lg-inline-block">
                    <i class="ti ti-home"></i>
                  </span>
                  <span class="nav-link-title">Anasayfa</span>
                </a>
              </li>
              
              <li class="nav-item dropdown {{ request()->routeIs('superadmin.kurumlar.*') || request()->routeIs('superadmin.yoneticiler.*') ? 'active' : '' }}">
                <a class="nav-link dropdown-toggle" href="#navbar-kurum" data-bs-toggle="dropdown" data-bs-auto-close="false" role="button" aria-expanded="{{ request()->routeIs('superadmin.kurumlar.*') || request()->routeIs('superadmin.yoneticiler.*') ? 'true' : 'false' }}">
                  <span class="nav-link-icon d-md-none d-lg-inline-block">
                    <i class="ti ti-building"></i>
                  </span>
                  <span class="nav-link-title">Kurum Yönetimi</span>
                </a>
                <div class="dropdown-menu {{ request()->routeIs('superadmin.kurumlar.*') || request()->routeIs('superadmin.yoneticiler.*') ? 'show' : '' }}">
                  <div class="dropdown-menu-columns">
                    <div class="dropdown-menu-column">
                      <a class="dropdown-item {{ request()->routeIs('superadmin.kurumlar.*') ? 'active' : '' }}" href="{{ route('superadmin.kurumlar.index') }}">
                        <i class="ti ti-building-hospital me-2"></i>
                        Kurumlar
                      </a>
                      <a class="dropdown-item {{ request()->routeIs('superadmin.yoneticiler.*') ? 'active' : '' }}" href="{{ route('superadmin.yoneticiler.index') }}">
                        <i class="ti ti-users me-2"></i>
                        Yönetici Hesapları
                      </a>
                    </div>
                  </div>
                </div>
              </li>

              <li class="nav-item dropdown {{ request()->routeIs('superadmin.tahakkuk.*') || request()->routeIs('superadmin.tahsilat.*') ? 'active' : '' }}">
                <a class="nav-link dropdown-toggle" href="#navbar-mali" data-bs-toggle="dropdown" data-bs-auto-close="false" role="button" aria-expanded="{{ request()->routeIs('superadmin.tahakkuk.*') || request()->routeIs('superadmin.tahsilat.*') ? 'true' : 'false' }}">
                  <span class="nav-link-icon d-md-none d-lg-inline-block">
                    <i class="ti ti-cash"></i>
                  </span>
                  <span class="nav-link-title">Mali İşlemler</span>
                </a>
                <div class="dropdown-menu {{ request()->routeIs('superadmin.tahakkuk.*') || request()->routeIs('superadmin.tahsilat.*') ? 'show' : '' }}">
                  <div class="dropdown-menu-columns">
                    <div class="dropdown-menu-column">
                      <a class="dropdown-item {{ request()->routeIs('superadmin.tahakkuk.*') ? 'active' : '' }}" href="{{ route('superadmin.tahakkuk.index') }}">
                        <i class="ti ti-receipt me-2"></i>
                        Tahakkuklar
                      </a>
                      <a class="dropdown-item {{ request()->routeIs('superadmin.tahsilat.*') ? 'active' : '' }}" href="{{ route('superadmin.tahsilat.index') }}">
                        <i class="ti ti-coin me-2"></i>
                        Tahsilatlar
                      </a>
                    </div>
                  </div>
                </div>
              </li>

              <li class="nav-item {{ request()->routeIs('superadmin.sistem-bakim.*') ? 'active' : '' }}">
                <a class="nav-link" href="{{ route('superadmin.sistem-bakim.index') }}">
                  <span class="nav-link-icon d-md-none d-lg-inline-block">
                    <i class="ti ti-settings"></i>
                  </span>
                  <span class="nav-link-title">Sistem Bakım</span>
                </a>
              </li>
            </ul>
          </div>
        </div>
      </aside>
      
      <!-- Navbar -->
      <header class="navbar navbar-expand-md d-print-none">
        <div class="container-xl">
          <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbar-menu" aria-controls="navbar-menu" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
          </button>
          <div class="navbar-nav flex-row order-md-last">
            <div class="nav-item dropdown">
              <a href="#" class="nav-link d-flex lh-1 text-reset p-0" data-bs-toggle="dropdown" aria-label="Open user menu">
                <span class="avatar avatar-sm" style="background-image: url(https://ui-avatars.com/api/?name={{ urlencode(Auth::guard('superadmin')->user()->name) }}&background=206bc4&color=fff)"></span>
                <div class="d-none d-xl-block ps-2">
                  <div>{{ Auth::guard('superadmin')->user()->name }}</div>
                  <div class="mt-1 small text-muted">Süperadmin</div>
                </div>
              </a>
              <div class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
                <a href="{{ route('superadmin.profil.index') }}" class="dropdown-item">
                  <i class="ti ti-user me-2"></i>
                  Profil Ayarları
                </a>
                <div class="dropdown-divider"></div>
                <form method="POST" action="{{ route('superadmin.cikis') }}">
                  @csrf
                  <button type="submit" class="dropdown-item">
                    <i class="ti ti-logout me-2"></i>
                    Çıkış Yap
                  </button>
                </form>
              </div>
            </div>
          </div>
        </div>
      </header>
      
      <div class="page-wrapper">
        <!-- Page header -->
        <div class="page-header d-print-none">
          <div class="container-xl">
            <div class="row g-2 align-items-center">
              <div class="col">
                <div class="page-pretitle">
                  Süperadmin Paneli
                </div>
                <h2 class="page-title">
                  @yield('title')
                </h2>
              </div>
              @yield('page-actions')
            </div>
          </div>
        </div>
        
        <!-- Page body -->
        <div class="page-body">
          <div class="container-xl">
            @if(session('success'))
              <div class="alert alert-success alert-dismissible" role="alert">
                <div class="d-flex">
                  <div>
                    <i class="ti ti-check icon alert-icon"></i>
                  </div>
                  <div>
                    <h4 class="alert-title">Başarılı!</h4>
                    <div class="text-muted">{{ session('success') }}</div>
                  </div>
                </div>
                <a class="btn-close" data-bs-dismiss="alert" aria-label="close"></a>
              </div>
            @endif

            @if(session('error'))
              <div class="alert alert-danger alert-dismissible" role="alert">
                <div class="d-flex">
                  <div>
                    <i class="ti ti-alert-circle icon alert-icon"></i>
                  </div>
                  <div>
                    <h4 class="alert-title">Hata!</h4>
                    <div class="text-muted">{{ session('error') }}</div>
                  </div>
                </div>
                <a class="btn-close" data-bs-dismiss="alert" aria-label="close"></a>
              </div>
            @endif

            @if ($errors->any())
              <div class="alert alert-danger alert-dismissible" role="alert">
                <div class="d-flex">
                  <div>
                    <i class="ti ti-alert-circle icon alert-icon"></i>
                  </div>
                  <div>
                    <h4 class="alert-title">Hatalar!</h4>
                    <ul class="mb-0">
                      @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                      @endforeach
                    </ul>
                  </div>
                </div>
                <a class="btn-close" data-bs-dismiss="alert" aria-label="close"></a>
              </div>
            @endif
            
            @yield('content')
          </div>
        </div>
        
        <footer class="footer footer-transparent d-print-none">
          <div class="container-xl">
            <div class="row text-center align-items-center flex-row-reverse">
              <div class="col-12 col-lg-auto mt-3 mt-lg-0">
                <ul class="list-inline list-inline-dots mb-0">
                  <li class="list-inline-item">
                    Copyright &copy; {{ date('Y') }}
                    <a href="https://sinorsel.com.tr" target="_blank" class="link-secondary">Sinorsel Yazılım San. Tic. Ltd. Şti.</a>
                    Tüm hakları saklıdır.
                  </li>
                </ul>
              </div>
            </div>
          </div>
        </footer>
      </div>
    </div>
    @stack('scripts')
  </body>
</html>
