<!DOCTYPE html>
<html lang="tr">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="icon" type="image/png" href="{{ asset('favicon.png') }}">
    <title>
        @yield('title', 'Kan Bankası') - {{ $kurum->unvan ?? '' }}
    </title>
    <!-- CSS files -->
    <link href="{{ asset('dist/css/tabler.min.css?1692870487') }}" rel="stylesheet"/>
    <link href="{{ asset('dist/css/tabler-flags.min.css?1692870487') }}" rel="stylesheet"/>
    <link href="{{ asset('dist/css/tabler-payments.min.css?1692870487') }}" rel="stylesheet"/>
    <link href="{{ asset('dist/css/tabler-vendors.min.css?1692870487') }}" rel="stylesheet"/>
    <link href="{{ asset('dist/css/demo.min.css?1692870487') }}" rel="stylesheet"/>
    <style>
      @import url('https://rsms.me/inter/inter.css');
      :root {
      	--tblr-font-sans-serif: 'Inter Var', -apple-system, BlinkMacSystemFont, San Francisco, Segoe UI, Roboto, Helvetica Neue, sans-serif;
      }
      body {
      	font-feature-settings: "cv03", "cv04", "cv11";
      }
      .page-header-bg {
          background: linear-gradient(180deg, #001f3f 0%, #0a4d6e 25%, #2c5f7f 50%, #6a4c7c 75%, #c9557d 100%);
          min-height: 100vh;
          position: relative;
          overflow: hidden;
      }
      .page-header-bg::before {
          content: '';
          position: absolute;
          top: 0;
          left: 0;
          right: 0;
          bottom: 0;
          background-image: 
              radial-gradient(2px 2px at 20% 30%, white, transparent),
              radial-gradient(2px 2px at 60% 70%, white, transparent),
              radial-gradient(1px 1px at 50% 50%, white, transparent),
              radial-gradient(1px 1px at 80% 10%, white, transparent),
              radial-gradient(2px 2px at 90% 60%, white, transparent),
              radial-gradient(1px 1px at 33% 80%, white, transparent),
              radial-gradient(1px 1px at 15% 15%, white, transparent),
              radial-gradient(2px 2px at 70% 40%, white, transparent);
          background-size: 200% 200%;
          animation: twinkle 3s ease-in-out infinite;
          opacity: 0.8;
      }
      @keyframes twinkle {
          0%, 100% { opacity: 0.8; }
          50% { opacity: 0.4; }
      }
      .page-header-content {
          position: relative;
          z-index: 1;
          padding: 3rem 0;
      }
      .mountain-silhouette {
          position: absolute;
          bottom: 0;
          left: 0;
          width: 100%;
          height: 30%;
          background: linear-gradient(to top, rgba(0,0,0,0.8) 0%, rgba(0,0,0,0.6) 50%, transparent 100%);
          z-index: 0;
      }
      .mountain-silhouette::before {
          content: '';
          position: absolute;
          bottom: 0;
          left: -5%;
          width: 40%;
          height: 80%;
          background: #000;
          clip-path: polygon(0% 100%, 20% 40%, 40% 60%, 60% 30%, 80% 50%, 100% 100%);
      }
      .mountain-silhouette::after {
          content: '';
          position: absolute;
          bottom: 0;
          right: -5%;
          width: 40%;
          height: 70%;
          background: #000;
          clip-path: polygon(0% 100%, 20% 50%, 40% 30%, 60% 60%, 80% 40%, 100% 100%);
      }
    </style>
</head>

<body>
    <div class="page page-center page-header-bg">
        <div class="mountain-silhouette"></div>
        <div class="container page-header-content">
            @yield('content')
        </div>
        
        <footer class="footer footer-transparent d-print-none" style="position: absolute; bottom: 0; width: 100%; z-index: 2;">
            <div class="container-xl">
                <div class="row text-center align-items-center">
                    <div class="col-12 col-lg-auto mt-3 mt-lg-0">
                        <ul class="list-inline list-inline-dots mb-0">
                            <li class="list-inline-item text-white">
                                © <script>document.write(new Date().getFullYear())</script>
                                {{ $kurum->unvan ?? 'Kan Bankası Sistemi' }}
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </footer>
    </div>
    
    <!-- Tabler Core -->
    <script src="{{ asset('dist/js/tabler.min.js?1692870487') }}" defer></script>
    <script src="{{ asset('dist/js/demo.min.js?1692870487') }}" defer></script>
</body>

</html>
