<!doctype html>
<html lang="tr">
  <head>
    <meta charset="utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover"/>
    <meta http-equiv="X-UA-Compatible" content="ie=edge"/>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Kullanıcı Paneli') - {{ request()->attributes->get('kurum_adi', 'Kan Bankası') }}</title>
    <!-- CSS files -->
    <link href="https://cdn.jsdelivr.net/npm/@tabler/core@1.0.0-beta20/dist/css/tabler.min.css" rel="stylesheet"/>
    <link href="https://cdn.jsdelivr.net/npm/@tabler/icons-webfont@latest/tabler-icons.min.css" rel="stylesheet"/>
    <style>
      @import url('https://rsms.me/inter/inter.css');
      :root {
        --tblr-font-sans-serif: 'Inter Var', -apple-system, BlinkMacSystemFont, San Francisco, Segoe UI, Roboto, Helvetica Neue, sans-serif;
      }
      body {
        font-feature-settings: "cv03", "cv04", "cv11";
      }
    </style>
    @stack('styles')
  </head>
  <body>
    <script src="https://cdn.jsdelivr.net/npm/@tabler/core@1.0.0-beta20/dist/js/tabler.min.js"></script>
    <div class="page">
      <!-- Sidebar -->
      <aside class="navbar navbar-vertical navbar-expand-lg" data-bs-theme="dark">
        <div class="container-fluid">
          <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#sidebar-menu" aria-controls="sidebar-menu" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
          </button>
          <h1 class="navbar-brand navbar-brand-autodark">
            <a href="{{ route('kullanici.dashboard') }}">
              <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-droplet-filled text-red" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10.708 2.372a2.382 2.382 0 0 0 -.71 .686l-4.892 7.26c-1.981 3.314 -1.22 7.466 1.767 9.882c2.969 2.402 7.286 2.402 10.254 0c2.987 -2.416 3.748 -6.569 1.795 -9.836l-4.919 -7.306c-.722 -1.075 -2.192 -1.376 -3.295 -.686z" stroke-width="0" fill="currentColor" /></svg>
              <span class="ms-2">{{ request()->attributes->get('kurum_adi', 'Kan Bankası') }}</span>
            </a>
          </h1>
          <div class="collapse navbar-collapse" id="sidebar-menu">
            <ul class="navbar-nav pt-lg-3">
              <li class="nav-item {{ request()->routeIs('kullanici.dashboard') ? 'active' : '' }}">
                <a class="nav-link" href="{{ route('kullanici.dashboard') }}">
                  <span class="nav-link-icon d-md-none d-lg-inline-block">
                    <i class="ti ti-home"></i>
                  </span>
                  <span class="nav-link-title">Anasayfa</span>
                </a>
              </li>
              
              <li class="nav-item {{ request()->routeIs('kullanici.ilan.ver') ? 'active' : '' }}">
                <a class="nav-link" href="{{ route('kullanici.ilan.ver') }}">
                  <span class="nav-link-icon d-md-none d-lg-inline-block">
                    <i class="ti ti-droplet-plus"></i>
                  </span>
                  <span class="nav-link-title">Kan İlanı Ver</span>
                </a>
              </li>

              <li class="nav-item {{ request()->routeIs('kullanici.ilanlarim') ? 'active' : '' }}">
                <a class="nav-link" href="{{ route('kullanici.ilanlarim') }}">
                  <span class="nav-link-icon d-md-none d-lg-inline-block">
                    <i class="ti ti-list"></i>
                  </span>
                  <span class="nav-link-title">İlanlarım</span>
                </a>
              </li>

              <li class="nav-item {{ request()->routeIs('kullanici.profil') ? 'active' : '' }}">
                <a class="nav-link" href="{{ route('kullanici.profil') }}">
                  <span class="nav-link-icon d-md-none d-lg-inline-block">
                    <i class="ti ti-user"></i>
                  </span>
                  <span class="nav-link-title">Profilim</span>
                </a>
              </li>

              <li class="nav-item">
                <a class="nav-link" href="#" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                  <span class="nav-link-icon d-md-none d-lg-inline-block">
                    <i class="ti ti-logout"></i>
                  </span>
                  <span class="nav-link-title">Çıkış Yap</span>
                </a>
                <form id="logout-form" action="{{ route('cikis') }}" method="POST" style="display: none;">
                  @csrf
                </form>
              </li>
            </ul>
          </div>
        </div>
      </aside>
      <!-- Header -->
      <header class="navbar navbar-expand-md d-print-none">
        <div class="container-xl">
          <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#sidebar-menu" aria-controls="sidebar-menu" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
          </button>
          <h1 class="navbar-brand navbar-brand-autodark d-none-navbar-horizontal pe-0 pe-md-3">
            <a href="{{ route('kullanici.dashboard') }}">
              {{ request()->attributes->get('kurum_adi', 'Kan Bankası') }}
            </a>
          </h1>
          <div class="navbar-nav flex-row order-md-last">
            <div class="nav-item dropdown">
              <a href="#" class="nav-link d-flex lh-1 text-reset p-0" data-bs-toggle="dropdown" aria-label="Open user menu">
                <span class="avatar avatar-sm" style="background-image: url({{ asset('ui/assets/img/default-avatar.png') }})"></span>
                <div class="d-none d-xl-block ps-2">
                  <div>{{ Auth::guard('kullanici')->user()->ad }} {{ Auth::guard('kullanici')->user()->soyad }}</div>
                  <div class="mt-1 small text-muted">Kullanıcı</div>
                </div>
              </a>
              <div class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
                <a href="{{ route('kullanici.profil') }}" class="dropdown-item">Profilim</a>
                <div class="dropdown-divider"></div>
                <a href="#" class="dropdown-item" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">Çıkış Yap</a>
              </div>
            </div>
          </div>
        </div>
      </header>
      
      <div class="page-wrapper">
        <div class="page-header d-print-none">
          <div class="container-xl">
            <div class="row g-2 align-items-center">
              <div class="col">
                <h2 class="page-title">
                  @yield('title', 'Kullanıcı Paneli')
                </h2>
                <div class="page-pretitle">
                  @yield('subtitle', '')
                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="page-body">
          <div class="container-xl">
            @if (session('success'))
              <div class="alert alert-success alert-dismissible" role="alert">
                <div class="d-flex">
                  <div>
                    <i class="ti ti-check icon alert-icon"></i>
                  </div>
                  <div>
                    {{ session('success') }}
                  </div>
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>
            @endif
            
            @if ($errors->any())
              <div class="alert alert-danger alert-dismissible" role="alert">
                <div class="d-flex">
                  <div>
                    <i class="ti ti-alert-circle icon alert-icon"></i>
                  </div>
                  <div>
                    <ul class="mb-0">
                      @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                      @endforeach
                    </ul>
                  </div>
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>
            @endif

            @yield('content')
          </div>
        </div>

        <footer class="footer footer-transparent d-print-none">
          <div class="container-xl">
            <div class="row text-center align-items-center flex-row-reverse">
              <div class="col-12 col-lg-auto mt-3 mt-lg-0">
                <ul class="list-inline list-inline-dots mb-0">
                  <li class="list-inline-item">
                    © {{ date('Y') }} {{ request()->attributes->get('kurum_adi', 'Kan Bankası') }}
                  </li>
                </ul>
              </div>
            </div>
          </div>
        </footer>
      </div>
    </div>
    @stack('scripts')
  </body>
</html>
