@extends('layouts.kullanici')

@section('title', 'Profilim')
@section('page_title', 'Profil Bilgilerim')

@section('content')
<div class="row row-deck row-cards">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Profil Bilgilerini Güncelle</h3>
            </div>
            <div class="card-body">
                <form action="{{ route('kullanici.profil.update') }}" method="POST">
                    @csrf
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label required">Ad</label>
                            <input type="text" name="ad" class="form-control" value="{{ old('ad', $user->ad) }}" placeholder="Adınızı giriniz" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label required">Soyad</label>
                            <input type="text" name="soyad" class="form-control" value="{{ old('soyad', $user->soyad) }}" placeholder="Soyadınızı giriniz" required>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label required">E-posta Adresi</label>
                            <input type="email" name="email" class="form-control" value="{{ old('email', $user->email) }}" placeholder="ornek@email.com" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label required">Telefon Numarası</label>
                            <input type="text" name="telefon" class="form-control" value="{{ old('telefon', $user->telefon) }}" placeholder="5XXXXXXXXX" maxlength="10" required>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label required">Doğum Tarihi</label>
                            <input type="date" name="dogum_tarihi" class="form-control" value="{{ old('dogum_tarihi', $user->dogum_tarihi) }}" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label required">Kan Grubu</label>
                            @php
                                $mevcutKanGrubu = 'Belirsiz';
                                if ($user->kan_grubu_id) {
                                    $mevcutKanGrubu = DB::table('kan_gruplari')->where('id', $user->kan_grubu_id)->value('ad') ?? 'Belirsiz';
                                }
                            @endphp
                            <div class="input-group">
                                <input type="text" class="form-control" value="{{ $mevcutKanGrubu }}" readonly>
                                <button type="button" class="btn btn-icon" data-bs-toggle="modal" data-bs-target="#kanGrubuModal" title="Kan Grubunu Değiştir">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M7 7h-1a2 2 0 0 0 -2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2 -2v-1" /><path d="M20.385 6.585a2.1 2.1 0 0 0 -2.97 -2.97l-8.415 8.385v3h3l8.385 -8.415z" /><path d="M16 5l3 3" /></svg>
                                </button>
                            </div>
                            <small class="form-hint">Kan grubunuzu değiştirmek için OTP doğrulama gereklidir</small>
                        </div>
                    </div>
                    <hr class="my-4">
                    <h3 class="card-title mb-3">Bildirim Ayarları</h3>
                    <div class="row">
                        <div class="col-12">
                            <label class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="sms_izni" value="1" {{ old('sms_izni', $user->sms_izni) ? 'checked' : '' }}>
                                <span class="form-check-label">
                                    <strong>SMS Bildirimleri</strong>
                                    <span class="form-hint d-block">Kan grubu uyumlu acil kan ilanları için SMS bildirimi al</span>
                                </span>
                            </label>
                        </div>
                    </div>
                    <div class="form-footer">
                        <button type="submit" class="btn btn-primary">
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M5 12l5 5l10 -10" /></svg>
                            Bilgileri Güncelle
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Kan Grubu Değiştirme Modal -->
<div class="modal fade" id="kanGrubuModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Kan Grubunu Değiştir</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-warning">
                    <div class="d-flex">
                        <div>
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon alert-icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 9v2m0 4v.01" /><path d="M5 19h14a2 2 0 0 0 1.84 -2.75l-7.1 -12.25a2 2 0 0 0 -3.5 0l-7.1 12.25a2 2 0 0 0 1.75 2.75" /></svg>
                        </div>
                        <div>
                            <h4 class="alert-title">Önemli Uyarı</h4>
                            <div class="text-muted">Kan grubu değişikliği için telefonunuza gönderilen OTP kodunu girmeniz gerekmektedir.</div>
                        </div>
                    </div>
                </div>
                
                <form id="kanGrubuForm">
                    <input type="hidden" name="kan_grubu_degisti" id="kan_grubu_degisti" value="0">
                    
                    <div class="mb-3">
                        <label class="form-label required">Yeni Kan Grubu</label>
                        <select name="kan_grubu_id" id="yeni_kan_grubu_id" class="form-select" required>
                            <option value="">Kan grubu seçiniz...</option>
                            @foreach(DB::table('kan_gruplari')->get() as $kg)
                                <option value="{{ $kg->id }}" {{ $kg->id == $user->kan_grubu_id ? 'selected' : '' }}>{{ $kg->ad }}</option>
                            @endforeach
                        </select>
                    </div>
                    
                    <div id="otpSection" style="display: none;">
                        <div class="mb-3">
                            <label class="form-label required">OTP Kodu</label>
                            <div class="input-group">
                                <input type="text" name="otp_code" id="otp_code" class="form-control" placeholder="6 haneli kod" maxlength="6" pattern="[0-9]{6}">
                                <button type="button" class="btn btn-primary" id="sendOtpBtn">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><line x1="10" y1="14" x2="21" y2="3" /><path d="M21 3l-6.5 18a0.55 .55 0 0 1 -1 0l-3.5 -7l-7 -3.5a0.55 .55 0 0 1 0 -1l18 -6.5" /></svg>
                                    Kod Gönder
                                </button>
                            </div>
                            <small class="form-hint">Telefonunuza gönderilen 6 haneli kodu giriniz</small>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-link link-secondary" data-bs-dismiss="modal">İptal</button>
                <button type="button" class="btn btn-primary" id="saveKanGrubuBtn">Kaydet</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const kanGrubuSelect = document.getElementById('yeni_kan_grubu_id');
    const otpSection = document.getElementById('otpSection');
    const sendOtpBtn = document.getElementById('sendOtpBtn');
    const saveBtn = document.getElementById('saveKanGrubuBtn');
    const kanGrubuDegisti = document.getElementById('kan_grubu_degisti');
    const originalKanGrubu = '{{ $user->kan_grubu_id }}';
    
    // Kan grubu değiştiğinde OTP bölümünü göster
    kanGrubuSelect.addEventListener('change', function() {
        if (this.value != originalKanGrubu && this.value != '') {
            otpSection.style.display = 'block';
            kanGrubuDegisti.value = '1';
        } else {
            otpSection.style.display = 'none';
            kanGrubuDegisti.value = '0';
        }
    });
    
    // OTP gönder
    sendOtpBtn.addEventListener('click', function() {
        const btn = this;
        btn.disabled = true;
        btn.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>Gönderiliyor...';
        
        fetch('{{ route("kullanici.profil.send-otp") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert(data.message);
                btn.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M5 12l5 5l10 -10" /></svg> Gönderildi';
                
                // 60 saniye beklet
                let countdown = 60;
                const interval = setInterval(() => {
                    countdown--;
                    btn.innerHTML = `Tekrar gönder (${countdown}s)`;
                    if (countdown <= 0) {
                        clearInterval(interval);
                        btn.disabled = false;
                        btn.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><line x1="10" y1="14" x2="21" y2="3" /><path d="M21 3l-6.5 18a0.55 .55 0 0 1 -1 0l-3.5 -7l-7 -3.5a0.55 .55 0 0 1 0 -1l18 -6.5" /></svg> Kod Gönder';
                    }
                }, 1000);
            } else {
                alert('Hata: ' + data.message);
                btn.disabled = false;
                btn.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><line x1="10" y1="14" x2="21" y2="3" /><path d="M21 3l-6.5 18a0.55 .55 0 0 1 -1 0l-3.5 -7l-7 -3.5a0.55 .55 0 0 1 0 -1l18 -6.5" /></svg> Kod Gönder';
            }
        })
        .catch(error => {
            alert('Bir hata oluştu!');
            btn.disabled = false;
            btn.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><line x1="10" y1="14" x2="21" y2="3" /><path d="M21 3l-6.5 18a0.55 .55 0 0 1 -1 0l-3.5 -7l-7 -3.5a0.55 .55 0 0 1 0 -1l18 -6.5" /></svg> Kod Gönder';
        });
    });
    
    // Kaydet butonu - ana formu submit et
    saveBtn.addEventListener('click', function() {
        const yeniKanGrubuId = document.getElementById('yeni_kan_grubu_id').value;
        const otpCode = document.getElementById('otp_code').value;
        
        if (yeniKanGrubuId != originalKanGrubu) {
            if (!otpCode || otpCode.length !== 6) {
                alert('Lütfen 6 haneli OTP kodunu giriniz!');
                return;
            }
        }
        
        // Ana forma hidden input ekle
        const mainForm = document.querySelector('form[action="{{ route("kullanici.profil.update") }}"]');
        
        // Eski hidden inputları temizle
        const oldInputs = mainForm.querySelectorAll('input[name="kan_grubu_id"], input[name="otp_code"]');
        oldInputs.forEach(input => input.remove());
        
        // Yeni inputları ekle
        const kanGrubuInput = document.createElement('input');
        kanGrubuInput.type = 'hidden';
        kanGrubuInput.name = 'kan_grubu_id';
        kanGrubuInput.value = yeniKanGrubuId;
        mainForm.appendChild(kanGrubuInput);
        
        if (yeniKanGrubuId != originalKanGrubu) {
            const otpInput = document.createElement('input');
            otpInput.type = 'hidden';
            otpInput.name = 'otp_code';
            otpInput.value = otpCode;
            mainForm.appendChild(otpInput);
        }
        
        // Modalı kapat ve formu submit et
        const modal = bootstrap.Modal.getInstance(document.getElementById('kanGrubuModal'));
        modal.hide();
        mainForm.submit();
    });
});
</script>
@endpush
