@extends('layouts.kullanici')

@section('title', 'İlanlarım')
@section('page_title', 'Verdiğim Kan İlanları')

@section('content')
<div class="row row-deck row-cards">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">İlanlarım</h3>
                <div class="card-actions">
                    <a href="{{ route('kullanici.ilan.ver') }}" class="btn btn-primary">
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><line x1="12" y1="5" x2="12" y2="19" /><line x1="5" y1="12" x2="19" y2="12" /></svg>
                        Yeni İlan Ver
                    </a>
                </div>
            </div>
            
            <!-- Filtre Formu -->
            <div class="card-body border-bottom">
                <form method="GET" action="{{ route('kullanici.ilanlarim') }}" class="row g-3">
                    <div class="col-md-5">
                        <label class="form-label">İl</label>
                        <select name="il_id" id="il_id" class="form-select">
                            <option value="">Tüm İller</option>
                            @foreach($iller as $il)
                                <option value="{{ $il->id }}" {{ request('il_id') == $il->id ? 'selected' : '' }}>
                                    {{ $il->ad }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-5">
                        <label class="form-label">İlçe</label>
                        <select name="ilce_id" id="ilce_id" class="form-select">
                            <option value="">Önce İl Seçin</option>
                            @foreach($ilceler as $ilce)
                                <option value="{{ $ilce->id }}" {{ request('ilce_id') == $ilce->id ? 'selected' : '' }}>
                                    {{ $ilce->ad }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-2 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="ti ti-filter icon"></i>
                            Filtrele
                        </button>
                    </div>
                </form>
                @if(request('il_id') || request('ilce_id'))
                    <div class="mt-2">
                        <a href="{{ route('kullanici.ilanlarim') }}" class="btn btn-link">
                            <i class="ti ti-x icon"></i>
                            Filtreyi Temizle
                        </a>
                    </div>
                @endif
            </div>

            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-vcenter card-table">
                        <thead>
                            <tr>
                                <th>Hasta Bilgisi</th>
                                <th>Kan Grubu</th>
                                <th class="text-center">Ünite</th>
                                <th>Konum</th>
                                <th>Durum</th>
                                <th>İlan Tarihi</th>
                                <th class="w-1"></th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($ilanlar as $ilan)
                                <tr>
                                    <td>
                                        <div class="d-flex py-1 align-items-center">
                                            <span class="avatar me-2 rounded" style="background-image: url(https://ui-avatars.com/api/?name={{ urlencode($ilan->hasta_ad_soyad) }}&background=random)"></span>
                                            <div class="flex-fill">
                                                <div class="font-weight-medium">{{ $ilan->hasta_ad_soyad }}</div>
                                                <div class="text-muted"><small>{{ $ilan->hastane_adi }}</small></div>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge bg-red-lt">{{ $ilan->kan_grubu }}</span>
                                    </td>
                                    <td class="text-center">
                                        <span class="badge bg-blue-lt">{{ $ilan->unite_sayisi }} Ünite</span>
                                    </td>
                                    <td>
                                        @if($ilan->hastane_il || $ilan->il_adi || $ilan->hastane_ilce || $ilan->ilce_adi)
                                            <div>{{ $ilan->hastane_il ?? $ilan->il_adi }}</div>
                                            @if($ilan->hastane_ilce || $ilan->ilce_adi)
                                                <div class="text-muted small">{{ $ilan->hastane_ilce ?? $ilan->ilce_adi }}</div>
                                            @endif
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($ilan->durum == 'aktif')
                                            <span class="badge bg-green">Aktif</span>
                                        @elseif($ilan->durum == 'pasif')
                                            <span class="badge bg-secondary">Pasif</span>
                                        @else
                                            <span class="badge bg-yellow">{{ $ilan->durum }}</span>
                                        @endif
                                    </td>
                                    <td class="text-muted">
                                        {{ \Carbon\Carbon::parse($ilan->created_at)->format('d.m.Y H:i') }}
                                    </td>
                                    <td>
                                        <div class="btn-list flex-nowrap">
                                            <a href="{{ route('kullanici.ilan.show', $ilan->id) }}" class="btn btn-sm btn-icon btn-primary" aria-label="Detay" title="Detay / Düzenle">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0" /><path d="M21 12c-2.4 4 -5.4 6 -9 6c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6" /></svg>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7">
                                        <div class="empty">
                                            <div class="empty-icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-file-off" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><line x1="3" y1="3" x2="21" y2="21" /><path d="M7 3h7l5 5v7m0 4a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-14" /></svg>
                                            </div>
                                            <p class="empty-title">Henüz ilan bulunamadı</p>
                                            <p class="empty-subtitle text-muted">
                                                Daha önce hiç kan ilanı vermemişsiniz.
                                            </p>
                                            <div class="empty-action">
                                                <a href="{{ route('kullanici.ilan.ver') }}" class="btn btn-primary">
                                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><line x1="12" y1="5" x2="12" y2="19" /><line x1="5" y1="12" x2="19" y2="12" /></svg>
                                                    İlk İlanını Hemen Ver
                                                </a>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
            @if($ilanlar->hasPages())
            <div class="card-footer d-flex align-items-center">
                <p class="m-0 text-muted">Toplam {{ $ilanlar->total() }} ilandan {{ $ilanlar->firstItem() }}-{{ $ilanlar->lastItem() }} arası gösteriliyor</p>
                <ul class="pagination m-0 ms-auto">
                    {{ $ilanlar->links() }}
                </ul>
            </div>
            @endif
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const ilSelect = document.getElementById('il_id');
    const ilceSelect = document.getElementById('ilce_id');
    
    if (ilSelect && ilceSelect) {
        ilSelect.addEventListener('change', function() {
            const ilId = this.value;
            
            // İlçe dropdown'unu temizle
            ilceSelect.innerHTML = '<option value="">Yükleniyor...</option>';
            ilceSelect.disabled = true;
            
            if (!ilId) {
                ilceSelect.innerHTML = '<option value="">Önce İl Seçin</option>';
                ilceSelect.disabled = false;
                return;
            }
            
            // İlçeleri yükle
            fetch(`/api/ilceler/${ilId}`)
                .then(response => response.json())
                .then(data => {
                    ilceSelect.innerHTML = '<option value="">Tüm İlçeler</option>';
                    data.forEach(ilce => {
                        const option = document.createElement('option');
                        option.value = ilce.id;
                        option.textContent = ilce.ad;
                        ilceSelect.appendChild(option);
                    });
                    ilceSelect.disabled = false;
                })
                .catch(error => {
                    console.error('İlçeler yüklenirken hata:', error);
                    ilceSelect.innerHTML = '<option value="">Yükleme hatası</option>';
                    ilceSelect.disabled = false;
                });
        });
    }
});
</script>
@endpush
