@extends('layouts.kullanici')

@section('title', 'Yeni Kan İlanı Ver')
@section('page_title', 'Yeni Kan İlanı Ver')

@section('content')
<div class="row row-deck row-cards">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Yeni Kan İlanı Formu</h3>
            </div>
            <div class="card-body">
                <!-- Hata Mesajları -->
                @if ($errors->any())
                    <div class="alert alert-danger alert-dismissible" role="alert">
                        <div class="d-flex">
                            <div>
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon alert-icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><circle cx="12" cy="12" r="9" /><line x1="12" y1="12" x2="12" y2="8" /><line x1="12" y1="16" x2="12.01" y2="16" /></svg>
                            </div>
                            <div>
                                <h4 class="alert-title">Hata!</h4>
                                <div class="text-muted">
                                    @foreach ($errors->all() as $error)
                                        <div>{{ $error }}</div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                        <a class="btn-close" data-bs-dismiss="alert" aria-label="close"></a>
                    </div>
                @endif

                <!-- Kullanıcı Bilgilendirmesi -->
                @if($kanGrubu == 'Bilinmiyor')
                    <div class="alert alert-warning mb-3">
                        <div class="d-flex">
                            <div>
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon alert-icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 9v2m0 4v.01" /><path d="M5 19h14a2 2 0 0 0 1.84 -2.75l-7.1 -12.25a2 2 0 0 0 -3.5 0l-7.1 12.25a2 2 0 0 0 1.75 2.75" /></svg>
                            </div>
                            <div>
                                <h4 class="alert-title">Kan Grubu Belirlenmemiş</h4>
                                <div class="text-muted">
                                    İlan verebilmek için önce <a href="{{ route('kullanici.profil') }}" class="alert-link">profilinizden</a> kan grubunuzu güncellemeniz gerekmektedir.
                                </div>
                            </div>
                        </div>
                    </div>
                @else
                    <div class="alert alert-info mb-3">
                        <div class="d-flex">
                            <div>
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon alert-icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><circle cx="12" cy="12" r="9" /><line x1="12" y1="8" x2="12.01" y2="8" /><polyline points="11 12 12 12 12 16 13 16" /></svg>
                            </div>
                            <div>
                                <h4 class="alert-title">Bilgilendirme</h4>
                                <div class="text-muted">
                                    <strong>{{ $user->ad }} {{ $user->soyad }}</strong> olarak <strong class="text-red">{{ $kanGrubu }}</strong> kan grubu için kendinize ilan veriyorsunuz.
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
                
                <form action="{{ route('kullanici.ilan.store') }}" method="POST">
                    @csrf
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label required">Hastane Adı</label>
                            <input type="text" name="hastane" class="form-control" value="{{ old('hastane') }}" placeholder="Hastane adını giriniz" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label required">Hastane Adresi</label>
                            <input type="text" name="hastane_adresi" class="form-control" value="{{ old('hastane_adresi') }}" placeholder="Hastane adresini giriniz" required>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label required">Gereken Ünite Sayısı</label>
                            <input type="number" name="unite" class="form-control" value="{{ old('unite', 1) }}" placeholder="Örn: 2" required min="1">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label required">Bağış Türü</label>
                            <select name="bagis_turu" class="form-select" required>
                                <option value="kan_unitesi" {{ old('bagis_turu', 'kan_unitesi') == 'kan_unitesi' ? 'selected' : '' }}>Kan Ünitesi</option>
                                <option value="canli_bagisci" {{ old('bagis_turu') == 'canli_bagisci' ? 'selected' : '' }}>Canlı Kan Bağışçısı</option>
                            </select>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label required">Hastane İl</label>
                            <input type="text" name="hastane_il" class="form-control" value="{{ old('hastane_il') }}" placeholder="İl adını yazınız" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label required">Hastane İlçe</label>
                            <input type="text" name="hastane_ilce" class="form-control" value="{{ old('hastane_ilce') }}" placeholder="İlçe adını yazınız" required>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label required">İletişim Telefon Numarası</label>
                            <input type="text" name="iletisim_telefon" class="form-control" value="{{ old('iletisim_telefon', Auth::guard('kullanici')->user()->telefon) }}" placeholder="5XXXXXXXXX" maxlength="10" required>
                            <small class="form-hint">Başında sıfır olmadan 10 haneli telefon numaranızı giriniz</small>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Yakın Kişi Telefon Numarası</label>
                            <input type="text" name="yakin_kisi_telefon" class="form-control" value="{{ old('yakin_kisi_telefon') }}" placeholder="5XXXXXXXXX" maxlength="10">
                            <small class="form-hint">Alternatif iletişim numarası (opsiyonel)</small>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <label class="form-label">Açıklama (Opsiyonel)</label>
                            <textarea name="aciklama" class="form-control" rows="3" placeholder="İlave bilgiler varsa buraya yazabilirsiniz...">{{ old('aciklama') }}</textarea>
                        </div>
                    </div>

                    <!-- SMS Onay Bölümü -->
                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <label class="form-label required">SMS Onay Kodu</label>
                            <div class="input-group">
                                <input type="text" name="otp_code" id="otp_code" class="form-control @error('otp_code') is-invalid @enderror" placeholder="6 haneli kod" maxlength="6" pattern="[0-9]{6}" value="{{ old('otp_code') }}" required>
                                <button type="button" class="btn btn-primary" id="sendIlanOtpBtn">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><line x1="10" y1="14" x2="21" y2="3" /><path d="M21 3l-6.5 18a0.55 .55 0 0 1 -1 0l-3.5 -7l-7 -3.5a0.55 .55 0 0 1 0 -1l18 -6.5" /></svg>
                                    Kod Gönder
                                </button>
                            </div>
                            <small class="form-hint">İlan verebilmek için telefonunuza gönderilen onay kodunu giriniz</small>
                            <div class="alert alert-info mt-2" id="ilanOtpDebugInfo" style="display:none;">
                                <div class="d-flex align-items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon alert-icon me-2" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><circle cx="12" cy="12" r="9" /><line x1="12" y1="8" x2="12.01" y2="8" /><polyline points="11 12 12 12 12 16 13 16" /></svg>
                                    <div>
                                        <strong>Test Modu:</strong> OTP Kodu: <code id="ilanOtpCodeDisplay" class="fs-4 fw-bold text-primary">------</code>
                                    </div>
                                </div>
                            </div>
                            @error('otp_code')
                                <div class="invalid-feedback d-block">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="alert alert-info">
                        <div class="d-flex">
                            <div>
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon alert-icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><circle cx="12" cy="12" r="9" /><line x1="12" y1="8" x2="12.01" y2="8" /><polyline points="11 12 12 12 12 16 13 16" /></svg>
                            </div>
                            <div>
                                <h4 class="alert-title">Bilgilendirme</h4>
                                <div class="text-muted">İlanınız, SMS sistemine kayıtlı olan ve aradığınız kan grubuna uygun olan tüm kullanıcılara anında SMS olarak gönderilecektir.</div>
                            </div>
                        </div>
                    </div>

                    <div class="form-footer">
                        <button type="submit" class="btn btn-primary" {{ $kanGrubu == 'Bilinmiyor' ? 'disabled' : '' }}>
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><line x1="12" y1="5" x2="12" y2="19" /><line x1="5" y1="12" x2="19" y2="12" /></svg>
                            İlanı Yayınla
                        </button>
                        @if($kanGrubu == 'Bilinmiyor')
                            <a href="{{ route('kullanici.profil') }}" class="btn btn-warning">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><circle cx="12" cy="12" r="9" /><line x1="12" y1="8" x2="12.01" y2="8" /><polyline points="11 12 12 12 12 16 13 16" /></svg>
                                Kan Grubumu Güncelle
                            </a>
                        @endif
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const sendOtpBtn = document.getElementById('sendIlanOtpBtn');

    // OTP Gönderme İşlemi
    if (sendOtpBtn) {
        sendOtpBtn.addEventListener('click', function() {
            console.log('OTP gönder butonuna tıklandı');
            const button = this;
            button.disabled = true;
            
            console.log('Fetch isteği gönderiliyor...');
            fetch('/ilan-ver/send-otp', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => {
                console.log('Response alındı:', response);
                return response.json();
            })
            .then(data => {
                console.log('Data alındı:', data);
                console.log('OTP Code:', data.otp_code);
                
                if (data.success) {
                    // Test modu için OTP kodunu göster
                    if (data.otp_code) {
                        console.log('OTP kodu bulundu, gösteriliyor...');
                        const debugInfo = document.getElementById('ilanOtpDebugInfo');
                        const codeDisplay = document.getElementById('ilanOtpCodeDisplay');
                        console.log('Debug Info Element:', debugInfo);
                        console.log('Code Display Element:', codeDisplay);
                        
                        if (debugInfo && codeDisplay) {
                            debugInfo.style.display = 'block';
                            codeDisplay.textContent = data.otp_code;
                            console.log('OTP kodu ekranda gösterildi:', data.otp_code);
                        } else {
                            console.error('Debug bilgi elementleri bulunamadı!');
                        }
                    } else {
                        console.warn('Response\'ta otp_code bulunamadı');
                    }
                    
                    // 60 saniye geri sayım başlat
                    let countdown = 60;
                    const originalText = button.innerHTML;
                    
                    const countdownInterval = setInterval(function() {
                        button.innerHTML = `${countdown} saniye`;
                        countdown--;
                        
                        if (countdown < 0) {
                            clearInterval(countdownInterval);
                            button.innerHTML = originalText;
                            button.disabled = false;
                        }
                    }, 1000);
                } else {
                    alert(data.message || 'Kod gönderilirken bir hata oluştu');
                    button.disabled = false;
                }
            })
            .catch(error => {
                console.error('Hata:', error);
                alert('Kod gönderilirken bir hata oluştu');
                button.disabled = false;
            });
        });
    }
});
</script>
@endpush

@endsection
