@extends('layouts.kullanici')

@section('title', 'İlan Detayı')
@section('page_title', 'İlan Detayı')

@section('content')
@if(session('success'))
<div class="alert alert-success alert-dismissible" role="alert">
    <div class="d-flex">
        <div>
            <svg xmlns="http://www.w3.org/2000/svg" class="icon alert-icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M5 12l5 5l10 -10" /></svg>
        </div>
        <div>{{ session('success') }}</div>
    </div>
    <a class="btn-close" data-bs-dismiss="alert" aria-label="close"></a>
</div>
@endif

@if(session('error'))
<div class="alert alert-danger alert-dismissible" role="alert">
    <div class="d-flex">
        <div>
            <svg xmlns="http://www.w3.org/2000/svg" class="icon alert-icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><circle cx="12" cy="12" r="9" /><line x1="12" y1="8" x2="12" y2="12" /><line x1="12" y1="16" x2="12.01" y2="16" /></svg>
        </div>
        <div>{{ session('error') }}</div>
    </div>
    <a class="btn-close" data-bs-dismiss="alert" aria-label="close"></a>
</div>
@endif

<div class="row row-cards">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Hasta Bilgileri</h3>
            </div>
            <div class="card-body">
                <div class="datagrid">
                    <div class="datagrid-item">
                        <div class="datagrid-title">Ad Soyad</div>
                        <div class="datagrid-content">{{ $ilan->hasta_ad_soyad }}</div>
                    </div>
                    <div class="datagrid-item">
                        <div class="datagrid-title">Kan Grubu</div>
                        <div class="datagrid-content">
                            <span class="badge bg-red-lt">{{ $ilan->kan_grubu ?? 'Belirtilmemiş' }}</span>
                        </div>
                    </div>
                    <div class="datagrid-item">
                        <div class="datagrid-title">Ünite Sayısı</div>
                        <div class="datagrid-content">{{ $ilan->unite_sayisi }} Ünite</div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h3 class="card-title">İletişim Bilgileri</h3>
            </div>
            <div class="card-body">
                <div class="datagrid">
                    <div class="datagrid-item">
                        <div class="datagrid-title">Telefon</div>
                        <div class="datagrid-content">{{ $ilan->irtibat_telefonu }}</div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h3 class="card-title">Hastane Bilgileri</h3>
            </div>
            <div class="card-body">
                <div class="datagrid">
                    <div class="datagrid-item">
                        <div class="datagrid-title">Hastane</div>
                        <div class="datagrid-content">{{ $ilan->hastane_adi ?? 'Belirtilmemiş' }}</div>
                    </div>
                    <div class="datagrid-item">
                        <div class="datagrid-title">Hastane Adresi</div>
                        <div class="datagrid-content">{{ $ilan->hastane_adresi ?? 'Belirtilmemiş' }}</div>
                    </div>
                    <div class="datagrid-item">
                        <div class="datagrid-title">Konum</div>
                        <div class="datagrid-content">{{ $ilan->hastane_ilce ?? ($ilan->ilce_adi ?? '') }} / {{ $ilan->hastane_il ?? ($ilan->il_adi ?? '') }}</div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h3 class="card-title">İlan Durumu</h3>
            </div>
            <div class="card-body">
                <div class="datagrid">
                    <div class="datagrid-item">
                        <div class="datagrid-title">Durum</div>
                        <div class="datagrid-content">
                            @if($ilan->durum == 'aktif')
                                <span class="badge bg-success-lt">Aktif</span>
                            @elseif($ilan->durum == 'pasif')
                                <span class="badge bg-secondary-lt">Pasif</span>
                            @else
                                <span class="badge bg-warning-lt">{{ $ilan->durum }}</span>
                            @endif
                        </div>
                    </div>
                    <div class="datagrid-item">
                        <div class="datagrid-title">İlan Tarihi</div>
                        <div class="datagrid-content">{{ \Carbon\Carbon::parse($ilan->created_at)->format('d.m.Y H:i') }}</div>
                    </div>
                    <div class="datagrid-item">
                        <div class="datagrid-title">Son Güncelleme</div>
                        <div class="datagrid-content">{{ \Carbon\Carbon::parse($ilan->updated_at)->format('d.m.Y H:i') }}</div>
                    </div>
                </div>
            </div>
        </div>

        @if($ilan->notlar)
        <div class="card mt-3">
            <div class="card-header">
                <h3 class="card-title">Açıklama/Notlar</h3>
            </div>
            <div class="card-body">
                <p class="text-secondary">{{ $ilan->notlar }}</p>
            </div>
        </div>
        @endif
    </div>

    <div class="col-lg-4">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Paylaşım Linki</h3>
            </div>
            <div class="card-body">
                @if($ilan->link_token && $ilan->link_gecerlilik_tarihi && now()->lt($ilan->link_gecerlilik_tarihi))
                    <p class="text-secondary mb-3">SMS için kısa link (72 saat geçerli):</p>
                    <div class="mb-3">
                        <input type="text" class="form-control" id="ilanLink" value="{{ route('ilan.detay', $ilan->link_token) }}" readonly>
                    </div>
                    <div class="mb-3">
                        <small class="text-muted">
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-clock icon-inline" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><circle cx="12" cy="12" r="9" /><polyline points="12 7 12 12 15 15" /></svg>
                            Geçerlilik: {{ \Carbon\Carbon::parse($ilan->link_gecerlilik_tarihi)->format('d.m.Y H:i') }}
                        </small>
                    </div>
                    <button class="btn btn-primary w-100 mb-2" onclick="copyToClipboard()">
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><rect x="8" y="8" width="12" height="12" rx="2" /><path d="M16 8v-2a2 2 0 0 0 -2 -2h-8a2 2 0 0 0 -2 2v8a2 2 0 0 0 2 2h2" /></svg>
                        Linki Kopyala
                    </button>
                    <a href="https://wa.me/?text={{ urlencode('Acil Kan İhtiyacı: ' . $ilan->kan_grubu . ' - ' . route('ilan.detay', $ilan->link_token)) }}" target="_blank" class="btn btn-success w-100 mb-2">
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-brand-whatsapp" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M3 21l1.65 -3.8a9 9 0 1 1 3.4 2.9l-5.05 .9" /><path d="M9 10a.5 .5 0 0 0 1 0v-1a.5 .5 0 0 0 -1 0v1a5 5 0 0 0 5 5h1a.5 .5 0 0 0 0 -1h-1a.5 .5 0 0 0 0 1" /></svg>
                        WhatsApp ile Paylaş
                    </a>
                    <a href="{{ route('ilan.detay', $ilan->link_token) }}" target="_blank" class="btn btn-outline-primary w-100">
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0" /><path d="M21 12c-2.4 4 -5.4 6 -9 6c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6" /></svg>
                        Linki Aç
                    </a>
                @else
                    <div class="alert alert-warning mb-0" role="alert">
                        <div class="d-flex">
                            <div>
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon alert-icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><circle cx="12" cy="12" r="9" /><line x1="12" y1="8" x2="12" y2="12" /><line x1="12" y1="16" x2="12.01" y2="16" /></svg>
                            </div>
                            <div>
                                <h4 class="alert-title">Paylaşım Linki Mevcut Değil</h4>
                                <div class="text-secondary">Link oluşturulmamış veya süresi dolmuş.</div>
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h3 class="card-title">İşlemler</h3>
            </div>
            <div class="card-body">
                <a href="{{ route('kullanici.ilanlarim') }}" class="btn btn-outline-secondary w-100 mb-2">
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><line x1="5" y1="12" x2="19" y2="12" /><line x1="5" y1="12" x2="11" y2="18" /><line x1="5" y1="12" x2="11" y2="6" /></svg>
                    Listeye Dön
                </a>
                <a href="{{ route('kullanici.ilan.edit', $ilan->id) }}" class="btn btn-primary w-100 mb-2">
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M7 7h-1a2 2 0 0 0 -2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2 -2v-1" /><path d="M20.385 6.585a2.1 2.1 0 0 0 -2.97 -2.97l-8.415 8.385v3h3l8.385 -8.415z" /><path d="M16 5l3 3" /></svg>
                    İlanı Düzenle
                </a>
                @if($ilan->durum == 'aktif')
                <button class="btn btn-warning w-100" data-bs-toggle="modal" data-bs-target="#durumGuncelleModal">
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M7 7h-1a2 2 0 0 0 -2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2 -2v-1" /><path d="M20.385 6.585a2.1 2.1 0 0 0 -2.97 -2.97l-8.415 8.385v3h3l8.385 -8.415z" /><path d="M16 5l3 3" /></svg>
                    Durumu Güncelle
                </button>
                @endif
            </div>
        </div>
    </div>
</div>

<!-- Durum Güncelleme Modal -->
<div class="modal modal-blur fade" id="durumGuncelleModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">İlan Durumunu Güncelle</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="durumGuncelleForm">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Durum</label>
                        <select name="durum" id="durumSelect" class="form-select" required>
                            <option value="aktif" {{ $ilan->durum == 'aktif' ? 'selected' : '' }}>Aktif</option>
                            <option value="pasif" {{ $ilan->durum == 'pasif' ? 'selected' : '' }}>Pasif</option>
                            <option value="tamamlandi" {{ $ilan->durum == 'tamamlandi' ? 'selected' : '' }}>Tamamlandı</option>
                            <option value="iptal" {{ $ilan->durum == 'iptal' ? 'selected' : '' }}>İptal</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-link link-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="submit" class="btn btn-primary">Güncelle</button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
function copyToClipboard() {
    const copyText = document.getElementById("ilanLink");
    copyText.select();
    copyText.setSelectionRange(0, 99999);
    
    navigator.clipboard.writeText(copyText.value).then(function() {
        const btn = event.target.closest('button');
        const originalHtml = btn.innerHTML;
        btn.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M5 12l5 5l10 -10" /></svg>Kopyalandı!';
        btn.classList.remove('btn-primary');
        btn.classList.add('btn-success');
        
        setTimeout(function() {
            btn.innerHTML = originalHtml;
            btn.classList.remove('btn-success');
            btn.classList.add('btn-primary');
        }, 2000);
    }, function(err) {
        alert('Link kopyalanamadı: ' + err);
    });
}

// Durum güncelleme formu
document.getElementById('durumGuncelleForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const durum = document.getElementById('durumSelect').value;
    const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
    
    fetch('{{ route('kullanici.ilan.update-status', $ilan->id) }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': csrfToken
        },
        body: JSON.stringify({ durum: durum })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Modal'ı kapat
            const modal = bootstrap.Modal.getInstance(document.getElementById('durumGuncelleModal'));
            modal.hide();
            
            // Sayfayı yenile
            location.reload();
        } else {
            alert(data.message || 'Bir hata oluştu');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Durum güncellenirken bir hata oluştu');
    });
});
</script>
@endpush
@endsection
