@extends('layouts.kullanici')

@section('title', 'İlan Düzenle')
@section('page_title', 'İlan Düzenle')

@section('content')
<div class="row row-deck row-cards">
    <div class="col-12">
        <!-- Başarı/Hata Mesajları -->
        @if(session('success'))
            <div class="alert alert-success alert-dismissible" role="alert">
                <div class="d-flex">
                    <div>
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon alert-icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M5 12l5 5l10 -10" /></svg>
                    </div>
                    <div>{{ session('success') }}</div>
                </div>
                <a class="btn-close" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
        @endif

        <!-- İlan Düzenleme Formu -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">İlan Bilgilerini Düzenle</h3>
                <div class="card-actions">
                    <a href="{{ route('kullanici.ilan.show', $ilan->id) }}" class="btn btn-ghost-secondary">
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><line x1="5" y1="12" x2="19" y2="12" /><line x1="5" y1="12" x2="11" y2="18" /><line x1="5" y1="12" x2="11" y2="6" /></svg>
                        İptal
                    </a>
                </div>
            </div>
            <div class="card-body">
                <!-- Hata Mesajları -->
                @if ($errors->any())
                    <div class="alert alert-danger alert-dismissible" role="alert">
                        <div class="d-flex">
                            <div>
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon alert-icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><circle cx="12" cy="12" r="9" /><line x1="12" y1="12" x2="12" y2="8" /><line x1="12" y1="16" x2="12.01" y2="16" /></svg>
                            </div>
                            <div>
                                <h4 class="alert-title">Lütfen aşağıdaki hataları düzeltin:</h4>
                                <ul class="mb-0">
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                        <a class="btn-close" data-bs-dismiss="alert" aria-label="close"></a>
                    </div>
                @endif

                <form action="{{ route('kullanici.ilan.update', $ilan->id) }}" method="POST" id="ilanForm">
                    @csrf
                    @method('PUT')
                    
                    <div class="row">
                        <!-- Hasta Bilgileri -->
                        <div class="col-md-6 mb-3">
                            <label class="form-label required">Hasta Ad Soyad</label>
                            <input type="text" class="form-control @error('hasta_ad_soyad') is-invalid @enderror" 
                                   name="hasta_ad_soyad" value="{{ old('hasta_ad_soyad', $ilan->hasta_ad_soyad) }}" required>
                            @error('hasta_ad_soyad')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6 mb-3">
                            <label class="form-label required">Kan Grubu</label>
                            <select class="form-select @error('kan_grubu_id') is-invalid @enderror" name="kan_grubu_id" required>
                                <option value="">Seçiniz</option>
                                @foreach($kanGruplari as $kg)
                                    <option value="{{ $kg->id }}" {{ old('kan_grubu_id', $ilan->kan_grubu_id) == $kg->id ? 'selected' : '' }}>
                                        {{ $kg->ad }}
                                    </option>
                                @endforeach
                            </select>
                            @error('kan_grubu_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Hastane Bilgileri -->
                        <div class="col-md-6 mb-3">
                            <label class="form-label required">Hastane Adı</label>
                            <input type="text" class="form-control @error('hastane') is-invalid @enderror" 
                                   name="hastane" value="{{ old('hastane', $ilan->hastane_adi) }}" required>
                            @error('hastane')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6 mb-3">
                            <label class="form-label required">Hastane Adresi</label>
                            <input type="text" class="form-control @error('hastane_adresi') is-invalid @enderror" 
                                   name="hastane_adresi" value="{{ old('hastane_adresi', $ilan->hastane_adresi) }}" required>
                            @error('hastane_adresi')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Ünite ve Bağış Türü -->
                        <div class="col-md-6 mb-3">
                            <label class="form-label required">Ünite Sayısı</label>
                            <input type="number" class="form-control @error('unite') is-invalid @enderror" 
                                   name="unite" min="1" value="{{ old('unite', $ilan->unite_sayisi) }}" required>
                            @error('unite')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6 mb-3">
                            <label class="form-label required">Bağış Türü</label>
                            <select class="form-select @error('bagis_turu') is-invalid @enderror" name="bagis_turu" required>
                                <option value="kan_unitesi" {{ old('bagis_turu', $ilan->bagis_turu) == 'kan_unitesi' ? 'selected' : '' }}>
                                    Kan Ünitesi
                                </option>
                                <option value="canli_bagisci" {{ old('bagis_turu', $ilan->bagis_turu) == 'canli_bagisci' ? 'selected' : '' }}>
                                    Canlı Bağışçı
                                </option>
                            </select>
                            @error('bagis_turu')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Konum Bilgileri -->
                        <div class="col-md-6 mb-3">
                            <label class="form-label required">İl</label>
                            <select class="form-select @error('il_id') is-invalid @enderror" name="il_id" id="il_id" required>
                                <option value="">Seçiniz</option>
                                @foreach($iller as $il)
                                    <option value="{{ $il->id }}" {{ old('il_id', $ilan->il_id) == $il->id ? 'selected' : '' }}>
                                        {{ $il->ad }}
                                    </option>
                                @endforeach
                            </select>
                            @error('il_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6 mb-3">
                            <label class="form-label">İlçe</label>
                            <select class="form-select @error('ilce_id') is-invalid @enderror" name="ilce_id" id="ilce_id">
                                <option value="">Seçiniz</option>
                                @foreach($ilceler as $ilce)
                                    <option value="{{ $ilce->id }}" {{ old('ilce_id', $ilan->ilce_id) == $ilce->id ? 'selected' : '' }}>
                                        {{ $ilce->ad }}
                                    </option>
                                @endforeach
                            </select>
                            @error('ilce_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- İletişim -->
                        <div class="col-md-6 mb-3">
                            <label class="form-label required">İrtibat Telefonu</label>
                            <input type="text" class="form-control @error('irtibat_telefonu') is-invalid @enderror" 
                                   name="irtibat_telefonu" value="{{ old('irtibat_telefonu', $ilan->irtibat_telefonu) }}" required>
                            @error('irtibat_telefonu')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Yakın Kişi Telefonu -->
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Yakın Kişi Telefonu</label>
                            <input type="text" class="form-control @error('yakin_kisi_telefon') is-invalid @enderror" 
                                   name="yakin_kisi_telefon" value="{{ old('yakin_kisi_telefon', $ilan->yakin_kisi_telefon) }}">
                            <small class="form-hint">Alternatif iletişim numarası (opsiyonel)</small>
                            @error('yakin_kisi_telefon')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Açıklama -->
                        <div class="col-12 mb-3">
                            <label class="form-label">Notlar / Açıklama</label>
                            <textarea class="form-control @error('aciklama') is-invalid @enderror" 
                                      name="aciklama" rows="4">{{ old('aciklama', $ilan->notlar) }}</textarea>
                            <small class="form-hint">İlanınızla ilgili ek bilgiler varsa buraya yazabilirsiniz.</small>
                            @error('aciklama')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="d-flex justify-content-end gap-2">
                        <a href="{{ route('kullanici.ilan.show', $ilan->id) }}" class="btn btn-secondary">
                            İptal
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M5 12l5 5l10 -10" /></svg>
                            Değişiklikleri Kaydet
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- İlan Durumu Yönetimi -->
        <div class="card mt-3">
            <div class="card-header">
                <h3 class="card-title">İlan Durumu</h3>
            </div>
            <div class="card-body">
                <div class="row align-items-center">
                    <div class="col">
                        <p class="text-muted mb-2">İlanınızı aktif veya pasif yapabilirsiniz. Pasif ilanlar başka kullanıcılar tarafından görüntülenemez.</p>
                        <div class="d-flex align-items-center gap-3">
                            <span class="badge badge-lg" id="durumBadge" 
                                  style="background-color: {{ $ilan->durum == 'aktif' ? '#2fb344' : '#6c757d' }}; font-size: 0.875rem; padding: 0.5rem 1rem;">
                                {{ $ilan->durum == 'aktif' ? 'AKTİF' : 'PASİF' }}
                            </span>
                            <div class="form-check form-switch form-switch-lg">
                                <input class="form-check-input" type="checkbox" id="durumSwitch" 
                                       {{ $ilan->durum == 'aktif' ? 'checked' : '' }}>
                                <label class="form-check-label" for="durumSwitch">
                                    <span id="durumLabel">{{ $ilan->durum == 'aktif' ? 'İlan Aktif' : 'İlan Pasif' }}</span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // İl değiştiğinde ilçeleri yükle
    const ilSelect = document.getElementById('il_id');
    const ilceSelect = document.getElementById('ilce_id');
    
    if (ilSelect && ilceSelect) {
        ilSelect.addEventListener('change', function() {
            const ilId = this.value;
            
            ilceSelect.innerHTML = '<option value="">Yükleniyor...</option>';
            ilceSelect.disabled = true;
            
            if (!ilId) {
                ilceSelect.innerHTML = '<option value="">Önce İl Seçin</option>';
                ilceSelect.disabled = false;
                return;
            }
            
            fetch(`/api/ilceler/${ilId}`)
                .then(response => response.json())
                .then(data => {
                    ilceSelect.innerHTML = '<option value="">Seçiniz</option>';
                    data.forEach(ilce => {
                        const option = document.createElement('option');
                        option.value = ilce.id;
                        option.textContent = ilce.ad;
                        ilceSelect.appendChild(option);
                    });
                    ilceSelect.disabled = false;
                })
                .catch(error => {
                    console.error('İlçeler yüklenirken hata:', error);
                    ilceSelect.innerHTML = '<option value="">Yükleme hatası</option>';
                    ilceSelect.disabled = false;
                });
        });
    }
    
    // Durum değiştirme
    const durumSwitch = document.getElementById('durumSwitch');
    const durumBadge = document.getElementById('durumBadge');
    const durumLabel = document.getElementById('durumLabel');
    
    if (durumSwitch) {
        durumSwitch.addEventListener('change', function() {
            const yeniDurum = this.checked ? 'aktif' : 'pasif';
            
            // Onay iste
            const mesaj = yeniDurum === 'aktif' 
                ? 'İlanı aktif hale getirmek istediğinizden emin misiniz?' 
                : 'İlanı pasif hale getirmek istediğinizden emin misiniz? Pasif ilanlar başka kullanıcılar tarafından görüntülenemez.';
            
            if (!confirm(mesaj)) {
                this.checked = !this.checked;
                return;
            }
            
            // AJAX ile durum güncelle
            fetch(`{{ route('kullanici.ilan.update-status', $ilan->id) }}`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({ durum: yeniDurum })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Badge ve label güncelle
                    durumBadge.textContent = yeniDurum.toUpperCase();
                    durumBadge.style.backgroundColor = yeniDurum === 'aktif' ? '#2fb344' : '#6c757d';
                    durumLabel.textContent = yeniDurum === 'aktif' ? 'İlan Aktif' : 'İlan Pasif';
                    
                    // Başarı mesajı göster
                    const alertHtml = `
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <div class="d-flex">
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon alert-icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M5 12l5 5l10 -10" /></svg>
                                </div>
                                <div>${data.message}</div>
                            </div>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    `;
                    const container = document.querySelector('.row-deck');
                    container.insertAdjacentHTML('afterbegin', alertHtml);
                    
                    // 3 saniye sonra mesajı kaldır
                    setTimeout(() => {
                        const alert = container.querySelector('.alert');
                        if (alert) alert.remove();
                    }, 3000);
                } else {
                    alert('Durum güncellenirken bir hata oluştu: ' + (data.message || 'Bilinmeyen hata'));
                    this.checked = !this.checked;
                }
            })
            .catch(error => {
                console.error('Hata:', error);
                alert('Durum güncellenirken bir hata oluştu.');
                this.checked = !this.checked;
            });
        });
    }
});
</script>
@endpush
