@extends('layouts.kullanici')

@section('content')
<div class="container-xl">
    <div class="page-header d-print-none">
        <div class="row g-2 align-items-center">
            <div class="col">
                <h2 class="page-title">
                    İlan Detayı
                </h2>
            </div>
        </div>
    </div>
</div>

<div class="page-body">
    <div class="container-xl">
        <div class="row row-cards">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-status-top bg-red"></div>
                    <div class="card-body">
                        <h3 class="card-title">{{ $ilan->hasta_ad_soyad }}</h3>
                        
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label text-muted">Kan Grubu</label>
                                    <div class="h2 mb-0">
                                        <span class="badge bg-red-lt" style="font-size: 1.5rem;">
                                            {{ $ilan->kan_grubu_adi ?? 'Belirtilmemiş' }}
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label text-muted">Ünite Sayısı</label>
                                    <div class="h2 mb-0">{{ $ilan->unite_sayisi }} Ünite</div>
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label text-muted">Bağış Türü</label>
                                    <div>
                                        @if($ilan->bagis_turu == 'kan_unitesi')
                                            <span class="badge bg-blue">Kan Ünitesi</span>
                                        @else
                                            <span class="badge bg-purple">Canlı Bağışçı</span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label text-muted">İhtiyaç Tarihi</label>
                                    <div class="text-muted">
                                        @if($ilan->tarih)
                                            {{ \Carbon\Carbon::parse($ilan->tarih)->format('d.m.Y') }}
                                            @if($ilan->saat)
                                                <span class="badge bg-gray-lt ms-1">{{ $ilan->saat }}</span>
                                            @endif
                                        @else
                                            <span class="text-muted">Belirtilmemiş</span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>

                        @if($ilan->notlar)
                        <div class="mb-3">
                            <label class="form-label text-muted">Açıklama</label>
                            <div class="text-muted">{{ $ilan->notlar }}</div>
                        </div>
                        @endif

                        <div class="mb-3">
                            <label class="form-label text-muted">İlan Tarihi</label>
                            <div class="text-muted">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-calendar me-1" width="20" height="20" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <path d="M4 7a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12z"></path>
                                    <path d="M16 3v4"></path>
                                    <path d="M8 3v4"></path>
                                    <path d="M4 11h16"></path>
                                </svg>
                                {{ \Carbon\Carbon::parse($ilan->created_at)->format('d.m.Y H:i') }}
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label text-muted">Durum</label>
                            <div>
                                @if($ilan->durum == 'aktif')
                                    <span class="badge bg-success">Aktif</span>
                                @elseif($ilan->durum == 'tamamlandi')
                                    <span class="badge bg-primary">Tamamlandı</span>
                                @elseif($ilan->durum == 'iptal')
                                    <span class="badge bg-danger">İptal</span>
                                @elseif($ilan->durum == 'pasif')
                                    <span class="badge bg-secondary">Pasif</span>
                                @else
                                    <span class="badge bg-warning">Süresi Doldu</span>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Hastane Bilgileri</h3>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label text-muted">Hastane</label>
                            <div class="text-muted">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-building-hospital me-1" width="20" height="20" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <path d="M3 21l18 0"></path>
                                    <path d="M9 8l1 0"></path>
                                    <path d="M9 12l1 0"></path>
                                    <path d="M9 16l1 0"></path>
                                    <path d="M14 8l1 0"></path>
                                    <path d="M14 12l1 0"></path>
                                    <path d="M14 16l1 0"></path>
                                    <path d="M5 21v-16a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v16"></path>
                                </svg>
                                {{ $ilan->hastane_adi ?? 'Belirtilmemiş' }}
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label text-muted">Hastane Adresi</label>
                            <div class="text-muted">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-map-pin me-1" width="20" height="20" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <path d="M9 11a3 3 0 1 0 6 0a3 3 0 0 0 -6 0"></path>
                                    <path d="M17.657 16.657l-4.243 4.243a2 2 0 0 1 -2.827 0l-4.244 -4.243a8 8 0 1 1 11.314 0z"></path>
                                </svg>
                                {{ $ilan->hastane_adresi ?? 'Belirtilmemiş' }}
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label text-muted">Konum</label>
                            <div class="text-muted">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-map-pin me-1" width="20" height="20" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <path d="M9 11a3 3 0 1 0 6 0a3 3 0 0 0 -6 0"></path>
                                    <path d="M17.657 16.657l-4.243 4.243a2 2 0 0 1 -2.827 0l-4.244 -4.243a8 8 0 1 1 11.314 0z"></path>
                                </svg>
                                {{ $ilan->hastane_ilce ?? ($ilan->ilce_adi ?? '') }} / {{ $ilan->hastane_il ?? ($ilan->il_adi ?? '') }}
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-header">
                        <h3 class="card-title">İletişim Bilgileri</h3>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label text-muted">İrtibat Kişisi</label>
                            <div class="text-muted">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-user me-1" width="20" height="20" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <path d="M8 7a4 4 0 1 0 8 0a4 4 0 0 0 -8 0"></path>
                                    <path d="M6 21v-2a4 4 0 0 1 4 -4h4a4 4 0 0 1 4 4v2"></path>
                                </svg>
                                {{ $ilan->kullanici_adi ?? 'Belirtilmemiş' }}
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label text-muted">Telefon</label>
                            <div>
                                <a href="tel:{{ $ilan->irtibat_telefonu }}" class="btn btn-success w-100">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-phone me-1" width="20" height="20" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                        <path d="M5 4h4l2 5l-2.5 1.5a11 11 0 0 0 5 5l1.5 -2.5l5 2v4a2 2 0 0 1 -2 2a16 16 0 0 1 -15 -15a2 2 0 0 1 2 -2"></path>
                                    </svg>
                                    {{ $ilan->irtibat_telefonu }}
                                </a>
                            </div>
                        </div>

                        @if($ilan->yakin_kisi_telefon)
                        <div class="mb-3">
                            <label class="form-label text-muted">Yakın Kişi Telefonu</label>
                            <div>
                                <a href="tel:{{ $ilan->yakin_kisi_telefon }}" class="btn btn-outline-success w-100">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-phone me-1" width="20" height="20" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                        <path d="M5 4h4l2 5l-2.5 1.5a11 11 0 0 0 5 5l1.5 -2.5l5 2v4a2 2 0 0 1 -2 2a16 16 0 0 1 -15 -15a2 2 0 0 1 2 -2"></path>
                                    </svg>
                                    {{ $ilan->yakin_kisi_telefon }}
                                </a>
                            </div>
                        </div>
                        @endif

                        <hr>

                        <div class="mb-3">
                            <label class="form-label text-muted">İlan Linki (Kalıcı)</label>
                            <div class="input-group">
                                <input type="text" class="form-control" id="ilanLink" value="{{ $ilanLink }}" readonly>
                                <button class="btn btn-primary" type="button" id="copyLinkBtn">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="20" height="20" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                        <path d="M8 8m0 2a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v8a2 2 0 0 1 -2 2h-8a2 2 0 0 1 -2 -2z"></path>
                                        <path d="M16 8v-2a2 2 0 0 0 -2 -2h-8a2 2 0 0 0 -2 2v8a2 2 0 0 0 2 2h2"></path>
                                    </svg>
                                    Kopyala
                                </button>
                            </div>
                            <small class="form-hint">Bu linki paylaşarak ilan detayını başkalarıyla paylaşabilirsiniz.</small>
                        </div>

                        @if($smsLink)
                        <div class="mb-0">
                            <label class="form-label text-muted">SMS Linki (72 Saat Geçerli)</label>
                            <div class="input-group">
                                <input type="text" class="form-control" id="smsLink" value="{{ $smsLink }}" readonly>
                                <button class="btn btn-success" type="button" id="copySmsLinkBtn">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="20" height="20" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                        <path d="M8 8m0 2a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v8a2 2 0 0 1 -2 2h-8a2 2 0 0 1 -2 -2z"></path>
                                        <path d="M16 8v-2a2 2 0 0 0 -2 -2h-8a2 2 0 0 0 -2 2v8a2 2 0 0 0 2 2h2"></path>
                                    </svg>
                                    Kopyala
                                </button>
                            </div>
                            <small class="form-hint text-warning">Bu link SMS ile gönderilen kısa linkdir ve 72 saat geçerlidir.</small>
                        </div>
                        @endif
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-header">
                        <h3 class="card-title">SMS Bilgileri</h3>
                    </div>
                    <div class="card-body">
                        <div class="text-center">
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-message text-blue mb-2" width="48" height="48" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                <path d="M8 9h8"></path>
                                <path d="M8 13h6"></path>
                                <path d="M18 4a3 3 0 0 1 3 3v8a3 3 0 0 1 -3 3h-5l-5 3v-3h-2a3 3 0 0 1 -3 -3v-8a3 3 0 0 1 3 -3h12z"></path>
                            </svg>
                            <h2 class="mb-1">{{ $smsSayisi }}</h2>
                            <p class="text-muted mb-0">kişiye SMS gönderildi</p>
                        </div>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-body">
                        <div class="text-center">
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-alert-circle text-yellow mb-2" width="48" height="48" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                <path d="M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0"></path>
                                <path d="M12 8v4"></path>
                                <path d="M12 16h.01"></path>
                            </svg>
                            <h3>Önemli Uyarı</h3>
                            <p class="text-muted">Kan bağışı yapmadan önce sağlık durumunuzdan emin olun ve bağış yapacağınız hastaneyle irtibata geçin.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const copyBtn = document.getElementById('copyLinkBtn');
    const linkInput = document.getElementById('ilanLink');
    const copySmsBtn = document.getElementById('copySmsLinkBtn');
    const smsLinkInput = document.getElementById('smsLink');
    
    if (copyBtn && linkInput) {
        copyBtn.addEventListener('click', function() {
            linkInput.select();
            linkInput.setSelectionRange(0, 99999);
            
            navigator.clipboard.writeText(linkInput.value).then(function() {
                const originalHtml = copyBtn.innerHTML;
                copyBtn.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" class="icon text-green" width="20" height="20" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"></path><path d="M5 12l5 5l10 -10"></path></svg> Kopyalandı';
                
                setTimeout(function() {
                    copyBtn.innerHTML = originalHtml;
                }, 2000);
            }, function(err) {
                alert('Link kopyalanamadı: ' + err);
            });
        });
    }
    
    if (copySmsBtn && smsLinkInput) {
        copySmsBtn.addEventListener('click', function() {
            smsLinkInput.select();
            smsLinkInput.setSelectionRange(0, 99999);
            
            navigator.clipboard.writeText(smsLinkInput.value).then(function() {
                const originalHtml = copySmsBtn.innerHTML;
                copySmsBtn.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" class="icon text-green" width="20" height="20" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"></path><path d="M5 12l5 5l10 -10"></path></svg> Kopyalandı';
                
                setTimeout(function() {
                    copySmsBtn.innerHTML = originalHtml;
                }, 2000);
            }, function(err) {
                alert('SMS linki kopyalanamadı: ' + err);
            });
        });
    }
});
</script>
@endpush
@endsection
