@extends('layouts.kullanici')

@section('title', 'Anasayfa')
@section('subtitle', 'Aktif kan ilanlarını görüntüleyin')

@section('content')
<!-- İstatistik Kartları -->
<div class="row row-deck row-cards mb-3">
  <div class="col-sm-6 col-lg-3">
    <div class="card">
      <div class="card-body">
        <div class="d-flex align-items-center">
          <div class="subheader">Kan Grubum</div>
        </div>
        <div class="h1 mb-3">{{ $stats['ayni_kan_grubu'] }}</div>
        <div class="d-flex mb-2">
          <div>Aynı kan grubunda</div>
        </div>
        <div class="progress progress-sm">
          <div class="progress-bar bg-red" style="width: {{ $stats['toplam_kullanici'] > 0 ? ($stats['ayni_kan_grubu'] / $stats['toplam_kullanici'] * 100) : 0 }}%" role="progressbar" aria-valuenow="{{ $stats['ayni_kan_grubu'] }}" aria-valuemin="0" aria-valuemax="{{ $stats['toplam_kullanici'] }}">
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-lg-3">
    <div class="card">
      <div class="card-body">
        <div class="d-flex align-items-center">
          <div class="subheader">Toplam Kullanıcı</div>
        </div>
        <div class="h1 mb-3">{{ $stats['toplam_kullanici'] }}</div>
        <div class="d-flex mb-2">
          <div>Sistemdeki tüm kullanıcılar</div>
        </div>
        <div class="progress progress-sm">
          <div class="progress-bar bg-primary" style="width: 100%" role="progressbar"></div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-lg-3">
    <div class="card">
      <div class="card-body">
        <div class="d-flex align-items-center">
          <div class="subheader">Bugün</div>
        </div>
        <div class="h1 mb-3">{{ $stats['bugun_ilanlar'] }}</div>
        <div class="d-flex mb-2">
          <div>Bugün verilen ilanlar</div>
        </div>
        <div class="progress progress-sm">
          <div class="progress-bar bg-green" style="width: 75%" role="progressbar"></div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-lg-3">
    <div class="card">
      <div class="card-body">
        <div class="d-flex align-items-center">
          <div class="subheader">Tamamlanan</div>
        </div>
        <div class="h1 mb-3">{{ $stats['tamamlanan_ilanlar'] }}</div>
        <div class="d-flex mb-2">
          <div>Pasif/tamamlanan ilanlar</div>
        </div>
        <div class="progress progress-sm">
          <div class="progress-bar bg-yellow" style="width: 60%" role="progressbar"></div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Aktif İlanlar Tablosu -->
<div class="row row-deck row-cards">
  <div class="col-12">
    <div class="card">
      <div class="card-header">
        <h3 class="card-title">Aktif Kan İlanları</h3>
        <div class="ms-auto">
          <a href="{{ route('kullanici.ilan.ver') }}" class="btn btn-primary">
            <i class="ti ti-plus icon"></i>
            Yeni İlan Ver
          </a>
        </div>
      </div>
      
      <!-- Filtre Formu -->
      <div class="card-body border-bottom">
        <form method="GET" action="{{ route('kullanici.dashboard') }}" class="row g-3">
          <div class="col-md-5">
            <label class="form-label">İl</label>
            <select name="il_id" id="il_id" class="form-select">
              <option value="">Tüm İller</option>
              @foreach($iller as $il)
                <option value="{{ $il->id }}" {{ request('il_id') == $il->id ? 'selected' : '' }}>
                  {{ $il->ad }}
                </option>
              @endforeach
            </select>
          </div>
          <div class="col-md-5">
            <label class="form-label">İlçe</label>
            <select name="ilce_id" id="ilce_id" class="form-select">
              <option value="">Önce İl Seçin</option>
              @foreach($ilceler as $ilce)
                <option value="{{ $ilce->id }}" {{ request('ilce_id') == $ilce->id ? 'selected' : '' }}>
                  {{ $ilce->ad }}
                </option>
              @endforeach
            </select>
          </div>
          <div class="col-md-2 d-flex align-items-end">
            <button type="submit" class="btn btn-primary w-100">
              <i class="ti ti-filter icon"></i>
              Filtrele
            </button>
          </div>
        </form>
        @if(request('il_id') || request('ilce_id'))
          <div class="mt-2">
            <a href="{{ route('kullanici.dashboard') }}" class="btn btn-link">
              <i class="ti ti-x icon"></i>
              Filtreyi Temizle
            </a>
          </div>
        @endif
      </div>

      <div class="table-responsive">
        <table class="table card-table table-vcenter text-nowrap datatable">
          <thead>
            <tr>
              <th>Hasta Ad Soyad</th>
              <th>Kan Grubu</th>
              <th>Ünite</th>
              <th>Hastane</th>
              <th>Konum</th>
              <th>İlan Tarihi</th>
              <th class="w-1"></th>
            </tr>
          </thead>
          <tbody>
            @forelse ($ilanlar as $ilan)
              <tr>
                <td>
                  <div>{{ $ilan->hasta_ad_soyad }}</div>
                  <div class="text-muted">{{ $ilan->irtibat_telefonu }}</div>
                </td>
                <td>
                  <span class="badge bg-red-lt">{{ $ilan->kan_grubu }}</span>
                </td>
                <td>
                  <span class="badge bg-green-lt">{{ $ilan->unite_sayisi }} Ünite</span>
                </td>
                <td>{{ $ilan->hastane_adi }}</td>
                <td>
                  @if($ilan->hastane_il || $ilan->il_adi || $ilan->hastane_ilce || $ilan->ilce_adi)
                    <div>{{ $ilan->hastane_il ?? $ilan->il_adi }}</div>
                    @if($ilan->hastane_ilce || $ilan->ilce_adi)
                      <div class="text-muted small">{{ $ilan->hastane_ilce ?? $ilan->ilce_adi }}</div>
                    @endif
                  @else
                    <span class="text-muted">-</span>
                  @endif
                </td>
                <td>{{ \Carbon\Carbon::parse($ilan->created_at)->format('d.m.Y H:i') }}</td>
                <td>
                  <a href="{{ route('kullanici.ilan.show', $ilan->id) }}" class="btn btn-sm btn-primary">Detay</a>
                </td>
              </tr>
            @empty
              <tr>
                <td colspan="7" class="text-center py-5">
                  <div class="empty">
                    <div class="empty-icon">
                      <i class="ti ti-droplet icon"></i>
                    </div>
                    <p class="empty-title">Aktif İlan Yok</p>
                    <p class="empty-subtitle text-muted">
                      Şu anda aktif kan ilanı bulunmamaktadır.
                    </p>
                    <div class="empty-action">
                      <a href="{{ route('kullanici.ilan.ver') }}" class="btn btn-primary">
                        <i class="ti ti-plus icon"></i>
                        İlk İlanı Sen Ver
                      </a>
                    </div>
                  </div>
                </td>
              </tr>
            @endforelse
          </tbody>
        </table>
      </div>
      @if($ilanlar->hasPages())
        <div class="card-footer d-flex align-items-center">
          {{ $ilanlar->links() }}
        </div>
      @endif
    </div>
  </div>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const ilSelect = document.getElementById('il_id');
    const ilceSelect = document.getElementById('ilce_id');
    
    if (ilSelect && ilceSelect) {
        ilSelect.addEventListener('change', function() {
            const ilId = this.value;
            
            // İlçe dropdown'unu temizle
            ilceSelect.innerHTML = '<option value="">Yükleniyor...</option>';
            ilceSelect.disabled = true;
            
            if (!ilId) {
                ilceSelect.innerHTML = '<option value="">Önce İl Seçin</option>';
                ilceSelect.disabled = false;
                return;
            }
            
            // İlçeleri yükle
            fetch(`/api/ilceler/${ilId}`)
                .then(response => response.json())
                .then(data => {
                    ilceSelect.innerHTML = '<option value="">Tüm İlçeler</option>';
                    data.forEach(ilce => {
                        const option = document.createElement('option');
                        option.value = ilce.id;
                        option.textContent = ilce.ad;
                        ilceSelect.appendChild(option);
                    });
                    ilceSelect.disabled = false;
                })
                .catch(error => {
                    console.error('İlçeler yüklenirken hata:', error);
                    ilceSelect.innerHTML = '<option value="">Yükleme hatası</option>';
                    ilceSelect.disabled = false;
                });
        });
    }
});
</script>
@endpush
