@extends('layouts.guest')

@section('title', 'Kayıt Ol')

@section('content')
<div class="container container-tight py-4">
  <div class="text-center mb-4">
    <a href="." class="navbar-brand navbar-brand-autodark">
      <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-droplet-filled text-red" width="32" height="32" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10.708 2.372a2.382 2.382 0 0 0 -.71 .686l-4.892 7.26c-1.981 3.314 -1.22 7.466 1.767 9.882c2.969 2.402 7.286 2.402 10.254 0c2.987 -2.416 3.748 -6.569 1.795 -9.836l-4.919 -7.306c-.722 -1.075 -2.192 -1.376 -3.295 -.686z" stroke-width="0" fill="currentColor" /></svg>
    </a>
    <h2 class="mt-3">{{ $kurumAdi }}</h2>
  </div>
  <form class="card card-md" action="{{ route('kayit') }}" method="POST" autocomplete="off">
    @csrf
    <div class="card-body">
      <h2 class="card-title text-center mb-4">Yeni Hesap Oluştur</h2>
      
      @if ($errors->any())
        <div class="alert alert-danger" role="alert">
          <div class="d-flex">
            <div><i class="ti ti-alert-circle icon alert-icon"></i></div>
            <div>
              <ul class="mb-0">
                @foreach ($errors->all() as $error)
                  <li>{{ $error }}</li>
                @endforeach
              </ul>
            </div>
          </div>
        </div>
      @endif

      <div class="row g-3">
        <div class="col-md-6">
          <div class="mb-3">
            <label class="form-label required">Ad</label>
            <input type="text" name="ad" class="form-control" value="{{ old('ad') }}" required>
          </div>
        </div>
        <div class="col-md-6">
          <div class="mb-3">
            <label class="form-label required">Soyad</label>
            <input type="text" name="soyad" class="form-control" value="{{ old('soyad') }}" required>
          </div>
        </div>
      </div>

      <div class="mb-3">
        <label class="form-label required">Telefon</label>
        <input type="text" name="telefon" class="form-control" maxlength="10" placeholder="5XXXXXXXXX" value="{{ old('telefon') }}" required>
      </div>

      <div class="mb-3">
        <label class="form-label required">TC Kimlik Numarası</label>
        <input type="text" name="tc_kimlik" class="form-control" maxlength="11" placeholder="XXXXXXXXXXX" value="{{ old('tc_kimlik') }}" required>
      </div>

      <div class="mb-3">
        <label class="form-label required">Email</label>
        <input type="email" name="email" class="form-control" value="{{ old('email') }}" required>
      </div>

      <div class="mb-3">
        <label class="form-label required">Doğum Tarihi</label>
        <input type="date" name="dogum_tarihi" class="form-control" value="{{ old('dogum_tarihi') }}" required>
      </div>

      <div class="mb-3">
        <label class="form-label required">Kan Grubu</label>
        <select class="form-select" name="kan_grubu_id" id="kan_grubu_id" required>
          <option value="">Seçiniz...</option>
          @foreach($kanGruplari as $kanGrubu)
            <option value="{{ $kanGrubu->id }}" {{ old('kan_grubu_id') == $kanGrubu->id ? 'selected' : '' }}>
              {{ $kanGrubu->ad }}
            </option>
          @endforeach
        </select>
      </div>

      <div class="row g-3">
        <div class="col-md-6">
          <div class="mb-3">
            <label class="form-label required">İl</label>
            <select class="form-select" name="il_id" id="il_id" required>
              <option value="">Seçiniz...</option>
              @foreach($iller as $il)
                <option value="{{ $il->id }}" {{ old('il_id') == $il->id ? 'selected' : '' }}>
                  {{ $il->ad }}
                </option>
              @endforeach
            </select>
          </div>
        </div>
        <div class="col-md-6">
          <div class="mb-3">
            <label class="form-label required">İlçe</label>
            <select class="form-select" name="ilce_id" id="ilce_id" required>
              <option value="">Önce il seçiniz...</option>
            </select>
          </div>
        </div>
      </div>

      <div class="row g-3">
        <div class="col-md-6">
          <div class="mb-3">
            <label class="form-label">Belde</label>
            <input type="text" name="belde" class="form-control" value="{{ old('belde') }}">
          </div>
        </div>
        <div class="col-md-6">
          <div class="mb-3">
            <label class="form-label required">Mahalle</label>
            <input type="text" name="mahalle" class="form-control" value="{{ old('mahalle') }}" required>
          </div>
        </div>
      </div>

      <div class="mb-3">
        <label class="form-check">
          <input type="checkbox" name="kullanim_kosullari" class="form-check-input" value="1" required>
          <span class="form-check-label"><a href="#" class="link-primary">Kullanım Koşulları</a>'nı kabul ediyorum.</span>
        </label>
      </div>

      <div class="alert alert-info mb-3">
        <svg xmlns="http://www.w3.org/2000/svg" class="icon alert-icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0" /><path d="M12 9h.01" /><path d="M11 12h1v4h1" /></svg>
        <div>
          <strong>SMS Bildirimleri:</strong> Kayıt olduğunuzda kan ilanları için SMS bildirimleri otomatik olarak aktif olacaktır. İsterseniz daha sonra profil ayarlarınızdan SMS bildirimlerini kapatabilirsiniz.
        </div>
      </div>

      <div class="form-footer">
        <button type="submit" class="btn btn-primary w-100">Kayıt Ol</button>
      </div>
    </div>
  </form>
  <div class="text-center text-muted mt-3">
    Zaten hesabın var mı? <a href="{{ route('giris') }}" tabindex="-1">Giriş Yap</a>
  </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const ilSelect = document.getElementById('il_id');
    const ilceSelect = document.getElementById('ilce_id');
    
    if (ilSelect && ilceSelect) {
        ilSelect.addEventListener('change', function() {
            const ilId = this.value;
            ilceSelect.innerHTML = '<option value="">Seçiniz...</option>';
            
            if (ilId) {
                fetch(`/api/ilceler/${ilId}`)
                    .then(response => response.json())
                    .then(data => {
                        data.forEach(ilce => {
                            const option = document.createElement('option');
                            option.value = ilce.id;
                            option.textContent = ilce.ad;
                            ilceSelect.appendChild(option);
                        });
                    })
                    .catch(error => {
                        console.error('İlçeler yüklenirken hata:', error);
                    });
            }
        });
        
        const oldIlceId = '{{ old("ilce_id") }}';
        if (oldIlceId && ilSelect.value) {
            ilSelect.dispatchEvent(new Event('change'));
            setTimeout(() => {
                ilceSelect.value = oldIlceId;
            }, 500);
        }
    }
});
</script>
@endpush
@endsection
