@extends('layouts.guest')

@section('title', 'Giriş Yap')

@section('content')
<div class="container container-tight py-4">
  <div class="text-center mb-4">
    <a href="." class="navbar-brand navbar-brand-autodark">
      <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-droplet-filled text-red" width="32" height="32" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10.708 2.372a2.382 2.382 0 0 0 -.71 .686l-4.892 7.26c-1.981 3.314 -1.22 7.466 1.767 9.882c2.969 2.402 7.286 2.402 10.254 0c2.987 -2.416 3.748 -6.569 1.795 -9.836l-4.919 -7.306c-.722 -1.075 -2.192 -1.376 -3.295 -.686z" stroke-width="0" fill="currentColor" /></svg>
    </a>
    <h2 class="mt-3">{{ $kurumAdi }}</h2>
  </div>
  <form class="card card-md" action="{{ route('giris') }}" method="POST" id="loginForm" autocomplete="off">
    @csrf
    <div class="card-body">
      <h2 class="card-title text-center mb-4">Hesabınıza Giriş Yapın</h2>
      
      @if ($errors->any())
        <div class="alert alert-danger" role="alert">
          <div class="d-flex">
            <div><i class="ti ti-alert-circle icon alert-icon"></i></div>
            <div>
              <ul class="mb-0">
                @foreach ($errors->all() as $error)
                  <li>{{ $error }}</li>
                @endforeach
              </ul>
            </div>
          </div>
        </div>
      @endif

      <div id="step1">
        <div class="mb-3">
          <label class="form-label required">Telefon</label>
          <input type="text" name="telefon" id="telefon" class="form-control" maxlength="10" placeholder="5XXXXXXXXX" required>
        </div>
        <div class="mb-3">
          <label class="form-label required">TC Kimlik Numarası</label>
          <input type="text" name="tc_kimlik" id="tc_kimlik" class="form-control" maxlength="11" placeholder="XXXXXXXXXXX" required>
        </div>
        <div class="form-footer">
          <button type="button" id="sendOtpBtn" class="btn btn-primary w-100">OTP Kodu Gönder</button>
        </div>
      </div>

      <div id="step2" style="display:none;">
        <div class="mb-3">
          <label class="form-label required">OTP Kodu</label>
          <input type="text" name="otp_code" id="otp_code" class="form-control" maxlength="6" placeholder="000000" required>
          <small class="form-hint">Telefonunuza gönderilen 6 haneli kodu girin</small>
        </div>
        <div class="form-footer">
          <button type="submit" class="btn btn-primary w-100 mb-2">Giriş Yap</button>
          <button type="button" id="backBtn" class="btn w-100">Geri Dön</button>
        </div>
      </div>
    </div>
  </form>
  <div class="text-center text-muted mt-3">
    Hesabın yok mu? <a href="{{ route('kayit') }}" tabindex="-1">Kayıt Ol</a>
  </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const sendOtpBtn = document.getElementById('sendOtpBtn');
    const backBtn = document.getElementById('backBtn');
    const step1 = document.getElementById('step1');
    const step2 = document.getElementById('step2');
    const telefon = document.getElementById('telefon');
    const tcKimlik = document.getElementById('tc_kimlik');

    sendOtpBtn.addEventListener('click', function() {
        if (!telefon.value || !tcKimlik.value) {
            alert('Lütfen telefon ve TC kimlik numaranızı girin');
            return;
        }

        sendOtpBtn.disabled = true;
        sendOtpBtn.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>Gönderiliyor...';

        fetch('{{ route('send.otp') }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify({
                telefon: telefon.value,
                tc_kimlik: tcKimlik.value
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                step1.style.display = 'none';
                step2.style.display = 'block';
                document.getElementById('otp_code').focus();
            } else {
                alert(data.error || 'Bir hata oluştu');
                sendOtpBtn.disabled = false;
                sendOtpBtn.textContent = 'OTP Kodu Gönder';
            }
        })
        .catch(error => {
            alert('Bir hata oluştu: ' + error);
            sendOtpBtn.disabled = false;
            sendOtpBtn.textContent = 'OTP Kodu Gönder';
        });
    });

    backBtn.addEventListener('click', function() {
        step2.style.display = 'none';
        step1.style.display = 'block';
        document.getElementById('otp_code').value = '';
        sendOtpBtn.disabled = false;
        sendOtpBtn.textContent = 'OTP Kodu Gönder';
    });
});
</script>
@endpush
@endsection
