@extends('layouts.admin')

@section('title', 'SMS Şablonları')

@section('content')
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <h2 class="page-title">SMS Şablonları</h2>
                <div class="page-pretitle">SMS mesaj şablonlarını yönetin</div>
            </div>
            <div class="col-auto ms-auto">
                <div class="btn-list">
                    <a href="{{ route('admin.sms.ayarlar') }}" class="btn btn-outline-primary">
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10.325 4.317c.426 -1.756 2.924 -1.756 3.35 0a1.724 1.724 0 0 0 2.573 1.066c1.543 -.94 3.31 .826 2.37 2.37a1.724 1.724 0 0 0 1.065 2.572c1.756 .426 1.756 2.924 0 3.35a1.724 1.724 0 0 0 -1.066 2.573c.94 1.543 -.826 3.31 -2.37 2.37a1.724 1.724 0 0 0 -2.572 1.065c-.426 1.756 -2.924 1.756 -3.35 0a1.724 1.724 0 0 0 -2.573 -1.066c-1.543 .94 -3.31 -.826 -2.37 -2.37a1.724 1.724 0 0 0 -1.065 -2.572c-1.756 -.426 -1.756 -2.924 0 -3.35a1.724 1.724 0 0 0 1.066 -2.573c-.94 -1.543 .826 -3.31 2.37 -2.37c1 .608 2.296 .07 2.572 -1.065z" /><path d="M9 12a3 3 0 1 0 6 0a3 3 0 0 0 -6 0" /></svg>
                        SMS Ayarları
                    </a>
                    <a href="{{ route('admin.sms.raporlar') }}" class="btn btn-outline-primary">
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M3 12m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v6a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z" /><path d="M9 8m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v10a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z" /><path d="M15 4m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z" /></svg>
                        Raporlar
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="page-body">
    <div class="container-xl">
        @if(session('success'))
            <div class="alert alert-success alert-dismissible mb-3" role="alert">
                <div class="d-flex">
                    <div><svg xmlns="http://www.w3.org/2000/svg" class="icon alert-icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M5 12l5 5l10 -10" /></svg></div>
                    <div><h4 class="alert-title">Başarılı!</h4><div class="text-secondary">{{ session('success') }}</div></div>
                </div>
                <a class="btn-close" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
        @endif

        <div class="row">
            <div class="col-md-5">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Yeni Şablon Ekle</h3>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('admin.sms.template.save') }}" method="POST">
                            @csrf
                            <div class="mb-3">
                                <label class="form-label required">Şablon Türü</label>
                                <select name="tur" class="form-select @error('tur') is-invalid @enderror" required>
                                    <option value="">Seçiniz</option>
                                    <option value="ilan_sonrasi">İlan Sonrası Bildirim</option>
                                    <option value="bagis_onay">Bağış Onay</option>
                                    <option value="bagis_ret">Bağış Ret</option>
                                    <option value="hatirlatma">Hatırlatma</option>
                                </select>
                                @error('tur')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label class="form-label required">Şablon Başlığı</label>
                                <input type="text" name="baslik" class="form-control @error('baslik') is-invalid @enderror" placeholder="Örn: İlan Onay Bildirimi" required>
                                @error('baslik')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label class="form-label required">Şablon İçeriği</label>
                                <textarea name="icerik" rows="6" class="form-control @error('icerik') is-invalid @enderror" placeholder="Mesaj içeriğini yazın..." required></textarea>
                                @error('icerik')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="form-hint">
                                    <strong>Kullanılabilir Değişkenler:</strong><br>
                                    <code>{ad}</code> <code>{soyad}</code> <code>{kan_grubu}</code> <code>{hastane}</code> <code>{telefon}</code>
                                </small>
                            </div>
                            <button type="submit" class="btn btn-primary w-100">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 5l0 14" /><path d="M5 12l14 0" /></svg>
                                Şablonu Kaydet
                            </button>
                        </form>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-body">
                        <h4>Değişken Açıklamaları</h4>
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <tbody>
                                    <tr>
                                        <td><code>{ad}</code></td>
                                        <td>Kullanıcının adı</td>
                                    </tr>
                                    <tr>
                                        <td><code>{soyad}</code></td>
                                        <td>Kullanıcının soyadı</td>
                                    </tr>
                                    <tr>
                                        <td><code>{kan_grubu}</code></td>
                                        <td>Kan grubu (örn: A+)</td>
                                    </tr>
                                    <tr>
                                        <td><code>{hastane}</code></td>
                                        <td>Hastane adı</td>
                                    </tr>
                                    <tr>
                                        <td><code>{telefon}</code></td>
                                        <td>İletişim telefonu</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-7">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Mevcut Şablonlar ({{ $sablonlar->count() }})</h3>
                    </div>
                    <div class="card-body p-0">
                        @forelse($sablonlar as $sablon)
                        <div class="list-group list-group-flush">
                            <div class="list-group-item">
                                <div class="row align-items-center">
                                    <div class="col-auto">
                                        <span class="avatar bg-primary-lt">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M3 7a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-10z" /><path d="M3 7l9 6l9 -6" /></svg>
                                        </span>
                                    </div>
                                    <div class="col">
                                        <div class="d-flex align-items-center mb-1">
                                            <strong class="me-2">{{ $sablon->baslik }}</strong>
                                            @switch($sablon->kod)
                                                @case('ilan_bildirimi')
                                                    <span class="badge bg-blue-lt">İlan Bildirimi</span>
                                                    @break
                                                @case('bagis_onay')
                                                    <span class="badge bg-green-lt">Bağış Onay</span>
                                                    @break
                                                @case('bagis_ret')
                                                    <span class="badge bg-red-lt">Bağış Ret</span>
                                                    @break
                                                @case('hatirlatma')
                                                    <span class="badge bg-yellow-lt">Hatırlatma</span>
                                                    @break
                                            @endswitch
                                        </div>
                                        <div class="text-secondary small">{{ $sablon->icerik }}</div>
                                    </div>
                                    <div class="col-auto">
                                        <button type="button" class="btn btn-sm btn-ghost-danger" onclick="if(confirm('Bu şablonu silmek istediğinizden emin misiniz?')) { document.getElementById('delete-{{ $sablon->id }}').submit(); }">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M4 7l16 0" /><path d="M10 11l0 6" /><path d="M14 11l0 6" /><path d="M5 7l1 12a2 2 0 0 0 2 2h8a2 2 0 0 0 2 -2l1 -12" /></svg>
                                            Sil
                                        </button>
                                        <form id="delete-{{ $sablon->id }}" action="{{ route('admin.sms.template.delete', $sablon->id) }}" method="POST" class="d-none">
                                            @csrf
                                            @method('DELETE')
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @empty
                        <div class="empty py-5">
                            <div class="empty-img"><img src="data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' width='160' height='160' viewBox='0 0 160 160'%3e%3cg fill='%23f4f6fa'%3e%3cpath d='M143.6 96.5c0 2.8-2.3 5.1-5.1 5.1H91.8c-2.8 0-5.1-2.3-5.1-5.1V49.8c0-2.8 2.3-5.1 5.1-5.1h46.7c2.8 0 5.1 2.3 5.1 5.1v46.7z'/%3e%3cpath d='M111.2 56.9c-1.2 0-2.2-1-2.2-2.2s1-2.2 2.2-2.2 2.2 1 2.2 2.2-1 2.2-2.2 2.2zm8 0c-1.2 0-2.2-1-2.2-2.2s1-2.2 2.2-2.2 2.2 1 2.2 2.2-1 2.2-2.2 2.2zm8 0c-1.2 0-2.2-1-2.2-2.2s1-2.2 2.2-2.2 2.2 1 2.2 2.2-1 2.2-2.2 2.2z'/%3e%3cpath d='M135.3 66.7H94.3c-.9 0-1.6-.7-1.6-1.6s.7-1.6 1.6-1.6h41.1c.9 0 1.6.7 1.6 1.6s-.8 1.6-1.7 1.6zm0 8H94.3c-.9 0-1.6-.7-1.6-1.6s.7-1.6 1.6-1.6h41.1c.9 0 1.6.7 1.6 1.6s-.8 1.6-1.7 1.6zm0 8H94.3c-.9 0-1.6-.7-1.6-1.6s.7-1.6 1.6-1.6h41.1c.9 0 1.6.7 1.6 1.6s-.8 1.6-1.7 1.6zm0 8H94.3c-.9 0-1.6-.7-1.6-1.6s.7-1.6 1.6-1.6h41.1c.9 0 1.6.7 1.6 1.6s-.8 1.6-1.7 1.6z'/%3e%3c/g%3e%3c/svg%3e" height="160" alt="">
                            </div>
                            <p class="empty-title">Henüz şablon eklenmemiş</p>
                            <p class="empty-subtitle text-secondary">
                                Sol taraftaki formu kullanarak yeni SMS şablonu ekleyebilirsiniz
                            </p>
                        </div>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
