@extends('layouts.admin')

@section('title', 'SMS Raporları')

@section('content')
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <h2 class="page-title">SMS Raporları</h2>
                <div class="page-pretitle">SMS gönderim geçmişi ve istatistikleri</div>
            </div>
            <div class="col-auto ms-auto">
                <div class="btn-list">
                    <a href="{{ route('admin.sms.ayarlar') }}" class="btn btn-outline-primary">
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10.325 4.317c.426 -1.756 2.924 -1.756 3.35 0a1.724 1.724 0 0 0 2.573 1.066c1.543 -.94 3.31 .826 2.37 2.37a1.724 1.724 0 0 0 1.065 2.572c1.756 .426 1.756 2.924 0 3.35a1.724 1.724 0 0 0 -1.066 2.573c.94 1.543 -.826 3.31 -2.37 2.37a1.724 1.724 0 0 0 -2.572 1.065c-.426 1.756 -2.924 1.756 -3.35 0a1.724 1.724 0 0 0 -2.573 -1.066c-1.543 .94 -3.31 -.826 -2.37 -2.37a1.724 1.724 0 0 0 -1.065 -2.572c-1.756 -.426 -1.756 -2.924 0 -3.35a1.724 1.724 0 0 0 1.066 -2.573c-.94 -1.543 .826 -3.31 2.37 -2.37c1 .608 2.296 .07 2.572 -1.065z" /><path d="M9 12a3 3 0 1 0 6 0a3 3 0 0 0 -6 0" /></svg>
                        SMS Ayarları
                    </a>
                    <a href="{{ route('admin.sms.sablonlar') }}" class="btn btn-outline-primary">
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M14 3v4a1 1 0 0 0 1 1h4" /><path d="M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z" /></svg>
                        Şablonlar
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="page-body">
    <div class="container-xl">
        <div class="row row-cards mb-3">
            <div class="col-sm-6 col-lg-4">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="subheader">Bugün Gönderilen</div>
                        </div>
                        <div class="d-flex align-items-baseline">
                            <div class="h1 mb-0 me-2">{{ $bugun }}</div>
                            <div class="me-auto">
                                <span class="text-secondary">SMS</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-4">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="subheader">Bu Ay Gönderilen</div>
                        </div>
                        <div class="d-flex align-items-baseline">
                            <div class="h1 mb-0 me-2">{{ $buAy }}</div>
                            <div class="me-auto">
                                <span class="text-secondary">SMS</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-4">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="subheader">Toplam Gönderilen</div>
                        </div>
                        <div class="d-flex align-items-baseline">
                            <div class="h1 mb-0 me-2">{{ $toplam }}</div>
                            <div class="me-auto">
                                <span class="text-secondary">SMS</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h3 class="card-title">SMS Gönderim Geçmişi</h3>
                <div class="card-actions">
                    <a href="#" class="btn btn-outline-primary">
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M4 17v2a2 2 0 0 0 2 2h12a2 2 0 0 0 2 -2v-2" /><path d="M7 11l5 5l5 -5" /><path d="M12 4l0 12" /></svg>
                        Excel'e Aktar
                    </a>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table card-table table-vcenter">
                    <thead>
                        <tr>
                            <th>Tarih / Saat</th>
                            <th>Alıcı Telefon</th>
                            <th>Mesaj İçeriği</th>
                            <th>Durum</th>
                            <th>Servis</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($sonSmsler as $sms)
                        <tr>
                            <td>
                                @php
                                    $tarih = $sms->olusturulma_tarihi ?? $sms->created_at;
                                @endphp
                                <div>{{ \Carbon\Carbon::parse($tarih)->format('d.m.Y H:i') }}</div>
                                <div class="text-secondary small">{{ \Carbon\Carbon::parse($tarih)->diffForHumans() }}</div>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <span class="avatar avatar-sm me-2">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M5 4h4l2 5l-2.5 1.5a11 11 0 0 0 5 5l1.5 -2.5l5 2v4a2 2 0 0 1 -2 2a16 16 0 0 1 -15 -15a2 2 0 0 1 2 -2" /></svg>
                                    </span>
                                    <div>{{ $sms->telefon }}</div>
                                </div>
                            </td>
                            <td class="text-secondary" style="max-width: 300px;">
                                <div class="text-truncate">{{ $sms->mesaj }}</div>
                                @if($sms->hata_mesaji)
                                    <div class="text-danger small mt-1">{{ $sms->hata_mesaji }}</div>
                                @endif
                            </td>
                            <td>
                                @if($sms->durum == 'sent')
                                    <span class="badge bg-success">Gönderildi</span>
                                @elseif($sms->durum == 'queued')
                                    <span class="badge bg-warning">Beklemede</span>
                                @elseif($sms->durum == 'failed')
                                    <span class="badge bg-danger">Hata</span>
                                @else
                                    <span class="badge bg-secondary">{{ ucfirst($sms->durum) }}</span>
                                @endif
                            </td>
                            <td>
                                <div>
                                    <span class="badge bg-blue-lt">{{ strtoupper($sms->tip ?? 'GENEL') }}</span>
                                </div>
                                @if($sms->hedef_numara_sayisi > 1)
                                    <div class="text-secondary small mt-1">{{ $sms->hedef_numara_sayisi }} kişi</div>
                                @endif
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="5" class="text-center py-5">
                                <div class="empty">
                                    <div class="empty-img"><img src="data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' width='160' height='160' viewBox='0 0 160 160'%3e%3cg fill='%23f4f6fa'%3e%3cpath d='M143.6 96.5c0 2.8-2.3 5.1-5.1 5.1H91.8c-2.8 0-5.1-2.3-5.1-5.1V49.8c0-2.8 2.3-5.1 5.1-5.1h46.7c2.8 0 5.1 2.3 5.1 5.1v46.7z'/%3e%3cpath d='M111.2 56.9c-1.2 0-2.2-1-2.2-2.2s1-2.2 2.2-2.2 2.2 1 2.2 2.2-1 2.2-2.2 2.2zm8 0c-1.2 0-2.2-1-2.2-2.2s1-2.2 2.2-2.2 2.2 1 2.2 2.2-1 2.2-2.2 2.2zm8 0c-1.2 0-2.2-1-2.2-2.2s1-2.2 2.2-2.2 2.2 1 2.2 2.2-1 2.2-2.2 2.2z'/%3e%3cpath d='M135.3 66.7H94.3c-.9 0-1.6-.7-1.6-1.6s.7-1.6 1.6-1.6h41.1c.9 0 1.6.7 1.6 1.6s-.8 1.6-1.7 1.6zm0 8H94.3c-.9 0-1.6-.7-1.6-1.6s.7-1.6 1.6-1.6h41.1c.9 0 1.6.7 1.6 1.6s-.8 1.6-1.7 1.6zm0 8H94.3c-.9 0-1.6-.7-1.6-1.6s.7-1.6 1.6-1.6h41.1c.9 0 1.6.7 1.6 1.6s-.8 1.6-1.7 1.6zm0 8H94.3c-.9 0-1.6-.7-1.6-1.6s.7-1.6 1.6-1.6h41.1c.9 0 1.6.7 1.6 1.6s-.8 1.6-1.7 1.6z'/%3e%3c/g%3e%3c/svg%3e" height="160" alt="">
                                    </div>
                                    <p class="empty-title">Henüz SMS gönderimi yapılmamış</p>
                                    <p class="empty-subtitle text-secondary">
                                        SMS gönderimi yapıldığında geçmiş burada görünecektir
                                    </p>
                                </div>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
