@extends('layouts.admin')

@section('title', 'SMS Ayarları')

@section('content')

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const testForm = document.getElementById('testSmsForm');
    const testBtn = document.getElementById('testSmsBtn');
    const testAlert = document.getElementById('testSmsAlert');
    const testTelefon = document.getElementById('testTelefon');

    testForm.addEventListener('submit', async function(e) {
        e.preventDefault();
        
        const telefon = testTelefon.value.trim();
        
        if (!telefon || telefon.length !== 10 || !telefon.startsWith('5')) {
            showAlert('danger', 'Lütfen geçerli bir telefon numarası girin (5XX XXX XX XX)');
            return;
        }

        testBtn.disabled = true;
        testBtn.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>Gönderiliyor...';
        testAlert.innerHTML = '';

        try {
            const response = await fetch('{{ route("admin.sms.test") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ telefon: telefon })
            });

            const data = await response.json();

            if (data.success) {
                showAlert('success', data.message);
                testTelefon.value = '';
            } else {
                showAlert('danger', data.message || 'SMS gönderilemedi.');
            }
        } catch (error) {
            showAlert('danger', 'Bir hata oluştu: ' + error.message);
        } finally {
            testBtn.disabled = false;
            testBtn.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10 14l11 -11" /><path d="M21 3l-6.5 18a.55 .55 0 0 1 -1 0l-3.5 -7l-7 -3.5a.55 .55 0 0 1 0 -1l18 -6.5" /></svg> Test SMS Gönder';
        }
    });

    function showAlert(type, message) {
        const iconMap = {
            success: '<svg xmlns="http://www.w3.org/2000/svg" class="icon alert-icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M5 12l5 5l10 -10" /></svg>',
            danger: '<svg xmlns="http://www.w3.org/2000/svg" class="icon alert-icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 9v4" /><path d="M10.363 3.591l-8.106 13.534a1.914 1.914 0 0 0 1.636 2.871h16.214a1.914 1.914 0 0 0 1.636 -2.87l-8.106 -13.536a1.914 1.914 0 0 0 -3.274 0z" /><path d="M12 16h.01" /></svg>'
        };

        testAlert.innerHTML = `
            <div class="alert alert-${type} alert-dismissible mb-3" role="alert">
                <div class="d-flex">
                    <div>${iconMap[type] || ''}</div>
                    <div class="text-secondary">${message}</div>
                </div>
                <a class="btn-close" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
        `;
    }
});
</script>
@endpush
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <h2 class="page-title">SMS Ayarları</h2>
                <div class="page-pretitle">SMS API yapılandırması ve servis sağlayıcı ayarları</div>
            </div>
            <div class="col-auto ms-auto">
                <div class="btn-list">
                    <a href="{{ route('admin.sms.sablonlar') }}" class="btn btn-outline-primary">
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M14 3v4a1 1 0 0 0 1 1h4" /><path d="M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z" /></svg>
                        Şablonlar
                    </a>
                    <a href="{{ route('admin.sms.raporlar') }}" class="btn btn-outline-primary">
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M3 12m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v6a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z" /><path d="M9 8m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v10a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z" /><path d="M15 4m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z" /></svg>
                        Raporlar
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="page-body">
    <div class="container-xl">
        @if(session('success'))
            <div class="alert alert-success alert-dismissible mb-3" role="alert">
                <div class="d-flex">
                    <div><svg xmlns="http://www.w3.org/2000/svg" class="icon alert-icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M5 12l5 5l10 -10" /></svg></div>
                    <div><h4 class="alert-title">Başarılı!</h4><div class="text-secondary">{{ session('success') }}</div></div>
                </div>
                <a class="btn-close" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
        @endif

        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">API Ayarları</h3>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('admin.sms.api.save') }}" method="POST">
                            @csrf
                            <div class="mb-3">
                                <label class="form-label required">SMS Servis Sağlayıcı</label>
                                <select name="servis_saglayici" class="form-select @error('servis_saglayici') is-invalid @enderror" required>
                                    <option value="">Seçiniz</option>
                                    <option value="netgsm" {{ old('servis_saglayici', $ayarlar->servis_saglayici ?? '') == 'netgsm' ? 'selected' : '' }}>
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon text-green" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M5 4h4l2 5l-2.5 1.5a11 11 0 0 0 5 5l1.5 -2.5l5 2v4a2 2 0 0 1 -2 2a16 16 0 0 1 -15 -15a2 2 0 0 1 2 -2" /></svg>
                                        NetGSM
                                    </option>
                                    <option value="jetsms" {{ old('servis_saglayici', $ayarlar->servis_saglayici ?? '') == 'jetsms' ? 'selected' : '' }}>
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon text-blue" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M15 12h5a2 2 0 0 1 0 4h-15l-3 -6h3l2 2h3l-2 -7h3z" /><path d="M15 9m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0" /></svg>
                                        JetSMS
                                    </option>
                                </select>
                                @error('servis_saglayici')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="form-hint">Kullanmak istediğiniz SMS servis sağlayıcısını seçin</small>
                            </div>

                            <div class="mb-3">
                                <label class="form-label required">API Key / Kullanıcı Adı</label>
                                <div class="input-group">
                                    <span class="input-group-text">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 3a12 12 0 0 0 8.5 3a12 12 0 0 1 -8.5 15a12 12 0 0 1 -8.5 -15a12 12 0 0 0 8.5 -3" /><path d="M12 11m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0" /></svg>
                                    </span>
                                    <input type="text" name="api_key" class="form-control @error('api_key') is-invalid @enderror" value="{{ old('api_key', $ayarlar->api_key ?? '') }}" placeholder="API anahtarınız" required>
                                </div>
                                @error('api_key')
                                    <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                                <small class="form-hint">NetGSM için kullanıcı kodu, JetSMS için API Key</small>
                            </div>

                            <div class="mb-3">
                                <label class="form-label required">API Secret / Şifre</label>
                                <div class="input-group">
                                    <span class="input-group-text">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M5 13a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v6a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-6z" /><path d="M11 16a1 1 0 1 0 2 0a1 1 0 0 0 -2 0" /><path d="M8 11v-4a4 4 0 1 1 8 0v4" /></svg>
                                    </span>
                                    <input type="password" name="api_secret" class="form-control @error('api_secret') is-invalid @enderror" value="{{ old('api_secret', $ayarlar->api_secret ?? '') }}" placeholder="API secret/şifre" required>
                                </div>
                                @error('api_secret')
                                    <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                                <small class="form-hint">NetGSM için şifre, JetSMS için API Secret</small>
                            </div>

                            <div class="mb-3">
                                <label class="form-label required">SMS Başlığı (Originator)</label>
                                <div class="input-group">
                                    <span class="input-group-text">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M3 7a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-10z" /><path d="M3 7l9 6l9 -6" /></svg>
                                    </span>
                                    <input type="text" name="api_header" class="form-control @error('api_header') is-invalid @enderror" value="{{ old('api_header', $ayarlar->api_header ?? '') }}" placeholder="Örn: KANBANKASI" maxlength="11" required>
                                </div>
                                @error('api_header')
                                    <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                                <small class="form-hint">SMS'lerde görünecek başlık (max 11 karakter)</small>
                            </div>

                            <div class="mt-4">
                                <button type="submit" class="btn btn-primary">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M6 4h10l4 4v10a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2" /></svg>
                                    Ayarları Kaydet
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Servis Bilgileri</h3>
                    </div>
                    <div class="card-body">
                        <div class="mb-4">
                            <h4 class="mb-2">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon text-green me-2" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M5 4h4l2 5l-2.5 1.5a11 11 0 0 0 5 5l1.5 -2.5l5 2v4a2 2 0 0 1 -2 2a16 16 0 0 1 -15 -15a2 2 0 0 1 2 -2" /></svg>
                                NetGSM
                            </h4>
                            <ul class="list-unstyled text-secondary mb-0">
                                <li class="mb-1">• API Key: Kullanıcı kodunuz</li>
                                <li class="mb-1">• API Secret: Şifreniz</li>
                                <li class="mb-1">• API URL: https://api.netgsm.com.tr</li>
                                <li>• Dokümantasyon: <a href="https://www.netgsm.com.tr/dokuman" target="_blank">netgsm.com.tr/dokuman</a></li>
                            </ul>
                        </div>
                        <hr>
                        <div class="mt-4">
                            <h4 class="mb-2">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon text-blue me-2" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M15 12h5a2 2 0 0 1 0 4h-15l-3 -6h3l2 2h3l-2 -7h3z" /><path d="M15 9m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0" /></svg>
                                JetSMS
                            </h4>
                            <ul class="list-unstyled text-secondary mb-0">
                                <li class="mb-1">• API Key: API anahtarınız</li>
                                <li class="mb-1">• API Secret: Secret anahtarınız</li>
                                <li class="mb-1">• API URL: https://api.jetsms.com.tr</li>
                                <li>• Dokümantasyon: <a href="https://www.jetsms.com.tr/api" target="_blank">jetsms.com.tr/api</a></li>
                            </ul>
                        </div>
                    </div>
                </div>

                @if($ayarlar)
                <div class="card mt-3">
                    <div class="card-stamp card-stamp-lg">
                        <div class="card-stamp-icon bg-success">
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M5 12l5 5l10 -10" /></svg>
                        </div>
                    </div>
                    <div class="card-body">
                        <h3 class="card-title">Mevcut Ayarlar</h3>
                        <div class="text-secondary">
                            <div class="mb-2"><strong>Sağlayıcı:</strong> {{ strtoupper($ayarlar->servis_saglayici) }}</div>
                            <div class="mb-2"><strong>Başlık:</strong> {{ $ayarlar->api_header }}</div>
                            <div><strong>Durum:</strong> <span class="badge bg-success">Aktif</span></div>
                        </div>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-header">
                        <h3 class="card-title">Test SMS Gönder</h3>
                    </div>
                    <div class="card-body">
                        <form id="testSmsForm">
                            @csrf
                            <div class="mb-3">
                                <label class="form-label required">Telefon Numarası</label>
                                <div class="input-group">
                                    <span class="input-group-text">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M5 4h4l2 5l-2.5 1.5a11 11 0 0 0 5 5l1.5 -2.5l5 2v4a2 2 0 0 1 -2 2a16 16 0 0 1 -15 -15a2 2 0 0 1 2 -2" /></svg>
                                    </span>
                                    <input type="text" name="telefon" id="testTelefon" class="form-control" placeholder="5XXXXXXXXX" maxlength="10" pattern="5[0-9]{9}" required>
                                </div>
                                <small class="form-hint">0 olmadan 10 haneli numara girin (5XX XXX XX XX)</small>
                            </div>
                            <div id="testSmsAlert"></div>
                            <button type="submit" class="btn btn-info w-100" id="testSmsBtn">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10 14l11 -11" /><path d="M21 3l-6.5 18a.55 .55 0 0 1 -1 0l-3.5 -7l-7 -3.5a.55 .55 0 0 1 0 -1l18 -6.5" /></svg>
                                Test SMS Gönder
                            </button>
                        </form>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
