@extends('layouts.admin')

@section('title', 'Kullanıcı Bazlı İlanlar')

@section('content')
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <div class="page-pretitle">
                    <a href="{{ route('admin.raporlar.index') }}">Raporlar</a>
                </div>
                <h2 class="page-title">
                    Kullanıcı Bazlı İlanlar
                </h2>
            </div>
            <div class="col-auto ms-auto">
                <a href="{{ route('admin.raporlar.index') }}" class="btn btn-secondary">
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                        <line x1="5" y1="12" x2="19" y2="12" />
                        <line x1="5" y1="12" x2="9" y2="16" />
                        <line x1="5" y1="12" x2="9" y2="8" />
                    </svg>
                    Geri
                </a>
            </div>
        </div>
    </div>
</div>

<div class="page-body">
    <div class="container-xl">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Kullanıcıların Oluşturduğu İlan Sayıları</h3>
                    </div>
                    <div class="table-responsive">
                        <table class="table card-table table-vcenter">
                            <thead>
                                <tr>
                                    <th>Kullanıcı</th>
                                    <th>Kan Grubu</th>
                                    <th>E-posta</th>
                                    <th>Telefon</th>
                                    <th class="text-center">Toplam İlan</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($kullanicilar as $kullanici)
                                <tr>
                                    <td>
                                        <div class="d-flex py-1 align-items-center">
                                            <span class="avatar me-2">{{ substr($kullanici->ad, 0, 1) }}{{ substr($kullanici->soyad, 0, 1) }}</span>
                                            <div class="flex-fill">
                                                <div class="font-weight-medium">{{ $kullanici->ad }} {{ $kullanici->soyad }}</div>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge bg-red">{{ $kullanici->kan_grubu }}</span>
                                    </td>
                                    <td>{{ $kullanici->email }}</td>
                                    <td>{{ $kullanici->telefon }}</td>
                                    <td class="text-center">
                                        <span class="badge bg-blue">{{ $kullanici->ilan_sayisi }}</span>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="5" class="text-center">Henüz kullanıcı bulunmuyor</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
