@extends('layouts.admin')

@section('title', 'Kan Grubu Bazlı Kullanıcı Raporu')

@section('content')
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <div class="page-pretitle">
                    <a href="{{ route('admin.raporlar.index') }}">Raporlar</a>
                </div>
                <h2 class="page-title">
                    Kan Grubu Bazlı Kullanıcı Raporu
                </h2>
            </div>
            <div class="col-auto ms-auto">
                <a href="{{ route('admin.raporlar.index') }}" class="btn btn-secondary">
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                        <line x1="5" y1="12" x2="19" y2="12" />
                        <line x1="5" y1="12" x2="9" y2="16" />
                        <line x1="5" y1="12" x2="9" y2="8" />
                    </svg>
                    Geri
                </a>
            </div>
        </div>
    </div>
</div>

<div class="page-body">
    <div class="container-xl">
        <!-- Özet Kart -->
        <div class="row mb-3">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row align-items-center">
                            <div class="col-auto">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon text-red" width="48" height="48" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                    <circle cx="9" cy="7" r="4" />
                                    <path d="M3 21v-2a4 4 0 0 1 4 -4h4a4 4 0 0 1 4 4v2" />
                                    <path d="M16 3.13a4 4 0 0 1 0 7.75" />
                                    <path d="M21 21v-2a4 4 0 0 0 -3 -3.85" />
                                </svg>
                            </div>
                            <div class="col">
                                <h3 class="mb-0">{{ $toplamKullanici }}</h3>
                                <div class="text-muted">Toplam Kullanıcı</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Kan Grubu Tablosu -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Kan Gruplarına Göre Dağılım</h3>
                    </div>
                    <div class="table-responsive">
                        <table class="table card-table table-vcenter">
                            <thead>
                                <tr>
                                    <th>Kan Grubu</th>
                                    <th>Toplam Kullanıcı</th>
                                    <th>Aktif Kullanıcı</th>
                                    <th>SMS İzinli</th>
                                    <th>Yüzde</th>
                                    <th class="w-50">Grafik</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($kanGruplari as $grup)
                                <tr>
                                    <td>
                                        <span class="badge bg-red text-white" style="font-size: 1rem; padding: 0.5rem 1rem;">
                                            {{ $grup->kan_grubu }}
                                        </span>
                                    </td>
                                    <td>
                                        <strong>{{ $grup->kullanici_sayisi }}</strong>
                                    </td>
                                    <td>
                                        <span class="badge bg-green">{{ $grup->aktif_sayisi }}</span>
                                    </td>
                                    <td>
                                        <span class="badge bg-blue">{{ $grup->sms_izinli_sayisi }}</span>
                                    </td>
                                    <td>
                                        <strong>{{ $toplamKullanici > 0 ? number_format(($grup->kullanici_sayisi / $toplamKullanici) * 100, 1) : 0 }}%</strong>
                                    </td>
                                    <td>
                                        <div class="progress" style="height: 20px;">
                                            <div class="progress-bar bg-red" role="progressbar" 
                                                 style="width: {{ $toplamKullanici > 0 ? ($grup->kullanici_sayisi / $toplamKullanici) * 100 : 0 }}%" 
                                                 aria-valuenow="{{ $grup->kullanici_sayisi }}" 
                                                 aria-valuemin="0" 
                                                 aria-valuemax="{{ $toplamKullanici }}">
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="6" class="text-center">Henüz kullanıcı bulunmuyor</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
