@extends('layouts.admin')

@section('title', 'Kan Grubu İlanları')

@section('content')
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <div class="page-pretitle">
                    <a href="{{ route('admin.raporlar.index') }}">Raporlar</a>
                </div>
                <h2 class="page-title">
                    Kan Grubu İlanları
                </h2>
            </div>
            <div class="col-auto ms-auto">
                <a href="{{ route('admin.raporlar.index') }}" class="btn btn-secondary">
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                        <line x1="5" y1="12" x2="19" y2="12" />
                        <line x1="5" y1="12" x2="9" y2="16" />
                        <line x1="5" y1="12" x2="9" y2="8" />
                    </svg>
                    Geri
                </a>
            </div>
        </div>
    </div>
</div>

<div class="page-body">
    <div class="container-xl">
        <!-- Özet Kart -->
        <div class="row mb-3">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row align-items-center">
                            <div class="col-auto">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon text-red" width="48" height="48" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                    <rect x="3" y="5" width="18" height="14" rx="2" />
                                    <line x1="3" y1="10" x2="21" y2="10" />
                                    <line x1="7" y1="15" x2="7.01" y2="15" />
                                    <line x1="11" y1="15" x2="13" y2="15" />
                                </svg>
                            </div>
                            <div class="col">
                                <h3 class="mb-0">{{ $toplamIlan }}</h3>
                                <div class="text-muted">Toplam İlan</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- İlan İstatistikleri Tablosu -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Kan Gruplarına Göre İlan Dağılımı</h3>
                    </div>
                    <div class="table-responsive">
                        <table class="table card-table table-vcenter">
                            <thead>
                                <tr>
                                    <th>Kan Grubu</th>
                                    <th>Toplam İlan</th>
                                    <th>Aktif</th>
                                    <th>Tamamlanan</th>
                                    <th>İptal</th>
                                    <th>Yüzde</th>
                                    <th class="w-50">Grafik</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($kanGruplari as $grup)
                                <tr>
                                    <td>
                                        <span class="badge bg-red text-white" style="font-size: 1rem; padding: 0.5rem 1rem;">
                                            {{ $grup->kan_grubu ?? 'Belirtilmemiş' }}
                                        </span>
                                    </td>
                                    <td>
                                        <strong>{{ $grup->ilan_sayisi }}</strong>
                                    </td>
                                    <td>
                                        <span class="badge bg-green">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-circle-check" width="16" height="16" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                                <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                                <circle cx="12" cy="12" r="9" />
                                                <path d="M9 12l2 2l4 -4" />
                                            </svg>
                                            {{ $grup->aktif_ilan }}
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge bg-blue">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-check" width="16" height="16" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                                <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                                <path d="M5 12l5 5l10 -10" />
                                            </svg>
                                            {{ $grup->tamamlanan_ilan }}
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge bg-red">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-x" width="16" height="16" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                                <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                                <line x1="18" y1="6" x2="6" y2="18" />
                                                <line x1="6" y1="6" x2="18" y2="18" />
                                            </svg>
                                            {{ $grup->iptal_ilan }}
                                        </span>
                                    </td>
                                    <td>
                                        <strong>{{ $toplamIlan > 0 ? number_format(($grup->ilan_sayisi / $toplamIlan) * 100, 1) : 0 }}%</strong>
                                    </td>
                                    <td>
                                        <div class="progress" style="height: 20px;">
                                            <div class="progress-bar bg-green" role="progressbar" 
                                                 style="width: {{ $grup->ilan_sayisi > 0 ? ($grup->aktif_ilan / $grup->ilan_sayisi) * 100 : 0 }}%" 
                                                 title="Aktif: {{ $grup->aktif_ilan }}">
                                            </div>
                                            <div class="progress-bar bg-blue" role="progressbar" 
                                                 style="width: {{ $grup->ilan_sayisi > 0 ? ($grup->tamamlanan_ilan / $grup->ilan_sayisi) * 100 : 0 }}%" 
                                                 title="Tamamlanan: {{ $grup->tamamlanan_ilan }}">
                                            </div>
                                            <div class="progress-bar bg-red" role="progressbar" 
                                                 style="width: {{ $grup->ilan_sayisi > 0 ? ($grup->iptal_ilan / $grup->ilan_sayisi) * 100 : 0 }}%" 
                                                 title="İptal: {{ $grup->iptal_ilan }}">
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" class="text-center">Henüz ilan bulunmuyor</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Durum Açıklaması -->
        <div class="row mt-3">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">Durum Açıklamaları</h4>
                        <div class="row mt-3">
                            <div class="col-md-4">
                                <div class="d-flex align-items-center">
                                    <span class="badge bg-green me-2">Aktif</span>
                                    <span class="text-muted">İlan halen yayında ve kan bekleniyor</span>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="d-flex align-items-center">
                                    <span class="badge bg-blue me-2">Tamamlanan</span>
                                    <span class="text-muted">Kan bulundu, ihtiyaç karşılandı</span>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="d-flex align-items-center">
                                    <span class="badge bg-red me-2">İptal</span>
                                    <span class="text-muted">İlan iptal edildi veya süresi doldu</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
