@extends('layouts.admin')

@section('title', 'Kan Grubuna Göre Kullanıcı Raporlama')

@section('content')
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <div class="page-pretitle">
                    <a href="{{ route('admin.raporlar.index') }}">Raporlar</a>
                </div>
                <h2 class="page-title">
                    Kan Grubuna Göre Kullanıcı Raporlama
                </h2>
            </div>
            <div class="col-auto ms-auto">
                <a href="{{ route('admin.raporlar.index') }}" class="btn btn-secondary">
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                        <line x1="5" y1="12" x2="19" y2="12" />
                        <line x1="5" y1="12" x2="9" y2="16" />
                        <line x1="5" y1="12" x2="9" y2="8" />
                    </svg>
                    Geri
                </a>
            </div>
        </div>
    </div>
</div>

<div class="page-body">
    <div class="container-xl">
        <!-- Filtre Formu -->
        <div class="row mb-3">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Filtre Seçenekleri</h3>
                    </div>
                    <div class="card-body">
                        <form method="GET" action="{{ route('admin.raporlar.kan-grubu-detay') }}" class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label required">Kan Grubu Seçin</label>
                                <select name="kan_grubu" class="form-select" required onchange="this.form.submit()">
                                    <option value="">-- Seçiniz --</option>
                                    @foreach(['A Rh+', 'A Rh-', 'B Rh+', 'B Rh-', 'AB Rh+', 'AB Rh-', '0 Rh+', '0 Rh-'] as $grup)
                                        <option value="{{ $grup }}" {{ request('kan_grubu') == $grup ? 'selected' : '' }}>
                                            {{ $grup }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-6 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                        <circle cx="10" cy="10" r="7" />
                                        <line x1="21" y1="21" x2="15" y2="15" />
                                    </svg>
                                    Listele
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        @if(request('kan_grubu'))
            <!-- Özet Bilgi -->
            <div class="row mb-3">
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="subheader">Seçilen Kan Grubu</div>
                            </div>
                            <div class="h1 mb-0 mt-2">
                                <span class="badge bg-red text-white" style="font-size: 1.5rem; padding: 0.5rem 1.5rem;">
                                    {{ request('kan_grubu') }}
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="subheader">Toplam Kullanıcı</div>
                            </div>
                            <div class="h1 mb-0 mt-2">{{ $kullanicilar->count() }}</div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="subheader">Aktif Kullanıcı</div>
                            </div>
                            <div class="h1 mb-0 mt-2">{{ $kullanicilar->where('aktif', 1)->count() }}</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Kullanıcı Listesi -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Kullanıcı Listesi</h3>
                        </div>
                        <div class="table-responsive">
                            <table class="table card-table table-vcenter">
                                <thead>
                                    <tr>
                                        <th>Kullanıcı</th>
                                        <th>E-posta</th>
                                        <th>Telefon</th>
                                        <th>Konum</th>
                                        <th>Durum</th>
                                        <th>SMS İzni</th>
                                        <th>Kayıt Tarihi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($kullanicilar as $kullanici)
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <span class="avatar me-2" style="background-color: #d63939; color: white;">
                                                    {{ strtoupper(mb_substr($kullanici->ad, 0, 1) . mb_substr($kullanici->soyad, 0, 1)) }}
                                                </span>
                                                <div>
                                                    <strong>{{ $kullanici->ad }} {{ $kullanici->soyad }}</strong>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <small class="text-muted">{{ $kullanici->email }}</small>
                                        </td>
                                        <td>
                                            <small class="text-muted">{{ $kullanici->telefon }}</small>
                                        </td>
                                        <td>
                                            @if($kullanici->il_ad || $kullanici->ilce_ad)
                                                <small class="text-muted">
                                                    {{ $kullanici->ilce_ad ? $kullanici->ilce_ad : '' }}{{ $kullanici->ilce_ad && $kullanici->il_ad ? ' / ' : '' }}{{ $kullanici->il_ad ? $kullanici->il_ad : '' }}
                                                </small>
                                            @else
                                                <small class="text-muted">-</small>
                                            @endif
                                        </td>
                                        <td>
                                            @if($kullanici->aktif)
                                                <span class="badge bg-green">
                                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-circle-check" width="16" height="16" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                                        <circle cx="12" cy="12" r="9" />
                                                        <path d="M9 12l2 2l4 -4" />
                                                    </svg>
                                                    Aktif
                                                </span>
                                            @else
                                                <span class="badge bg-secondary">
                                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-circle-x" width="16" height="16" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                                        <circle cx="12" cy="12" r="9" />
                                                        <path d="M10 10l4 4m0 -4l-4 4" />
                                                    </svg>
                                                    Pasif
                                                </span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($kullanici->sms_izni)
                                                <span class="badge bg-blue">
                                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-message" width="16" height="16" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                                        <path d="M4 21v-13a3 3 0 0 1 3 -3h10a3 3 0 0 1 3 3v6a3 3 0 0 1 -3 3h-9l-4 4" />
                                                        <line x1="8" y1="9" x2="16" y2="9" />
                                                        <line x1="8" y1="13" x2="14" y2="13" />
                                                    </svg>
                                                    Var
                                                </span>
                                            @else
                                                <span class="badge bg-secondary">
                                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-message-off" width="16" height="16" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                                        <line x1="3" y1="3" x2="21" y2="21" />
                                                        <path d="M17 17h-9l-4 4v-13c0 -1.086 .577 -2.036 1.44 -2.563m3.561 -.437h8a3 3 0 0 1 3 3v6c0 .575 -.162 1.112 -.442 1.568" />
                                                    </svg>
                                                    Yok
                                                </span>
                                            @endif
                                        </td>
                                        <td>
                                            <small class="text-muted">{{ $kullanici->created_at->format('d.m.Y') }}</small>
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="7" class="text-center">Bu kan grubuna ait kullanıcı bulunmuyor</td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        @else
            <!-- Başlangıç Mesajı -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body text-center py-5">
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-filter mb-3" width="64" height="64" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                <path d="M5.5 5h13a1 1 0 0 1 .5 1.5l-5 5.5l0 7l-4 -3l0 -4l-5 -5.5a1 1 0 0 1 .5 -1.5" />
                            </svg>
                            <h3 class="text-muted">Rapor oluşturmak için yukarıdaki filtreden kan grubu seçiniz</h3>
                        </div>
                    </div>
                </div>
            </div>
        @endif
    </div>
</div>
@endsection
