@extends('layouts.admin')

@section('title', 'Kullanıcı Detayı')

@section('content')
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <h2 class="page-title">
                    {{ $kullanici->ad }} {{ $kullanici->soyad }}
                </h2>
                <div class="page-pretitle">
                    YÖNETİM PANELİ
                </div>
            </div>
            <div class="col-auto ms-auto">
                <div class="btn-list">
                    <a href="{{ route('admin.kullanicilar.index') }}" class="btn btn-outline-secondary">
                        <i class="ti ti-arrow-left"></i>
                        Geri
                    </a>
                    <a href="{{ route('admin.kullanicilar.edit', $kullanici->id) }}" class="btn btn-primary">
                        <i class="ti ti-edit"></i>
                        Düzenle
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="page-body">
    <div class="container-xl">
        <div class="row row-cards">
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-body text-center">
                        <div class="mb-3">
                            <span class="avatar avatar-xl rounded" style="background-image: url(https://ui-avatars.com/api/?name={{ urlencode($kullanici->ad . ' ' . $kullanici->soyad) }}&background=random&size=128)"></span>
                        </div>
                        <h3 class="mb-1">{{ $kullanici->ad }} {{ $kullanici->soyad }}</h3>
                        <div class="text-secondary mb-3">{{ $kullanici->email }}</div>
                        <div class="mb-3">
                            @if($kullanici->aktif)
                                <span class="badge bg-success-lt me-1">Aktif</span>
                            @else
                                <span class="badge bg-danger-lt me-1">Pasif</span>
                            @endif
                            @if($kullanici->sms_izni)
                                <span class="badge bg-info-lt">SMS İzni Var</span>
                            @else
                                <span class="badge bg-secondary-lt">SMS İzni Yok</span>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-header">
                        <h3 class="card-title">İstatistikler</h3>
                    </div>
                    <div class="card-body">
                        <div class="datagrid">
                            <div class="datagrid-item">
                                <div class="datagrid-title">Toplam İlan</div>
                                <div class="datagrid-content">{{ $ilanSayisi }}</div>
                            </div>
                            <div class="datagrid-item">
                                <div class="datagrid-title">Kayıt Tarihi</div>
                                <div class="datagrid-content">{{ \Carbon\Carbon::parse($kullanici->created_at)->format('d.m.Y') }}</div>
                            </div>
                        </div>
                        @if($ilanSayisi > 0)
                        <div class="mt-3">
                            <a href="{{ route('admin.kullanicilar.ilanlar', $kullanici->id) }}" class="btn btn-primary w-100">
                                <i class="ti ti-list"></i>
                                İlanları Gör
                            </a>
                        </div>
                        @endif
                    </div>
                </div>
            </div>

            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Kimlik Bilgileri</h3>
                    </div>
                    <div class="card-body">
                        <div class="datagrid">
                            <div class="datagrid-item">
                                <div class="datagrid-title">Ad Soyad</div>
                                <div class="datagrid-content">{{ $kullanici->ad }} {{ $kullanici->soyad }}</div>
                            </div>
                            <div class="datagrid-item">
                                <div class="datagrid-title">TC Kimlik</div>
                                <div class="datagrid-content">{{ $kullanici->tc_kimlik ?? '-' }}</div>
                            </div>
                            <div class="datagrid-item">
                                <div class="datagrid-title">Doğum Tarihi</div>
                                <div class="datagrid-content">{{ $kullanici->dogum_tarihi ? \Carbon\Carbon::parse($kullanici->dogum_tarihi)->format('d.m.Y') : '-' }}</div>
                            </div>
                            <div class="datagrid-item">
                                <div class="datagrid-title">Cinsiyet</div>
                                <div class="datagrid-content">{{ $kullanici->cinsiyet == 'E' ? 'Erkek' : ($kullanici->cinsiyet == 'K' ? 'Kadın' : '-') }}</div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-header">
                        <h3 class="card-title">İletişim Bilgileri</h3>
                    </div>
                    <div class="card-body">
                        <div class="datagrid">
                            <div class="datagrid-item">
                                <div class="datagrid-title">E-posta</div>
                                <div class="datagrid-content">{{ $kullanici->email }}</div>
                            </div>
                            <div class="datagrid-item">
                                <div class="datagrid-title">Telefon</div>
                                <div class="datagrid-content">{{ $kullanici->telefon }}</div>
                            </div>
                            <div class="datagrid-item">
                                <div class="datagrid-title">İl</div>
                                <div class="datagrid-content">{{ $kullanici->il_adi }}</div>
                            </div>
                            <div class="datagrid-item">
                                <div class="datagrid-title">İlçe</div>
                                <div class="datagrid-content">{{ $kullanici->ilce_adi ?? '-' }}</div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-header">
                        <h3 class="card-title">Sağlık Bilgileri</h3>
                    </div>
                    <div class="card-body">
                        <div class="datagrid">
                            <div class="datagrid-item">
                                <div class="datagrid-title">Kan Grubu</div>
                                <div class="datagrid-content">
                                    <span class="badge bg-red-lt">{{ $kullanici->kan_grubu }}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-header">
                        <h3 class="card-title">Durum Bilgileri</h3>
                    </div>
                    <div class="card-body">
                        <div class="datagrid">
                            <div class="datagrid-item">
                                <div class="datagrid-title">Hesap Durumu</div>
                                <div class="datagrid-content">
                                    @if($kullanici->aktif)
                                        <span class="badge bg-success-lt">Aktif</span>
                                    @else
                                        <span class="badge bg-danger-lt">Pasif</span>
                                    @endif
                                </div>
                            </div>
                            <div class="datagrid-item">
                                <div class="datagrid-title">SMS İzni</div>
                                <div class="datagrid-content">
                                    @if($kullanici->sms_izni)
                                        <span class="badge bg-info-lt">Var</span>
                                    @else
                                        <span class="badge bg-secondary-lt">Yok</span>
                                    @endif
                                </div>
                            </div>
                            <div class="datagrid-item">
                                <div class="datagrid-title">Kayıt Tarihi</div>
                                <div class="datagrid-content">{{ \Carbon\Carbon::parse($kullanici->created_at)->format('d.m.Y H:i') }}</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
