@extends('layouts.admin')

@section('title', 'Kullanıcı Yönetimi')

@section('content')
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <h2 class="page-title">Kullanıcı Yönetimi</h2>
            </div>
            <div class="col-auto ms-auto d-print-none">
                <a href="{{ route('admin.kullanicilar.create') }}" class="btn btn-primary">
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 5l0 14" /><path d="M5 12l14 0" /></svg>
                    Yeni Kullanıcı
                </a>
            </div>
        </div>
    </div>
</div>

<div class="page-body">
    <div class="container-xl">
        <div class="card mb-3">
            <div class="card-body">
                <form method="GET">
                    <div class="row g-2">
                        <div class="col-md-3">
                            <input type="text" name="search" class="form-control" placeholder="Ad, email, TC..." value="{{ request('search') }}">
                        </div>
                        <div class="col-md-3">
                            <select name="kan_grubu_id" class="form-select">
                                <option value="">Tüm Kan Grupları</option>
                                @foreach($kanGruplari as $grup)
                                    <option value="{{ $grup->id }}" {{ request('kan_grubu_id') == $grup->id ? 'selected' : '' }}>{{ $grup->ad }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3">
                            <select name="il_id" class="form-select">
                                <option value="">Tüm İller</option>
                                @foreach($iller as $il)
                                    <option value="{{ $il->id }}" {{ request('il_id') == $il->id ? 'selected' : '' }}>{{ $il->ad }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3">
                            <button type="submit" class="btn btn-primary w-100">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10 10m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0" /><path d="M21 21l-6 -6" /></svg>
                                Filtrele
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <div class="card">
            <div class="table-responsive">
                <table class="table table-vcenter card-table">
                    <thead>
                        <tr>
                            <th>Kullanıcı</th>
                            <th>TC</th>
                            <th>Telefon</th>
                            <th>Kan Grubu</th>
                            <th>İl</th>
                            <th>Kayıt</th>
                            <th class="w-1">İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($kullanicilar as $kullanici)
                        <tr>
                            <td>
                                <div class="d-flex py-1 align-items-center">
                                    <span class="avatar me-2" style="background-image: url(https://ui-avatars.com/api/?name={{ urlencode($kullanici->ad . ' ' . $kullanici->soyad) }}&background=random)"></span>
                                    <div class="flex-fill">
                                        <div class="font-weight-medium">{{ $kullanici->ad }} {{ $kullanici->soyad }}</div>
                                        <div class="text-secondary"><small>{{ $kullanici->email }}</small></div>
                                    </div>
                                </div>
                            </td>
                            <td class="text-secondary">{{ $kullanici->tc_kimlik ?? '-' }}</td>
                            <td class="text-secondary">{{ $kullanici->telefon }}</td>
                            <td><span class="badge bg-red-lt">{{ $kullanici->kan_grubu }}</span></td>
                            <td class="text-secondary">{{ $kullanici->il_adi }}</td>
                            <td class="text-secondary">{{ \Carbon\Carbon::parse($kullanici->created_at)->format('d.m.Y') }}</td>
                            <td>
                                <div class="btn-group">
                                    <a href="{{ route('admin.kullanicilar.show', $kullanici->id) }}" class="btn btn-sm btn-ghost-secondary">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0" /><path d="M21 12c-2.4 4 -5.4 6 -9 6c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6" /></svg>
                                    </a>
                                    <a href="{{ route('admin.kullanicilar.edit', $kullanici->id) }}" class="btn btn-sm btn-ghost-secondary">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M7 7h-1a2 2 0 0 0 -2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2 -2v-1" /><path d="M20.385 6.585a2.1 2.1 0 0 0 -2.97 -2.97l-8.415 8.385v3h3l8.385 -8.415z" /><path d="M16 5l3 3" /></svg>
                                    </a>
                                    <button type="button" class="btn btn-sm btn-ghost-danger" onclick="if(confirm('Silmek istediğinizden emin misiniz?')) { document.getElementById('delete-{{ $kullanici->id }}').submit(); }">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M4 7l16 0" /><path d="M10 11l0 6" /><path d="M14 11l0 6" /><path d="M5 7l1 12a2 2 0 0 0 2 2h8a2 2 0 0 0 2 -2l1 -12" /><path d="M9 7v-3a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v3" /></svg>
                                    </button>
                                    <form id="delete-{{ $kullanici->id }}" action="{{ route('admin.kullanicilar.destroy', $kullanici->id) }}" method="POST" class="d-none">
                                        @csrf
                                        @method('DELETE')
                                    </form>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="7" class="text-center py-5">
                                <p class="text-secondary">Kullanıcı bulunamadı</p>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            @if($kullanicilar->hasPages())
            <div class="card-footer">
                {{ $kullanicilar->links() }}
            </div>
            @endif
        </div>
    </div>
</div>
@endsection
