@extends('layouts.admin')

@section('title', 'Kullanıcı Düzenle')

@section('content')
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <div class="page-pretitle">
                    Kullanıcı Yönetimi
                </div>
                <h2 class="page-title">
                    Kullanıcı Düzenle
                </h2>
            </div>
            <div class="col-auto ms-auto d-print-none">
                <a href="{{ route('admin.kullanicilar.index') }}" class="btn btn-secondary">
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M5 12l14 0" /><path d="M5 12l6 6" /><path d="M5 12l6 -6" /></svg>
                    Geri
                </a>
            </div>
        </div>
    </div>
</div>

<div class="page-body">
    <div class="container-xl">
        <div class="row row-cards">
            <div class="col-12">
                <form action="{{ route('admin.kullanicilar.update', $kullanici->id) }}" method="POST" class="card">
                    @csrf
                    @method('PUT')
                    
                    <div class="card-header">
                        <h3 class="card-title">Kullanıcı Bilgileri</h3>
                    </div>
                    
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label required">Ad</label>
                                <input type="text" name="ad" class="form-control @error('ad') is-invalid @enderror" value="{{ old('ad', $kullanici->ad) }}" required>
                                @error('ad')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label required">Soyad</label>
                                <input type="text" name="soyad" class="form-control @error('soyad') is-invalid @enderror" value="{{ old('soyad', $kullanici->soyad) }}" required>
                                @error('soyad')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label required">E-posta</label>
                                <input type="email" name="email" class="form-control @error('email') is-invalid @enderror" value="{{ old('email', $kullanici->email) }}" required>
                                @error('email')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">TC Kimlik No</label>
                                <input type="text" name="tc_kimlik" class="form-control @error('tc_kimlik') is-invalid @enderror" value="{{ old('tc_kimlik', $kullanici->tc_kimlik) }}" maxlength="11">
                                @error('tc_kimlik')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label required">Telefon</label>
                                <input type="text" name="telefon" class="form-control @error('telefon') is-invalid @enderror" value="{{ old('telefon', $kullanici->telefon) }}" required>
                                @error('telefon')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Doğum Tarihi</label>
                                <input type="date" name="dogum_tarihi" class="form-control @error('dogum_tarihi') is-invalid @enderror" value="{{ old('dogum_tarihi', $kullanici->dogum_tarihi ?? '') }}">
                                @error('dogum_tarihi')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Cinsiyet</label>
                                <select name="cinsiyet" class="form-select @error('cinsiyet') is-invalid @enderror">
                                    <option value="">Seçiniz</option>
                                    <option value="E" {{ old('cinsiyet', $kullanici->cinsiyet ?? '') == 'E' ? 'selected' : '' }}>Erkek</option>
                                    <option value="K" {{ old('cinsiyet', $kullanici->cinsiyet ?? '') == 'K' ? 'selected' : '' }}>Kadın</option>
                                </select>
                                @error('cinsiyet')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label required">Kan Grubu</label>
                                <select name="kan_grubu_id" class="form-select @error('kan_grubu_id') is-invalid @enderror" required>
                                    <option value="">Seçiniz</option>
                                    @foreach($kanGruplari as $grup)
                                        <option value="{{ $grup->id }}" {{ old('kan_grubu_id', $kullanici->kan_grubu_id) == $grup->id ? 'selected' : '' }}>{{ $grup->ad }}</option>
                                    @endforeach
                                </select>
                                @error('kan_grubu_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label required">İl</label>
                                <select name="il_id" id="il_id" class="form-select @error('il_id') is-invalid @enderror" required>
                                    <option value="">Seçiniz</option>
                                    @foreach($iller as $il)
                                        <option value="{{ $il->id }}" {{ old('il_id', $kullanici->il_id) == $il->id ? 'selected' : '' }}>{{ $il->ad }}</option>
                                    @endforeach
                                </select>
                                @error('il_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">İlçe</label>
                                <select name="ilce_id" id="ilce_id" class="form-select @error('ilce_id') is-invalid @enderror">
                                    <option value="">Seçiniz</option>
                                    @foreach($ilceler as $ilce)
                                        <option value="{{ $ilce->id }}" {{ old('ilce_id', $kullanici->ilce_id) == $ilce->id ? 'selected' : '' }}>{{ $ilce->ad }}</option>
                                    @endforeach
                                </select>
                                @error('ilce_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Yeni Şifre</label>
                                <input type="password" name="password" class="form-control @error('password') is-invalid @enderror" autocomplete="new-password">
                                <small class="form-hint">Boş bırakırsanız şifre değişmez</small>
                                @error('password')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Şifre Onayı</label>
                                <input type="password" name="password_confirmation" class="form-control" autocomplete="new-password">
                                <small class="form-hint">Şifre değiştirmek için tekrar girin</small>
                            </div>

                            <div class="col-12">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="aktif" value="1" id="aktif" {{ old('aktif', $kullanici->aktif) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="aktif">Kullanıcı Aktif</label>
                                </div>
                            </div>

                            <div class="col-12">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="sms_izni" value="1" id="sms_izni" {{ old('sms_izni', $kullanici->sms_izni) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="sms_izni">SMS İzni</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="card-footer text-end">
                        <button type="submit" class="btn btn-primary">
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M6 4h10l4 4v10a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2" /><path d="M12 14m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0" /><path d="M14 4l0 4l-6 0l0 -4" /></svg>
                            Güncelle
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.getElementById('il_id').addEventListener('change', function() {
    const ilId = this.value;
    const ilceSelect = document.getElementById('ilce_id');
    
    ilceSelect.innerHTML = '<option value="">Yükleniyor...</option>';
    
    if (ilId) {
        fetch(`/api/ilceler/${ilId}`)
            .then(response => response.json())
            .then(data => {
                ilceSelect.innerHTML = '<option value="">Seçiniz</option>';
                data.forEach(ilce => {
                    ilceSelect.innerHTML += `<option value="${ilce.id}">${ilce.ad}</option>`;
                });
            })
            .catch(error => {
                console.error('Error:', error);
                ilceSelect.innerHTML = '<option value="">Hata oluştu</option>';
            });
    } else {
        ilceSelect.innerHTML = '<option value="">Önce il seçiniz</option>';
    }
});
</script>
@endpush
@endsection
