@extends('layouts.admin')

@section('title', 'İlan Detayı')

@section('content')
@if(session('success'))
<div class="container-xl mt-3">
    <div class="alert alert-success alert-dismissible" role="alert">
        <div class="d-flex">
            <div>
                <i class="ti ti-check"></i>
            </div>
            <div>
                {{ session('success') }}
            </div>
        </div>
        <a class="btn-close" data-bs-dismiss="alert" aria-label="close"></a>
    </div>
</div>
@endif

@if(session('error'))
<div class="container-xl mt-3">
    <div class="alert alert-danger alert-dismissible" role="alert">
        <div class="d-flex">
            <div>
                <i class="ti ti-alert-circle"></i>
            </div>
            <div>
                {{ session('error') }}
            </div>
        </div>
        <a class="btn-close" data-bs-dismiss="alert" aria-label="close"></a>
    </div>
</div>
@endif

<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <div class="page-pretitle">
                    YÖNETİM PANELİ
                </div>
                <h2 class="page-title">
                    İlan Detayı
                </h2>
            </div>
        </div>
    </div>
</div>

<div class="page-body">
    <div class="container-xl">
        <div class="row row-cards">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Hasta Bilgileri</h3>
                    </div>
                    <div class="card-body">
                        <div class="datagrid">
                            <div class="datagrid-item">
                                <div class="datagrid-title">Ad Soyad</div>
                                <div class="datagrid-content">{{ $ilan->hasta_ad_soyad }}</div>
                            </div>
                            <div class="datagrid-item">
                                <div class="datagrid-title">Kan Grubu</div>
                                <div class="datagrid-content">
                                    <span class="badge bg-red-lt">{{ $ilan->kan_grubu ?? 'Belirtilmemiş' }}</span>
                                </div>
                            </div>
                            <div class="datagrid-item">
                                <div class="datagrid-title">Ünite Sayısı</div>
                                <div class="datagrid-content">{{ $ilan->unite_sayisi }} Ünite</div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-header">
                        <h3 class="card-title">İletişim Bilgileri</h3>
                    </div>
                    <div class="card-body">
                        <div class="datagrid">
                            <div class="datagrid-item">
                                <div class="datagrid-title">Telefon</div>
                                <div class="datagrid-content">{{ $ilan->irtibat_telefonu }}</div>
                            </div>
                            <div class="datagrid-item">
                                <div class="datagrid-title">İlan Sahibi</div>
                                <div class="datagrid-content">{{ $ilan->kullanici_adi ?? 'Bilinmiyor' }}</div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-header">
                        <h3 class="card-title">Hastane Bilgileri</h3>
                    </div>
                    <div class="card-body">
                        <div class="datagrid">
                            <div class="datagrid-item">
                                <div class="datagrid-title">Hastane</div>
                                <div class="datagrid-content">{{ $ilan->hastane_adi ?? 'Belirtilmemiş' }}</div>
                            </div>
                            <div class="datagrid-item">
                                <div class="datagrid-title">Hastane Adresi</div>
                                <div class="datagrid-content">{{ $ilan->hastane_adresi ?? 'Belirtilmemiş' }}</div>
                            </div>
                            <div class="datagrid-item">
                                <div class="datagrid-title">Konum</div>
                                <div class="datagrid-content">{{ $ilan->hastane_ilce ?? ($ilan->ilce_adi ?? '') }} / {{ $ilan->hastane_il ?? ($ilan->il_adi ?? '') }}</div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-header">
                        <h3 class="card-title">İlan Durumu</h3>
                    </div>
                    <div class="card-body">
                        <div class="datagrid">
                            <div class="datagrid-item">
                                <div class="datagrid-title">Durum</div>
                                <div class="datagrid-content">
                                    @if($ilan->durum == 'aktif')
                                        <span class="badge bg-success-lt">Aktif</span>
                                    @elseif($ilan->durum == 'tamamlandi')
                                        <span class="badge bg-info-lt">Tamamlandı</span>
                                    @elseif($ilan->durum == 'iptal')
                                        <span class="badge bg-danger-lt">İptal</span>
                                    @elseif($ilan->durum == 'pasif')
                                        <span class="badge bg-secondary-lt">Pasif</span>
                                    @else
                                        <span class="badge bg-warning-lt">Süresi Doldu</span>
                                    @endif
                                </div>
                            </div>
                            <div class="datagrid-item">
                                <div class="datagrid-title">İlan Tarihi</div>
                                <div class="datagrid-content">{{ \Carbon\Carbon::parse($ilan->created_at)->format('d.m.Y H:i') }}</div>
                            </div>
                            <div class="datagrid-item">
                                <div class="datagrid-title">Son Güncelleme</div>
                                <div class="datagrid-content">{{ \Carbon\Carbon::parse($ilan->updated_at)->format('d.m.Y H:i') }}</div>
                            </div>
                        </div>
                    </div>
                </div>

                @if($ilan->notlar)
                <div class="card mt-3">
                    <div class="card-header">
                        <h3 class="card-title">Açıklama/Notlar</h3>
                    </div>
                    <div class="card-body">
                        <p class="text-secondary">{{ $ilan->notlar }}</p>
                    </div>
                </div>
                @endif
            </div>

            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Paylaşım Linki</h3>
                    </div>
                    <div class="card-body">
                        <p class="text-secondary mb-3">SMS için kısa link (72 saat geçerli):</p>
                        <div class="mb-3">
                            <input type="text" class="form-control" id="ilanLink" value="{{ $ilanLink }}" readonly>
                        </div>
                        @if($ilan->link_gecerlilik_tarihi)
                        <div class="mb-3">
                            <small class="text-muted">
                                <i class="ti ti-clock"></i>
                                Geçerlilik: {{ \Carbon\Carbon::parse($ilan->link_gecerlilik_tarihi)->format('d.m.Y H:i') }}
                            </small>
                        </div>
                        @endif
                        <button class="btn btn-primary w-100 mb-2" onclick="copyToClipboard()">
                            <i class="ti ti-copy"></i>
                            Linki Kopyala
                        </button>
                        <a href="{{ $ilanLink }}" target="_blank" class="btn btn-outline-primary w-100">
                            <i class="ti ti-external-link"></i>
                            Linki Aç
                        </a>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-header">
                        <h3 class="card-title">SMS Bilgileri</h3>
                    </div>
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="me-3">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-lg text-blue" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M3 20l1.3 -3.9a9 8 0 1 1 3.4 2.9l-4.7 1" /><path d="M12 12l0 .01" /><path d="M8 12l0 .01" /><path d="M16 12l0 .01" /></svg>
                            </div>
                            <div>
                                <div class="h2 mb-0">{{ $smsSayisi }}</div>
                                <div class="text-secondary">kişiye SMS gönderildi</div>
                            </div>
                        </div>
                        @if($smsSayisi > 0)
                        <div class="mt-3">
                            <a href="{{ route('admin.sms.raporlar') }}" class="btn btn-outline-primary btn-sm w-100">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0" /><path d="M12 9h.01" /><path d="M11 12h1v4h1" /></svg>
                                SMS Detaylarını Gör
                            </a>
                        </div>
                        @endif
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-header">
                        <h3 class="card-title">İşlemler</h3>
                    </div>
                    <div class="card-body">
                        <a href="{{ route('admin.kanilanlari.index') }}" class="btn btn-outline-secondary w-100 mb-2">
                            <i class="ti ti-arrow-left"></i>
                            Listeye Dön
                        </a>
                        @if($ilan->durum == 'aktif')
                        <button class="btn btn-warning w-100 mb-2" data-bs-toggle="modal" data-bs-target="#durumGuncelleModal">
                            <i class="ti ti-edit"></i>
                            Durumu Güncelle
                        </button>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Durum Güncelleme Modal -->
<div class="modal modal-blur fade" id="durumGuncelleModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">İlan Durumunu Güncelle</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('admin.kan-ilanlari.update-status', $ilan->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Durum</label>
                        <select name="durum" class="form-select" required>
                            <option value="aktif" {{ $ilan->durum == 'aktif' ? 'selected' : '' }}>Aktif</option>
                            <option value="pasif" {{ $ilan->durum == 'pasif' ? 'selected' : '' }}>Pasif</option>
                            <option value="tamamlandi" {{ $ilan->durum == 'tamamlandi' ? 'selected' : '' }}>Tamamlandı</option>
                            <option value="iptal" {{ $ilan->durum == 'iptal' ? 'selected' : '' }}>İptal</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-link link-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="submit" class="btn btn-primary">Güncelle</button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
function copyToClipboard() {
    const copyText = document.getElementById("ilanLink");
    copyText.select();
    copyText.setSelectionRange(0, 99999);
    
    navigator.clipboard.writeText(copyText.value).then(function() {
        const btn = event.target.closest('button');
        const originalHtml = btn.innerHTML;
        btn.innerHTML = '<i class="ti ti-check"></i>Kopyalandı!';
        btn.classList.remove('btn-primary');
        btn.classList.add('btn-success');
        
        setTimeout(function() {
            btn.innerHTML = originalHtml;
            btn.classList.remove('btn-success');
            btn.classList.add('btn-primary');
        }, 2000);
    }, function(err) {
        alert('Link kopyalanamadı: ' + err);
    });
}
</script>
@endpush
@endsection
