@extends('layouts.admin')

@section('title', 'İlan Önizleme')

@section('content')
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <h2 class="page-title">İlan Önizleme</h2>
                <div class="page-pretitle">Kan İlanı Yönetimi</div>
            </div>
        </div>
    </div>
</div>

<div class="page-body">
    <div class="container-xl">
        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-status-top bg-red"></div>
                    <div class="card-header">
                        <h3 class="card-title">İlan Önizleme</h3>
                    </div>
                    <div class="card-body">
                        <!-- Hasta Bilgileri -->
                        <div class="mb-4">
                            <h4 class="text-muted mb-3">Hasta Bilgileri</h4>
                            <div class="row">
                                <div class="col-md-6">
                                    <label class="form-label text-muted">Ad Soyad</label>
                                    <div class="h3">{{ $kullaniciBilgi->ad }} {{ $kullaniciBilgi->soyad }}</div>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label text-muted">Telefon</label>
                                    <div class="h3">{{ $kullaniciBilgi->telefon }}</div>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <!-- İlan Detayları -->
                        <div class="mb-4">
                            <h4 class="text-muted mb-3">İlan Detayları</h4>
                            <div class="row">
                                <div class="col-md-4">
                                    <label class="form-label text-muted">Kan Grubu</label>
                                    <div class="h2">
                                        <span class="badge bg-red-lt" style="font-size: 1.5rem;">
                                            {{ $kanGrubu->ad }}
                                        </span>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label text-muted">Ünite Sayısı</label>
                                    <div class="h2">{{ $validated['unite_sayisi'] }} Ünite</div>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label text-muted">Bağış Türü</label>
                                    <div>
                                        @if($validated['bagis_turu'] == 'kan_unitesi')
                                            <span class="badge bg-blue">Kan Ünitesi</span>
                                        @else
                                            <span class="badge bg-purple">Canlı Bağışçı</span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            @if($validated['ihtiyac_tarihi'])
                            <div class="row mt-3">
                                <div class="col-md-6">
                                    <label class="form-label text-muted">İhtiyaç Tarihi</label>
                                    <div>{{ \Carbon\Carbon::parse($validated['ihtiyac_tarihi'])->format('d.m.Y') }}
                                        @if($validated['ihtiyac_saati'])
                                            <span class="badge bg-gray-lt ms-1">{{ $validated['ihtiyac_saati'] }}</span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            @endif
                        </div>

                        <hr>

                        <!-- Hastane Bilgileri -->
                        <div class="mb-4">
                            <h4 class="text-muted mb-3">Hastane Bilgileri</h4>
                            <div class="row">
                                <div class="col-md-12 mb-2">
                                    <label class="form-label text-muted">Hastane</label>
                                    <div>{{ $validated['hastane_adi'] }}</div>
                                </div>
                                <div class="col-md-12 mb-2">
                                    <label class="form-label text-muted">Adres</label>
                                    <div>{{ $validated['hastane_adresi'] }}</div>
                                </div>
                                <div class="col-md-12">
                                    <label class="form-label text-muted">Konum</label>
                                    <div>{{ $validated['hastane_ilce'] }} / {{ $validated['hastane_il'] }}</div>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <!-- İletişim Bilgileri -->
                        <div class="mb-4">
                            <h4 class="text-muted mb-3">İletişim Bilgileri</h4>
                            <div class="row">
                                <div class="col-md-6">
                                    <label class="form-label text-muted">İrtibat Telefonu</label>
                                    <div>
                                        <a href="tel:{{ $validated['irtibat_telefonu'] }}" class="btn btn-success">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M5 4h4l2 5l-2.5 1.5a11 11 0 0 0 5 5l1.5 -2.5l5 2v4a2 2 0 0 1 -2 2a16 16 0 0 1 -15 -15a2 2 0 0 1 2 -2"></path></svg>
                                            {{ $validated['irtibat_telefonu'] }}
                                        </a>
                                    </div>
                                </div>
                                @if($validated['yakin_kisi_telefon'])
                                <div class="col-md-6">
                                    <label class="form-label text-muted">Yakın Kişi Telefonu</label>
                                    <div>
                                        <a href="tel:{{ $validated['yakin_kisi_telefon'] }}" class="btn btn-outline-success">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M5 4h4l2 5l-2.5 1.5a11 11 0 0 0 5 5l1.5 -2.5l5 2v4a2 2 0 0 1 -2 2a16 16 0 0 1 -15 -15a2 2 0 0 1 2 -2"></path></svg>
                                            {{ $validated['yakin_kisi_telefon'] }}
                                        </a>
                                    </div>
                                </div>
                                @endif
                            </div>
                        </div>

                        @if($validated['notlar'])
                        <hr>
                        <div class="mb-4">
                            <h4 class="text-muted mb-3">Notlar / Açıklama</h4>
                            <div class="text-muted">{{ $validated['notlar'] }}</div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card sticky-top">
                    <div class="card-body">
                        <h3 class="card-title">İşlemler</h3>
                        
                        <!-- Onayla ve Kaydet -->
                        <form action="{{ route('admin.kan-ilanlari.store') }}" method="POST">
                            @csrf
                            <!-- Hidden fields -->
                            <input type="hidden" name="kullanici_secim" value="{{ $validated['kullanici_secim'] }}">
                            @if($validated['kullanici_secim'] == 'mevcut')
                                <input type="hidden" name="kullanici_id" value="{{ $validated['kullanici_id'] }}">
                            @else
                                <input type="hidden" name="hizli_ad" value="{{ $validated['hizli_ad'] }}">
                                <input type="hidden" name="hizli_soyad" value="{{ $validated['hizli_soyad'] }}">
                                <input type="hidden" name="hizli_telefon" value="{{ $validated['hizli_telefon'] }}">
                                <input type="hidden" name="hizli_email" value="{{ $validated['hizli_email'] }}">
                                <input type="hidden" name="hizli_kan_grubu_id" value="{{ $validated['hizli_kan_grubu_id'] ?? '' }}">
                                <input type="hidden" name="hizli_tc_kimlik" value="{{ $validated['hizli_tc_kimlik'] ?? '' }}">
                                <input type="hidden" name="hizli_il_id" value="{{ $validated['hizli_il_id'] ?? '' }}">
                                <input type="hidden" name="hizli_ilce_id" value="{{ $validated['hizli_ilce_id'] ?? '' }}">
                            @endif
                            <input type="hidden" name="kan_grubu_id" value="{{ $validated['kan_grubu_id'] }}">
                            <input type="hidden" name="unite_sayisi" value="{{ $validated['unite_sayisi'] }}">
                            <input type="hidden" name="bagis_turu" value="{{ $validated['bagis_turu'] }}">
                            <input type="hidden" name="ihtiyac_tarihi" value="{{ $validated['ihtiyac_tarihi'] }}">
                            <input type="hidden" name="ihtiyac_saati" value="{{ $validated['ihtiyac_saati'] }}">
                            <input type="hidden" name="hastane_adi" value="{{ $validated['hastane_adi'] }}">
                            <input type="hidden" name="hastane_adresi" value="{{ $validated['hastane_adresi'] }}">
                            <input type="hidden" name="hastane_il" value="{{ $validated['hastane_il'] }}">
                            <input type="hidden" name="hastane_ilce" value="{{ $validated['hastane_ilce'] }}">
                            <input type="hidden" name="irtibat_telefonu" value="{{ $validated['irtibat_telefonu'] }}">
                            <input type="hidden" name="yakin_kisi_telefon" value="{{ $validated['yakin_kisi_telefon'] }}">
                            <input type="hidden" name="notlar" value="{{ $validated['notlar'] }}">

                            <div class="d-grid gap-2">
                                <button type="submit" class="btn btn-success">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M5 12l5 5l10 -10" /></svg>
                                    Onayla ve Yayınla
                                </button>
                                <a href="{{ route('admin.kan-ilanlari.create') }}" class="btn btn-secondary">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M11 7l-5 5l5 5" /><path d="M17 7l-5 5l5 5" /></svg>
                                    Düzenle
                                </a>
                            </div>
                        </form>

                        <hr>
                        <div class="alert alert-info mb-0">
                            <strong>Bilgi:</strong> İlanı onayladığınızda sistem otomatik olarak aktif durumda yayınlayacaktır.
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
