@extends('layouts.admin')

@section('title', 'Kan İlanları Yönetimi')

@section('content')
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <h2 class="page-title">
                    Kan İlanları Yönetimi
                </h2>
                <div class="page-pretitle">
                    Kurum Kan İlanları
                </div>
            </div>
            <div class="col-auto ms-auto d-print-none">
                <a href="{{ route('admin.kan-ilanlari.create') }}" class="btn btn-primary">
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 5l0 14" /><path d="M5 12l14 0" /></svg>
                    Yeni İlan Oluştur
                </a>
            </div>
        </div>
    </div>
</div>

<div class="page-body">
    <div class="container-xl">
        <div class="row row-cards">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Kan İlanları Listesi</h3>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-vcenter card-table">
                            <thead>
                                <tr>
                                    <th>Hasta Bilgisi</th>
                                    <th>Hastane</th>
                                    <th>İletişim</th>
                                    <th class="text-center">Kan Grubu</th>
                                    <th class="text-center">Ünite</th>
                                    <th class="text-center">Durum</th>
                                    <th class="text-center">İlan Tarihi</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($ilanlar as $ilan)
                                <tr>
                                    <td>
                                        <div class="d-flex py-1 align-items-center">
                                            <div class="flex-fill">
                                                <div class="font-weight-medium">{{ $ilan->hasta_ad_soyad }}</div>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="text-secondary">
                                        {{ $ilan->hastane_adi ?? '-' }}
                                    </td>
                                    <td class="text-secondary">
                                        {{ $ilan->irtibat_telefonu }}
                                    </td>
                                    <td class="text-center">
                                        <span class="badge bg-red-lt">{{ $ilan->kan_grubu ?? '-' }}</span>
                                    </td>
                                    <td class="text-center">
                                        <span class="text-secondary">{{ $ilan->unite_sayisi }} Ünite</span>
                                    </td>
                                    <td class="text-center">
                                        @if($ilan->durum == 'aktif')
                                            <span class="badge bg-success-lt">Aktif</span>
                                        @elseif($ilan->durum == 'tamamlandi')
                                            <span class="badge bg-info-lt">Tamamlandı</span>
                                        @elseif($ilan->durum == 'iptal')
                                            <span class="badge bg-danger-lt">İptal</span>
                                        @elseif($ilan->durum == 'pasif')
                                            <span class="badge bg-secondary-lt">Pasif</span>
                                        @else
                                            <span class="badge bg-warning-lt">Süresi Doldu</span>
                                        @endif
                                    </td>
                                    <td class="text-center text-secondary">
                                        {{ \Carbon\Carbon::parse($ilan->created_at)->format('d.m.Y H:i') }}
                                    </td>
                                    <td class="text-end">
                                        <a href="{{ route('admin.kan-ilanlari.show', $ilan->id) }}" class="btn btn-sm btn-primary">
                                            <i class="ti ti-eye"></i>
                                            Detay
                                        </a>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="8" class="text-center py-4 text-secondary">
                                        Henüz kan ilanı bulunmamaktadır.
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    @if($ilanlar->hasPages())
                    <div class="card-footer d-flex align-items-center">
                        {{ $ilanlar->links() }}
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
