@extends('layouts.admin')

@section('title', 'Yeni Kan İlanı Oluştur')

@push('styles')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />
<style>
.select2-container--bootstrap-5 .select2-selection {
    min-height: calc(1.5em + 0.75rem + 2px);
    padding: 0.375rem 0.75rem;
    font-size: 0.875rem;
    border: 1px solid #d9dbde;
}
</style>
@endpush

@section('content')
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <h2 class="page-title">Yeni Kan İlanı Oluştur</h2>
                <div class="page-pretitle">Kan İlanı Yönetimi</div>
            </div>
            <div class="col-auto ms-auto d-print-none">
                <a href="{{ route('admin.kanilanlari.index') }}" class="btn btn-secondary">
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M5 12l14 0" /><path d="M5 12l6 6" /><path d="M5 12l6 -6" /></svg>
                    Geri
                </a>
            </div>
        </div>
    </div>
</div>

<div class="page-body">
    <div class="container-xl">
        <form action="{{ route('admin.kan-ilanlari.preview') }}" method="POST" id="ilanForm">
            @csrf
            <div class="row">
                <div class="col-md-8">
                    <!-- Kullanıcı Seçimi -->
                    <div class="card mb-3">
                        <div class="card-header">
                            <h3 class="card-title">1. Kullanıcı Bilgileri</h3>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="form-label">Kullanıcı Seçimi</label>
                                <div class="d-flex gap-2">
                                    <button type="button" class="btn btn-primary flex-fill" id="selectExistingBtn">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M8 7a4 4 0 1 0 8 0a4 4 0 0 0 -8 0" /><path d="M6 21v-2a4 4 0 0 1 4 -4h4a4 4 0 0 1 4 4v2" /></svg>
                                        Mevcut Kullanıcı Seç
                                    </button>
                                    <button type="button" class="btn btn-success flex-fill" data-bs-toggle="modal" data-bs-target="#hizliKisiModal">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 5l0 14" /><path d="M5 12l14 0" /></svg>
                                        Hızlı Kişi Ekle
                                    </button>
                                </div>
                            </div>

                            <input type="hidden" name="kullanici_secim" id="kullanici_secim" value="mevcut">

                            <!-- Mevcut Kullanıcı Seçimi -->
                            <div id="mevcutKullaniciDiv">
                                <div class="mb-3">
                                    <label class="form-label required">Kullanıcı</label>
                                    <select name="kullanici_id" id="kullanici_id" class="form-select @error('kullanici_id') is-invalid @enderror">
                                        <option value="">Kullanıcı seçiniz...</option>
                                        @foreach($kullanicilar as $kullanici)
                                            <option value="{{ $kullanici->id }}" 
                                                    data-kan-grubu="{{ $kullanici->kan_grubu_id }}"
                                                    data-telefon="{{ $kullanici->telefon }}"
                                                    {{ old('kullanici_id') == $kullanici->id ? 'selected' : '' }}>
                                                {{ $kullanici->ad }} {{ $kullanici->soyad }} 
                                                @if($kullanici->kan_grubu)
                                                    ({{ $kullanici->kan_grubu }})
                                                @endif
                                                - {{ $kullanici->telefon }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('kullanici_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- Seçilen Kullanıcı Bilgisi -->
                            <div id="secilenKullaniciDiv" style="display: none;">
                                <div class="alert alert-success d-flex justify-content-between align-items-center">
                                    <div>
                                        <strong id="secilenKullaniciAd"></strong>
                                        <div class="text-muted small" id="secilenKullaniciDetay"></div>
                                    </div>
                                    <button type="button" class="btn btn-sm btn-outline-danger" id="kullaniciTemizleBtn">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M18 6l-12 12" /><path d="M6 6l12 12" /></svg>
                                        Değiştir
                                    </button>
                                </div>
                                <input type="hidden" name="kullanici_id" id="hidden_kullanici_id">
                                <input type="hidden" name="hizli_ad" id="hidden_hizli_ad">
                                <input type="hidden" name="hizli_soyad" id="hidden_hizli_soyad">
                                <input type="hidden" name="hizli_telefon" id="hidden_hizli_telefon">
                                <input type="hidden" name="hizli_email" id="hidden_hizli_email">
                                <input type="hidden" name="hizli_kan_grubu_id" id="hidden_hizli_kan_grubu_id">
                                <input type="hidden" name="hizli_tc_kimlik" id="hidden_hizli_tc_kimlik">
                                <input type="hidden" name="hizli_il_id" id="hidden_hizli_il_id">
                                <input type="hidden" name="hizli_ilce_id" id="hidden_hizli_ilce_id">
                            </div>
                        </div>
                    </div>

                    <!-- İlan Detayları -->
                    <div class="card mb-3">
                        <div class="card-header">
                            <h3 class="card-title">2. İlan Detayları</h3>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label required">Kan Grubu</label>
                                    <select name="kan_grubu_id" id="kan_grubu_id" class="form-select @error('kan_grubu_id') is-invalid @enderror" required>
                                        <option value="">Seçiniz...</option>
                                        @foreach($kanGruplari as $grup)
                                            <option value="{{ $grup->id }}" {{ old('kan_grubu_id') == $grup->id ? 'selected' : '' }}>
                                                {{ $grup->ad }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('kan_grubu_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label required">Ünite Sayısı</label>
                                    <input type="number" name="unite_sayisi" class="form-control @error('unite_sayisi') is-invalid @enderror" value="{{ old('unite_sayisi', 1) }}" min="1" required>
                                    @error('unite_sayisi')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label required">Bağış Türü</label>
                                    <select name="bagis_turu" class="form-select @error('bagis_turu') is-invalid @enderror" required>
                                        <option value="kan_unitesi" {{ old('bagis_turu') == 'kan_unitesi' ? 'selected' : '' }}>Kan Ünitesi</option>
                                        <option value="canli_bagisci" {{ old('bagis_turu') == 'canli_bagisci' ? 'selected' : '' }}>Canlı Bağışçı</option>
                                    </select>
                                    @error('bagis_turu')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label class="form-label">İhtiyaç Tarihi</label>
                                    <input type="date" name="ihtiyac_tarihi" class="form-control @error('ihtiyac_tarihi') is-invalid @enderror" value="{{ old('ihtiyac_tarihi') }}">
                                    @error('ihtiyac_tarihi')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label class="form-label">Saat</label>
                                    <input type="time" name="ihtiyac_saati" class="form-control @error('ihtiyac_saati') is-invalid @enderror" value="{{ old('ihtiyac_saati') }}">
                                    @error('ihtiyac_saati')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Hastane Bilgileri -->
                    <div class="card mb-3">
                        <div class="card-header">
                            <h3 class="card-title">3. Hastane Bilgileri</h3>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <label class="form-label required">Hastane Adı</label>
                                    <input type="text" name="hastane_adi" class="form-control @error('hastane_adi') is-invalid @enderror" value="{{ old('hastane_adi') }}" required>
                                    @error('hastane_adi')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-12 mb-3">
                                    <label class="form-label required">Hastane Adresi</label>
                                    <input type="text" name="hastane_adresi" class="form-control @error('hastane_adresi') is-invalid @enderror" value="{{ old('hastane_adresi') }}" required>
                                    @error('hastane_adresi')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label required">Hastane İl</label>
                                    <input type="text" name="hastane_il" class="form-control @error('hastane_il') is-invalid @enderror" value="{{ old('hastane_il') }}" required>
                                    @error('hastane_il')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label required">Hastane İlçe</label>
                                    <input type="text" name="hastane_ilce" class="form-control @error('hastane_ilce') is-invalid @enderror" value="{{ old('hastane_ilce') }}" required>
                                    @error('hastane_ilce')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- İletişim Bilgileri -->
                    <div class="card mb-3">
                        <div class="card-header">
                            <h3 class="card-title">4. İletişim Bilgileri</h3>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label required">İrtibat Telefonu</label>
                                    <input type="text" name="irtibat_telefonu" id="irtibat_telefonu" class="form-control @error('irtibat_telefonu') is-invalid @enderror" value="{{ old('irtibat_telefonu') }}" placeholder="5XXXXXXXXX" required>
                                    @error('irtibat_telefonu')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Yakın Kişi Telefonu</label>
                                    <input type="text" name="yakin_kisi_telefon" class="form-control @error('yakin_kisi_telefon') is-invalid @enderror" value="{{ old('yakin_kisi_telefon') }}" placeholder="5XXXXXXXXX">
                                    <small class="form-hint">Alternatif iletişim numarası (opsiyonel)</small>
                                    @error('yakin_kisi_telefon')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-12 mb-3">
                                    <label class="form-label">Notlar / Açıklama</label>
                                    <textarea name="notlar" class="form-control @error('notlar') is-invalid @enderror" rows="3">{{ old('notlar') }}</textarea>
                                    <small class="form-hint">İlanla ilgili ek bilgiler varsa buraya yazabilirsiniz.</small>
                                    @error('notlar')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="card sticky-top">
                        <div class="card-body">
                            <h3 class="card-title">İşlemler</h3>
                            <div class="d-grid gap-2">
                                <button type="submit" class="btn btn-primary">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0" /><path d="M21 12c-2.4 4 -5.4 6 -9 6c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6" /></svg>
                                    Önizleme
                                </button>
                                <a href="{{ route('admin.kanilanlari.index') }}" class="btn btn-secondary">
                                    İptal
                                </a>
                            </div>
                            <hr>
                            <div class="text-muted small">
                                <p><strong>Bilgi:</strong></p>
                                <ul class="mb-0">
                                    <li>Önizlemede ilanı kontrol edebilirsiniz</li>
                                    <li>Admin ilanlarında SMS onayı gerekmez</li>
                                    <li>İlan otomatik olarak aktif durumda oluşturulur</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Hızlı Kişi Ekle Modal -->
<div class="modal modal-blur fade" id="hizliKisiModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Hızlı Kişi Ekle</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label required">Ad</label>
                        <input type="text" id="modal_hizli_ad" class="form-control" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label required">Soyad</label>
                        <input type="text" id="modal_hizli_soyad" class="form-control" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label required">Kan Grubu</label>
                        <select id="modal_hizli_kan_grubu_id" class="form-select" required>
                            <option value="">Seçiniz...</option>
                            @foreach($kanGruplari as $grup)
                                <option value="{{ $grup->id }}">{{ $grup->ad }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label required">Telefon</label>
                        <input type="text" id="modal_hizli_telefon" class="form-control" placeholder="5XXXXXXXXX" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label required">İl</label>
                        <select id="modal_hizli_il_id" class="form-select" required>
                            <option value="">Seçiniz...</option>
                            @foreach($iller as $il)
                                <option value="{{ $il->id }}">{{ $il->ad }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label required">İlçe</label>
                        <select id="modal_hizli_ilce_id" class="form-select" required disabled>
                            <option value="">Önce il seçiniz...</option>
                        </select>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">TC Kimlik</label>
                        <input type="text" id="modal_hizli_tc_kimlik" class="form-control" maxlength="11" placeholder="11 haneli TC kimlik no">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">E-posta</label>
                        <input type="email" id="modal_hizli_email" class="form-control">
                    </div>
                </div>
                <div class="alert alert-info">
                    <strong>Bilgi:</strong> Hızlı eklenen kullanıcı otomatik olarak sisteme kaydedilecek ve varsayılan şifre: <strong>123456</strong> olacaktır.
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                <button type="button" class="btn btn-success" id="hizliKisiKaydetBtn">
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M5 12l5 5l10 -10" /></svg>
                    Kaydet ve Devam Et
                </button>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const mevcutKullaniciDiv = document.getElementById('mevcutKullaniciDiv');
    const secilenKullaniciDiv = document.getElementById('secilenKullaniciDiv');
    const kullaniciSelect = document.getElementById('kullanici_id');
    const kanGrubuSelect = document.getElementById('kan_grubu_id');
    const irtibatTelefon = document.getElementById('irtibat_telefonu');

    // Select2 başlat
    $('#kullanici_id').select2({
        theme: 'bootstrap-5',
        placeholder: 'Kullanıcı arayın...',
        allowClear: true,
        language: {
            noResults: function() {
                return "Sonuç bulunamadı";
            },
            searching: function() {
                return "Aranıyor...";
            }
        }
    });

    // Mevcut kullanıcı seç butonu
    document.getElementById('selectExistingBtn').addEventListener('click', function() {
        mevcutKullaniciDiv.style.display = 'block';
        secilenKullaniciDiv.style.display = 'none';
        document.getElementById('kullanici_secim').value = 'mevcut';
    });

    // Kullanıcı seçildiğinde
    $('#kullanici_id').on('select2:select', function(e) {
        const selectedOption = e.params.data.element;
        const kanGrubuId = selectedOption.getAttribute('data-kan-grubu');
        const telefon = selectedOption.getAttribute('data-telefon');
        
        // Hidden inputları doldur
        document.getElementById('hidden_kullanici_id').value = selectedOption.value;
        
        // Görsel bilgileri güncelle
        document.getElementById('secilenKullaniciAd').textContent = selectedOption.text.split(' - ')[0];
        document.getElementById('secilenKullaniciDetay').textContent = telefon;
        
        // İlan formunu doldur
        if (kanGrubuId) kanGrubuSelect.value = kanGrubuId;
        if (telefon) irtibatTelefon.value = telefon;
        
        // Görselleri değiştir
        mevcutKullaniciDiv.style.display = 'none';
        secilenKullaniciDiv.style.display = 'block';
    });

    // Kullanıcı temizle butonu
    document.getElementById('kullaniciTemizleBtn').addEventListener('click', function() {
        $('#kullanici_id').val(null).trigger('change');
        document.getElementById('hidden_kullanici_id').value = '';
        mevcutKullaniciDiv.style.display = 'block';
        secilenKullaniciDiv.style.display = 'none';
    });

    // İl seçildiğinde ilçeleri getir
    document.getElementById('modal_hizli_il_id').addEventListener('change', function() {
        const ilId = this.value;
        const ilceSelect = document.getElementById('modal_hizli_ilce_id');
        
        if (ilId) {
            fetch(`/api/ilceler/${ilId}`)
                .then(response => response.json())
                .then(data => {
                    ilceSelect.innerHTML = '<option value="">Seçiniz...</option>';
                    data.forEach(ilce => {
                        ilceSelect.innerHTML += `<option value="${ilce.id}">${ilce.ad}</option>`;
                    });
                    ilceSelect.disabled = false;
                })
                .catch(error => {
                    console.error('İlçeler yüklenirken hata:', error);
                    ilceSelect.innerHTML = '<option value="">Hata oluştu</option>';
                });
        } else {
            ilceSelect.innerHTML = '<option value="">Önce il seçiniz...</option>';
            ilceSelect.disabled = true;
        }
    });

    // Hızlı kişi kaydet butonu
    document.getElementById('hizliKisiKaydetBtn').addEventListener('click', function() {
        // Zorunlu alanları kontrol et
        const ad = document.getElementById('modal_hizli_ad').value.trim();
        const soyad = document.getElementById('modal_hizli_soyad').value.trim();
        const kanGrubu = document.getElementById('modal_hizli_kan_grubu_id').value;
        const telefon = document.getElementById('modal_hizli_telefon').value.trim();
        const il = document.getElementById('modal_hizli_il_id').value;
        const ilce = document.getElementById('modal_hizli_ilce_id').value;
        const email = document.getElementById('modal_hizli_email').value.trim();
        const tc = document.getElementById('modal_hizli_tc_kimlik').value.trim();
        
        if (!ad || !soyad || !kanGrubu || !telefon || !il || !ilce) {
            alert('Lütfen tüm zorunlu alanları doldurunuz!');
            return;
        }
        
        // Hidden inputları doldur
        document.getElementById('kullanici_secim').value = 'yeni';
        document.getElementById('hidden_hizli_ad').value = ad;
        document.getElementById('hidden_hizli_soyad').value = soyad;
        document.getElementById('hidden_hizli_telefon').value = telefon;
        document.getElementById('hidden_hizli_email').value = email;
        document.getElementById('hidden_hizli_kan_grubu_id').value = kanGrubu;
        document.getElementById('hidden_hizli_tc_kimlik').value = tc;
        document.getElementById('hidden_hizli_il_id').value = il;
        document.getElementById('hidden_hizli_ilce_id').value = ilce;
        
        // Kan grubu ve telefonu ilan formuna doldur
        kanGrubuSelect.value = kanGrubu;
        irtibatTelefon.value = telefon;
        
        // Seçilen kullanıcı bilgilerini göster
        const kanGrubuText = document.getElementById('modal_hizli_kan_grubu_id').options[document.getElementById('modal_hizli_kan_grubu_id').selectedIndex].text;
        document.getElementById('secilenKullaniciAd').textContent = `${ad} ${soyad} (Yeni Kullanıcı)`;
        document.getElementById('secilenKullaniciDetay').textContent = `${kanGrubuText} - ${telefon}`;
        
        mevcutKullaniciDiv.style.display = 'none';
        secilenKullaniciDiv.style.display = 'block';
        
        // Modalı kapat
        bootstrap.Modal.getInstance(document.getElementById('hizliKisiModal')).hide();
    });
});
</script>
@endpush
@endsection
