@extends('layouts.admin')

@section('title', 'Anasayfa')

@section('content')
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <h2 class="page-title">
                    Dashboard
                </h2>
                <div class="page-pretitle">
                    Genel Bakış
                </div>
            </div>
        </div>
    </div>
</div>

<div class="page-body">
    <div class="container-xl">
        <!-- İstatistik Kartları -->
        <div class="row row-deck row-cards mb-3">
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="subheader">Toplam Kullanıcı</div>
                        </div>
                        <div class="h1 mb-3">{{ $stats['toplam_kullanici'] }}</div>
                        <div class="d-flex mb-2">
                            <div>Aktif: {{ $stats['aktif_kullanici'] }}</div>
                        </div>
                        <div class="progress progress-sm">
                            <div class="progress-bar bg-primary" style="width: {{ $stats['toplam_kullanici'] > 0 ? ($stats['aktif_kullanici'] / $stats['toplam_kullanici'] * 100) : 0 }}%" role="progressbar"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="subheader">Toplam İlanlar</div>
                        </div>
                        <div class="h1 mb-3">{{ $stats['toplam_ilan'] }}</div>
                        <div class="d-flex mb-2">
                            <div>Aktif: {{ $stats['aktif_ilan'] }}</div>
                        </div>
                        <div class="progress progress-sm">
                            <div class="progress-bar bg-red" style="width: {{ $stats['toplam_ilan'] > 0 ? ($stats['aktif_ilan'] / $stats['toplam_ilan'] * 100) : 0 }}%" role="progressbar"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="subheader">Bugünkü İlanlar</div>
                        </div>
                        <div class="h1 mb-3">{{ $stats['bugun_ilan'] }}</div>
                        <div class="d-flex mb-2">
                            <div class="text-secondary">Bugün oluşturuldu</div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="subheader">SMS Gönderimi</div>
                        </div>
                        <div class="h1 mb-3">{{ $stats['bu_ay_sms'] }}</div>
                        <div class="d-flex mb-2">
                            <div class="text-secondary">Bu ay / Toplam: {{ $stats['toplam_sms'] }}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Bugünkü İlanlar Tablosu -->
        <div class="row row-cards mb-3">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Bugünkü İlanlar</h3>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-vcenter card-table">
                            <thead>
                                <tr>
                                    <th>Kullanıcı</th>
                                    <th>Kan Grubu</th>
                                    <th>İl</th>
                                    <th>Durum</th>
                                    <th>Saat</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($bugunIlanlar as $ilan)
                                <tr>
                                    <td>
                                        <div class="d-flex py-1 align-items-center">
                                            <span class="avatar me-2" style="background-image: url(https://ui-avatars.com/api/?name={{ urlencode($ilan->kullanici_ad . ' ' . $ilan->kullanici_soyad) }}&background=random&size=40)"></span>
                                            <div class="flex-fill">
                                                <div class="font-weight-medium">{{ $ilan->kullanici_ad }} {{ $ilan->kullanici_soyad }}</div>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge bg-red-lt">{{ $ilan->kan_grubu }}</span>
                                    </td>
                                    <td class="text-secondary">
                                        {{ $ilan->il_adi }}
                                    </td>
                                    <td>
                                        @if($ilan->durum == 'aktif')
                                            <span class="badge bg-success-lt">Aktif</span>
                                        @else
                                            <span class="badge bg-secondary-lt">{{ ucfirst($ilan->durum) }}</span>
                                        @endif
                                    </td>
                                    <td class="text-secondary">
                                        {{ \Carbon\Carbon::parse($ilan->created_at)->format('H:i') }}
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="5" class="text-center text-secondary py-4">
                                        Bugün henüz ilan oluşturulmamış
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Kan Grubu Dağılımı -->
        <div class="row row-cards">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Kan Grubu Dağılımı</h3>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            @forelse($kanGrubuDagilim as $dagilim)
                            <div class="col-6 col-md-3 mb-3">
                                <div class="d-flex align-items-center">
                                    <span class="avatar avatar-sm me-2 bg-red-lt">
                                        <i class="ti ti-droplet"></i>
                                    </span>
                                    <div>
                                        <div class="font-weight-medium">{{ $dagilim->kan_grubu }}</div>
                                        <div class="text-secondary">{{ $dagilim->sayi }} kullanıcı</div>
                                    </div>
                                </div>
                            </div>
                            @empty
                            <div class="col-12 text-center text-secondary py-3">
                                Henüz kullanıcı bulunmuyor
                            </div>
                            @endforelse
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Son İlanlar -->
        <div class="row row-cards">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Son İlanlar</h3>
                    </div>
                    <div class="list-group list-group-flush">
                        @forelse($sonIlanlar as $ilan)
                        <div class="list-group-item">
                            <div class="row align-items-center">
                                <div class="col-auto">
                                    <span class="badge bg-red-lt">{{ $ilan->kan_grubu }}</span>
                                </div>
                                <div class="col text-truncate">
                                    <div class="text-reset d-block">{{ $ilan->kullanici_ad }} {{ $ilan->kullanici_soyad }}</div>
                                    <div class="text-secondary text-truncate mt-n1">{{ \Carbon\Carbon::parse($ilan->created_at)->diffForHumans() }}</div>
                                </div>
                            </div>
                        </div>
                        @empty
                        <div class="list-group-item text-center text-secondary py-3">
                            Henüz ilan bulunmuyor
                        </div>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
