@extends('layouts.admin')

@section('title', 'Bölge Tanımlamaları')

@section('content')
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <h2 class="page-title">
                    Bölge Tanımlamaları
                </h2>
                <div class="page-pretitle">
                    İl, İlçe ve Belde/Semt Yönetimi
                </div>
            </div>
            <div class="col-auto ms-auto">
                <a href="{{ route('admin.bolge-tanimlamalari.create', ['tur' => 'il']) }}" class="btn btn-primary">
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                        <line x1="12" y1="5" x2="12" y2="19" />
                        <line x1="5" y1="12" x2="19" y2="12" />
                    </svg>
                    Yeni İl Ekle
                </a>
            </div>
        </div>
    </div>
</div>

<div class="page-body">
    <div class="container-xl">
        @if(session('success'))
            <div class="alert alert-success alert-dismissible" role="alert">
                <div class="d-flex">
                    <div>{{ session('success') }}</div>
                </div>
                <a class="btn-close" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
        @endif
        
        @if(session('error'))
            <div class="alert alert-danger alert-dismissible" role="alert">
                <div class="d-flex">
                    <div>{{ session('error') }}</div>
                </div>
                <a class="btn-close" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
        @endif
        
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Bölge Hiyerarşisi</h3>
                    </div>
                    <div class="card-body">
                        @if($iller->count() > 0)
                            <div class="list-group list-group-flush">
                                @foreach($iller as $il)
                                    <div class="list-group-item">
                                        <div class="row align-items-center">
                                            <div class="col">
                                                <strong>📍 {{ $il->ad }}</strong>
                                            </div>
                                            <div class="col-auto">
                                                <a href="{{ route('admin.bolge-tanimlamalari.create', ['tur' => 'ilce', 'parent_id' => $il->id]) }}" class="btn btn-sm btn-success">
                                                    + İlçe Ekle
                                                </a>
                                                <a href="{{ route('admin.bolge-tanimlamalari.edit', ['id' => $il->id, 'tur' => 'il']) }}" class="btn btn-sm btn-primary">
                                                    Düzenle
                                                </a>
                                                <form method="POST" action="{{ route('admin.bolge-tanimlamalari.destroy', $il->id) }}" style="display: inline-block;" onsubmit="return confirm('Bu ili silmek istediğinizden emin misiniz?');">
                                                    @csrf
                                                    @method('DELETE')
                                                    <input type="hidden" name="tur" value="il">
                                                    <button type="submit" class="btn btn-sm btn-danger">Sil</button>
                                                </form>
                                            </div>
                                        </div>
                                        
                                        @if(isset($ilceler[$il->id]) && $ilceler[$il->id]->count() > 0)
                                            <div class="ms-4 mt-2">
                                                @foreach($ilceler[$il->id] as $ilce)
                                                    <div class="list-group-item bg-light">
                                                        <div class="row align-items-center">
                                                            <div class="col">
                                                                <strong>📌 {{ $ilce->ad }}</strong>
                                                            </div>
                                                            <div class="col-auto">
                                                                <a href="{{ route('admin.bolge-tanimlamalari.create', ['tur' => 'belde', 'parent_id' => $ilce->id]) }}" class="btn btn-sm btn-success">
                                                                    + Belde/Semt Ekle
                                                                </a>
                                                                <a href="{{ route('admin.bolge-tanimlamalari.edit', ['id' => $ilce->id, 'tur' => 'ilce']) }}" class="btn btn-sm btn-primary">
                                                                    Düzenle
                                                                </a>
                                                                <form method="POST" action="{{ route('admin.bolge-tanimlamalari.destroy', $ilce->id) }}" style="display: inline-block;" onsubmit="return confirm('Bu ilçeyi silmek istediğinizden emin misiniz?');">
                                                                    @csrf
                                                                    @method('DELETE')
                                                                    <input type="hidden" name="tur" value="ilce">
                                                                    <button type="submit" class="btn btn-sm btn-danger">Sil</button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                        
                                                        @if(isset($beldeler[$ilce->id]) && $beldeler[$ilce->id]->count() > 0)
                                                            <div class="ms-4 mt-2">
                                                                @foreach($beldeler[$ilce->id] as $belde)
                                                                    <div class="list-group-item">
                                                                        <div class="row align-items-center">
                                                                            <div class="col">
                                                                                <strong>🏘️ {{ $belde->ad }}</strong>
                                                                            </div>
                                                                            <div class="col-auto">
                                                                                <a href="{{ route('admin.bolge-tanimlamalari.edit', ['id' => $belde->id, 'tur' => 'belde']) }}" class="btn btn-sm btn-primary">
                                                                                    Düzenle
                                                                                </a>
                                                                                <form method="POST" action="{{ route('admin.bolge-tanimlamalari.destroy', $belde->id) }}" style="display: inline-block;" onsubmit="return confirm('Bu beldeyi silmek istediğinizden emin misiniz?');">
                                                                                    @csrf
                                                                                    @method('DELETE')
                                                                                    <input type="hidden" name="tur" value="belde">
                                                                                    <button type="submit" class="btn btn-sm btn-danger">Sil</button>
                                                                                </form>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                @endforeach
                                                            </div>
                                                        @endif
                                                    </div>
                                                @endforeach
                                            </div>
                                        @endif
                                    </div>
                                @endforeach
                            </div>
                        @else
                            <div class="empty">
                                <div class="empty-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                        <circle cx="12" cy="12" r="9" />
                                        <path d="M9 10h.01" />
                                        <path d="M15 10h.01" />
                                        <path d="M9.5 15a3.5 3.5 0 0 0 5 0" />
                                    </svg>
                                </div>
                                <p class="empty-title">Henüz bölge tanımlanmamış</p>
                                <p class="empty-subtitle text-muted">
                                    Başlamak için yukarıdaki "Yeni İl Ekle" butonunu kullanın
                                </p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
